/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfiguration;
import software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainName
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainName> {
    private static final SdkField<String> API_MAPPING_SELECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainName.getter(DomainName::apiMappingSelectionExpression)).setter(DomainName.setter(Builder::apiMappingSelectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiMappingSelectionExpression").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainName.getter(DomainName::domainName)).setter(DomainName.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<List<DomainNameConfiguration>> DOMAIN_NAME_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DomainName.getter(DomainName::domainNameConfigurations)).setter(DomainName.setter(Builder::domainNameConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainNameConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainNameConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_MAPPING_SELECTION_EXPRESSION_FIELD, DOMAIN_NAME_FIELD, DOMAIN_NAME_CONFIGURATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String apiMappingSelectionExpression;
    private final String domainName;
    private final List<DomainNameConfiguration> domainNameConfigurations;

    private DomainName(BuilderImpl builder) {
        this.apiMappingSelectionExpression = builder.apiMappingSelectionExpression;
        this.domainName = builder.domainName;
        this.domainNameConfigurations = builder.domainNameConfigurations;
    }

    public String apiMappingSelectionExpression() {
        return this.apiMappingSelectionExpression;
    }

    public String domainName() {
        return this.domainName;
    }

    public List<DomainNameConfiguration> domainNameConfigurations() {
        return this.domainNameConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiMappingSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainNameConfigurations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainName)) {
            return false;
        }
        DomainName other = (DomainName)obj;
        return Objects.equals(this.apiMappingSelectionExpression(), other.apiMappingSelectionExpression()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.domainNameConfigurations(), other.domainNameConfigurations());
    }

    public String toString() {
        return ToString.builder((String)"DomainName").add("ApiMappingSelectionExpression", (Object)this.apiMappingSelectionExpression()).add("DomainName", (Object)this.domainName()).add("DomainNameConfigurations", this.domainNameConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiMappingSelectionExpression": {
                return Optional.ofNullable(clazz.cast(this.apiMappingSelectionExpression()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "DomainNameConfigurations": {
                return Optional.ofNullable(clazz.cast(this.domainNameConfigurations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainName, T> g) {
        return obj -> g.apply((DomainName)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String apiMappingSelectionExpression;
        private String domainName;
        private List<DomainNameConfiguration> domainNameConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DomainName model) {
            this.apiMappingSelectionExpression(model.apiMappingSelectionExpression);
            this.domainName(model.domainName);
            this.domainNameConfigurations(model.domainNameConfigurations);
        }

        public final String getApiMappingSelectionExpression() {
            return this.apiMappingSelectionExpression;
        }

        @Override
        public final Builder apiMappingSelectionExpression(String apiMappingSelectionExpression) {
            this.apiMappingSelectionExpression = apiMappingSelectionExpression;
            return this;
        }

        public final void setApiMappingSelectionExpression(String apiMappingSelectionExpression) {
            this.apiMappingSelectionExpression = apiMappingSelectionExpression;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<DomainNameConfiguration.Builder> getDomainNameConfigurations() {
            return this.domainNameConfigurations != null ? (Collection)this.domainNameConfigurations.stream().map(DomainNameConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainNameConfigurations(Collection<DomainNameConfiguration> domainNameConfigurations) {
            this.domainNameConfigurations = DomainNameConfigurationsCopier.copy(domainNameConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainNameConfigurations(DomainNameConfiguration ... domainNameConfigurations) {
            this.domainNameConfigurations(Arrays.asList(domainNameConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainNameConfigurations(Consumer<DomainNameConfiguration.Builder> ... domainNameConfigurations) {
            this.domainNameConfigurations(Stream.of(domainNameConfigurations).map(c -> (DomainNameConfiguration)((DomainNameConfiguration.Builder)DomainNameConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainNameConfigurations(Collection<DomainNameConfiguration.BuilderImpl> domainNameConfigurations) {
            this.domainNameConfigurations = DomainNameConfigurationsCopier.copyFromBuilder(domainNameConfigurations);
        }

        public DomainName build() {
            return new DomainName(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainName> {
        public Builder apiMappingSelectionExpression(String var1);

        public Builder domainName(String var1);

        public Builder domainNameConfigurations(Collection<DomainNameConfiguration> var1);

        public Builder domainNameConfigurations(DomainNameConfiguration ... var1);

        public Builder domainNameConfigurations(Consumer<DomainNameConfiguration.Builder> ... var1);
    }
}

