/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Response;
import software.amazon.awssdk.services.apigatewayv2.model.RoutingRuleAction;
import software.amazon.awssdk.services.apigatewayv2.model.RoutingRuleCondition;
import software.amazon.awssdk.services.apigatewayv2.model.___listOfRoutingRuleActionCopier;
import software.amazon.awssdk.services.apigatewayv2.model.___listOfRoutingRuleConditionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRoutingRuleResponse
extends ApiGatewayV2Response
implements ToCopyableBuilder<Builder, CreateRoutingRuleResponse> {
    private static final SdkField<List<RoutingRuleAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(CreateRoutingRuleResponse.getter(CreateRoutingRuleResponse::actions)).setter(CreateRoutingRuleResponse.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoutingRuleAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RoutingRuleCondition>> CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Conditions").getter(CreateRoutingRuleResponse.getter(CreateRoutingRuleResponse::conditions)).setter(CreateRoutingRuleResponse.setter(Builder::conditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoutingRuleCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(CreateRoutingRuleResponse.getter(CreateRoutingRuleResponse::priority)).setter(CreateRoutingRuleResponse.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<String> ROUTING_RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingRuleArn").getter(CreateRoutingRuleResponse.getter(CreateRoutingRuleResponse::routingRuleArn)).setter(CreateRoutingRuleResponse.setter(Builder::routingRuleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingRuleArn").build()}).build();
    private static final SdkField<String> ROUTING_RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingRuleId").getter(CreateRoutingRuleResponse.getter(CreateRoutingRuleResponse::routingRuleId)).setter(CreateRoutingRuleResponse.setter(Builder::routingRuleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingRuleId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD, CONDITIONS_FIELD, PRIORITY_FIELD, ROUTING_RULE_ARN_FIELD, ROUTING_RULE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRoutingRuleResponse.memberNameToFieldInitializer();
    private final List<RoutingRuleAction> actions;
    private final List<RoutingRuleCondition> conditions;
    private final Integer priority;
    private final String routingRuleArn;
    private final String routingRuleId;

    private CreateRoutingRuleResponse(BuilderImpl builder) {
        super(builder);
        this.actions = builder.actions;
        this.conditions = builder.conditions;
        this.priority = builder.priority;
        this.routingRuleArn = builder.routingRuleArn;
        this.routingRuleId = builder.routingRuleId;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<RoutingRuleAction> actions() {
        return this.actions;
    }

    public final boolean hasConditions() {
        return this.conditions != null && !(this.conditions instanceof SdkAutoConstructList);
    }

    public final List<RoutingRuleCondition> conditions() {
        return this.conditions;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final String routingRuleArn() {
        return this.routingRuleArn;
    }

    public final String routingRuleId() {
        return this.routingRuleId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConditions() ? this.conditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingRuleId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRoutingRuleResponse)) {
            return false;
        }
        CreateRoutingRuleResponse other = (CreateRoutingRuleResponse)((Object)obj);
        return this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && this.hasConditions() == other.hasConditions() && Objects.equals(this.conditions(), other.conditions()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.routingRuleArn(), other.routingRuleArn()) && Objects.equals(this.routingRuleId(), other.routingRuleId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRoutingRuleResponse").add("Actions", this.hasActions() ? this.actions() : null).add("Conditions", this.hasConditions() ? this.conditions() : null).add("Priority", (Object)this.priority()).add("RoutingRuleArn", (Object)this.routingRuleArn()).add("RoutingRuleId", (Object)this.routingRuleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "Conditions": {
                return Optional.ofNullable(clazz.cast(this.conditions()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "RoutingRuleArn": {
                return Optional.ofNullable(clazz.cast(this.routingRuleArn()));
            }
            case "RoutingRuleId": {
                return Optional.ofNullable(clazz.cast(this.routingRuleId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actions", ACTIONS_FIELD);
        map.put("conditions", CONDITIONS_FIELD);
        map.put("priority", PRIORITY_FIELD);
        map.put("routingRuleArn", ROUTING_RULE_ARN_FIELD);
        map.put("routingRuleId", ROUTING_RULE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRoutingRuleResponse, T> g) {
        return obj -> g.apply((CreateRoutingRuleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Response.BuilderImpl
    implements Builder {
        private List<RoutingRuleAction> actions = DefaultSdkAutoConstructList.getInstance();
        private List<RoutingRuleCondition> conditions = DefaultSdkAutoConstructList.getInstance();
        private Integer priority;
        private String routingRuleArn;
        private String routingRuleId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRoutingRuleResponse model) {
            super(model);
            this.actions(model.actions);
            this.conditions(model.conditions);
            this.priority(model.priority);
            this.routingRuleArn(model.routingRuleArn);
            this.routingRuleId(model.routingRuleId);
        }

        public final List<RoutingRuleAction.Builder> getActions() {
            List<RoutingRuleAction.Builder> result = ___listOfRoutingRuleActionCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<RoutingRuleAction.BuilderImpl> actions) {
            this.actions = ___listOfRoutingRuleActionCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<RoutingRuleAction> actions) {
            this.actions = ___listOfRoutingRuleActionCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(RoutingRuleAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<RoutingRuleAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (RoutingRuleAction)((RoutingRuleAction.Builder)RoutingRuleAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RoutingRuleCondition.Builder> getConditions() {
            List<RoutingRuleCondition.Builder> result = ___listOfRoutingRuleConditionCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<RoutingRuleCondition.BuilderImpl> conditions) {
            this.conditions = ___listOfRoutingRuleConditionCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<RoutingRuleCondition> conditions) {
            this.conditions = ___listOfRoutingRuleConditionCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(RoutingRuleCondition ... conditions) {
            this.conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<RoutingRuleCondition.Builder> ... conditions) {
            this.conditions(Stream.of(conditions).map(c -> (RoutingRuleCondition)((RoutingRuleCondition.Builder)RoutingRuleCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getRoutingRuleArn() {
            return this.routingRuleArn;
        }

        public final void setRoutingRuleArn(String routingRuleArn) {
            this.routingRuleArn = routingRuleArn;
        }

        @Override
        public final Builder routingRuleArn(String routingRuleArn) {
            this.routingRuleArn = routingRuleArn;
            return this;
        }

        public final String getRoutingRuleId() {
            return this.routingRuleId;
        }

        public final void setRoutingRuleId(String routingRuleId) {
            this.routingRuleId = routingRuleId;
        }

        @Override
        public final Builder routingRuleId(String routingRuleId) {
            this.routingRuleId = routingRuleId;
            return this;
        }

        @Override
        public CreateRoutingRuleResponse build() {
            return new CreateRoutingRuleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRoutingRuleResponse> {
        public Builder actions(Collection<RoutingRuleAction> var1);

        public Builder actions(RoutingRuleAction ... var1);

        public Builder actions(Consumer<RoutingRuleAction.Builder> ... var1);

        public Builder conditions(Collection<RoutingRuleCondition> var1);

        public Builder conditions(RoutingRuleCondition ... var1);

        public Builder conditions(Consumer<RoutingRuleCondition.Builder> ... var1);

        public Builder priority(Integer var1);

        public Builder routingRuleArn(String var1);

        public Builder routingRuleId(String var1);
    }
}

