/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRoutingRuleRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, DeleteRoutingRuleRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DeleteRoutingRuleRequest.getter(DeleteRoutingRuleRequest::domainName)).setter(DeleteRoutingRuleRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainName").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainNameId").getter(DeleteRoutingRuleRequest.getter(DeleteRoutingRuleRequest::domainNameId)).setter(DeleteRoutingRuleRequest.setter(Builder::domainNameId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domainNameId").build()}).build();
    private static final SdkField<String> ROUTING_RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingRuleId").getter(DeleteRoutingRuleRequest.getter(DeleteRoutingRuleRequest::routingRuleId)).setter(DeleteRoutingRuleRequest.setter(Builder::routingRuleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("routingRuleId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, DOMAIN_NAME_ID_FIELD, ROUTING_RULE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteRoutingRuleRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final String domainNameId;
    private final String routingRuleId;

    private DeleteRoutingRuleRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.domainNameId = builder.domainNameId;
        this.routingRuleId = builder.routingRuleId;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String domainNameId() {
        return this.domainNameId;
    }

    public final String routingRuleId() {
        return this.routingRuleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainNameId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingRuleId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRoutingRuleRequest)) {
            return false;
        }
        DeleteRoutingRuleRequest other = (DeleteRoutingRuleRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.domainNameId(), other.domainNameId()) && Objects.equals(this.routingRuleId(), other.routingRuleId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteRoutingRuleRequest").add("DomainName", (Object)this.domainName()).add("DomainNameId", (Object)this.domainNameId()).add("RoutingRuleId", (Object)this.routingRuleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "DomainNameId": {
                return Optional.ofNullable(clazz.cast(this.domainNameId()));
            }
            case "RoutingRuleId": {
                return Optional.ofNullable(clazz.cast(this.routingRuleId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("domainNameId", DOMAIN_NAME_ID_FIELD);
        map.put("routingRuleId", ROUTING_RULE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteRoutingRuleRequest, T> g) {
        return obj -> g.apply((DeleteRoutingRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private String domainName;
        private String domainNameId;
        private String routingRuleId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRoutingRuleRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.domainNameId(model.domainNameId);
            this.routingRuleId(model.routingRuleId);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getDomainNameId() {
            return this.domainNameId;
        }

        public final void setDomainNameId(String domainNameId) {
            this.domainNameId = domainNameId;
        }

        @Override
        public final Builder domainNameId(String domainNameId) {
            this.domainNameId = domainNameId;
            return this;
        }

        public final String getRoutingRuleId() {
            return this.routingRuleId;
        }

        public final void setRoutingRuleId(String routingRuleId) {
            this.routingRuleId = routingRuleId;
        }

        @Override
        public final Builder routingRuleId(String routingRuleId) {
            this.routingRuleId = routingRuleId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRoutingRuleRequest build() {
            return new DeleteRoutingRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRoutingRuleRequest> {
        public Builder domainName(String var1);

        public Builder domainNameId(String var1);

        public Builder routingRuleId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

