/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfiguration;
import software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfigurationsCopier;
import software.amazon.awssdk.services.apigatewayv2.model.MutualTlsAuthenticationInput;
import software.amazon.awssdk.services.apigatewayv2.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDomainNameRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, CreateDomainNameRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(CreateDomainNameRequest.getter(CreateDomainNameRequest::domainName)).setter(CreateDomainNameRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<List<DomainNameConfiguration>> DOMAIN_NAME_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainNameConfigurations").getter(CreateDomainNameRequest.getter(CreateDomainNameRequest::domainNameConfigurations)).setter(CreateDomainNameRequest.setter(Builder::domainNameConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainNameConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainNameConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MutualTlsAuthenticationInput> MUTUAL_TLS_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MutualTlsAuthentication").getter(CreateDomainNameRequest.getter(CreateDomainNameRequest::mutualTlsAuthentication)).setter(CreateDomainNameRequest.setter(Builder::mutualTlsAuthentication)).constructor(MutualTlsAuthenticationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mutualTlsAuthentication").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateDomainNameRequest.getter(CreateDomainNameRequest::tags)).setter(CreateDomainNameRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, DOMAIN_NAME_CONFIGURATIONS_FIELD, MUTUAL_TLS_AUTHENTICATION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDomainNameRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final List<DomainNameConfiguration> domainNameConfigurations;
    private final MutualTlsAuthenticationInput mutualTlsAuthentication;
    private final Map<String, String> tags;

    private CreateDomainNameRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.domainNameConfigurations = builder.domainNameConfigurations;
        this.mutualTlsAuthentication = builder.mutualTlsAuthentication;
        this.tags = builder.tags;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final boolean hasDomainNameConfigurations() {
        return this.domainNameConfigurations != null && !(this.domainNameConfigurations instanceof SdkAutoConstructList);
    }

    public final List<DomainNameConfiguration> domainNameConfigurations() {
        return this.domainNameConfigurations;
    }

    public final MutualTlsAuthenticationInput mutualTlsAuthentication() {
        return this.mutualTlsAuthentication;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainNameConfigurations() ? this.domainNameConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.mutualTlsAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainNameRequest)) {
            return false;
        }
        CreateDomainNameRequest other = (CreateDomainNameRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && this.hasDomainNameConfigurations() == other.hasDomainNameConfigurations() && Objects.equals(this.domainNameConfigurations(), other.domainNameConfigurations()) && Objects.equals(this.mutualTlsAuthentication(), other.mutualTlsAuthentication()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDomainNameRequest").add("DomainName", (Object)this.domainName()).add("DomainNameConfigurations", this.hasDomainNameConfigurations() ? this.domainNameConfigurations() : null).add("MutualTlsAuthentication", (Object)this.mutualTlsAuthentication()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "DomainNameConfigurations": {
                return Optional.ofNullable(clazz.cast(this.domainNameConfigurations()));
            }
            case "MutualTlsAuthentication": {
                return Optional.ofNullable(clazz.cast(this.mutualTlsAuthentication()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("domainNameConfigurations", DOMAIN_NAME_CONFIGURATIONS_FIELD);
        map.put("mutualTlsAuthentication", MUTUAL_TLS_AUTHENTICATION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainNameRequest, T> g) {
        return obj -> g.apply((CreateDomainNameRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private String domainName;
        private List<DomainNameConfiguration> domainNameConfigurations = DefaultSdkAutoConstructList.getInstance();
        private MutualTlsAuthenticationInput mutualTlsAuthentication;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainNameRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.domainNameConfigurations(model.domainNameConfigurations);
            this.mutualTlsAuthentication(model.mutualTlsAuthentication);
            this.tags(model.tags);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final List<DomainNameConfiguration.Builder> getDomainNameConfigurations() {
            List<DomainNameConfiguration.Builder> result = DomainNameConfigurationsCopier.copyToBuilder(this.domainNameConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainNameConfigurations(Collection<DomainNameConfiguration.BuilderImpl> domainNameConfigurations) {
            this.domainNameConfigurations = DomainNameConfigurationsCopier.copyFromBuilder(domainNameConfigurations);
        }

        @Override
        public final Builder domainNameConfigurations(Collection<DomainNameConfiguration> domainNameConfigurations) {
            this.domainNameConfigurations = DomainNameConfigurationsCopier.copy(domainNameConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainNameConfigurations(DomainNameConfiguration ... domainNameConfigurations) {
            this.domainNameConfigurations(Arrays.asList(domainNameConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainNameConfigurations(Consumer<DomainNameConfiguration.Builder> ... domainNameConfigurations) {
            this.domainNameConfigurations(Stream.of(domainNameConfigurations).map(c -> (DomainNameConfiguration)((DomainNameConfiguration.Builder)DomainNameConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MutualTlsAuthenticationInput.Builder getMutualTlsAuthentication() {
            return this.mutualTlsAuthentication != null ? this.mutualTlsAuthentication.toBuilder() : null;
        }

        public final void setMutualTlsAuthentication(MutualTlsAuthenticationInput.BuilderImpl mutualTlsAuthentication) {
            this.mutualTlsAuthentication = mutualTlsAuthentication != null ? mutualTlsAuthentication.build() : null;
        }

        @Override
        public final Builder mutualTlsAuthentication(MutualTlsAuthenticationInput mutualTlsAuthentication) {
            this.mutualTlsAuthentication = mutualTlsAuthentication;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainNameRequest build() {
            return new CreateDomainNameRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDomainNameRequest> {
        public Builder domainName(String var1);

        public Builder domainNameConfigurations(Collection<DomainNameConfiguration> var1);

        public Builder domainNameConfigurations(DomainNameConfiguration ... var1);

        public Builder domainNameConfigurations(Consumer<DomainNameConfiguration.Builder> ... var1);

        public Builder mutualTlsAuthentication(MutualTlsAuthenticationInput var1);

        default public Builder mutualTlsAuthentication(Consumer<MutualTlsAuthenticationInput.Builder> mutualTlsAuthentication) {
            return this.mutualTlsAuthentication((MutualTlsAuthenticationInput)((MutualTlsAuthenticationInput.Builder)MutualTlsAuthenticationInput.builder().applyMutation(mutualTlsAuthentication)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

