/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apigatewayv2.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JWTConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JWTConfiguration> {
    private static final SdkField<List<String>> AUDIENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Audience").getter(JWTConfiguration.getter(JWTConfiguration::audience)).setter(JWTConfiguration.setter(Builder::audience)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audience").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Issuer").getter(JWTConfiguration.getter(JWTConfiguration::issuer)).setter(JWTConfiguration.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIENCE_FIELD, ISSUER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("audience", AUDIENCE_FIELD);
            this.put("issuer", ISSUER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> audience;
    private final String issuer;

    private JWTConfiguration(BuilderImpl builder) {
        this.audience = builder.audience;
        this.issuer = builder.issuer;
    }

    public final boolean hasAudience() {
        return this.audience != null && !(this.audience instanceof SdkAutoConstructList);
    }

    public final List<String> audience() {
        return this.audience;
    }

    public final String issuer() {
        return this.issuer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudience() ? this.audience() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JWTConfiguration)) {
            return false;
        }
        JWTConfiguration other = (JWTConfiguration)obj;
        return this.hasAudience() == other.hasAudience() && Objects.equals(this.audience(), other.audience()) && Objects.equals(this.issuer(), other.issuer());
    }

    public final String toString() {
        return ToString.builder((String)"JWTConfiguration").add("Audience", this.hasAudience() ? this.audience() : null).add("Issuer", (Object)this.issuer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Audience": {
                return Optional.ofNullable(clazz.cast(this.audience()));
            }
            case "Issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<JWTConfiguration, T> g) {
        return obj -> g.apply((JWTConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> audience = DefaultSdkAutoConstructList.getInstance();
        private String issuer;

        private BuilderImpl() {
        }

        private BuilderImpl(JWTConfiguration model) {
            this.audience(model.audience);
            this.issuer(model.issuer);
        }

        public final Collection<String> getAudience() {
            if (this.audience instanceof SdkAutoConstructList) {
                return null;
            }
            return this.audience;
        }

        public final void setAudience(Collection<String> audience) {
            this.audience = ___listOf__stringCopier.copy(audience);
        }

        @Override
        public final Builder audience(Collection<String> audience) {
            this.audience = ___listOf__stringCopier.copy(audience);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audience(String ... audience) {
            this.audience(Arrays.asList(audience));
            return this;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public JWTConfiguration build() {
            return new JWTConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JWTConfiguration> {
        public Builder audience(Collection<String> var1);

        public Builder audience(String ... var1);

        public Builder issuer(String var1);
    }
}

