/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.services.apigatewayv2.model.Cors;
import software.amazon.awssdk.services.apigatewayv2.model.ProtocolType;
import software.amazon.awssdk.services.apigatewayv2.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApiRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, CreateApiRequest> {
    private static final SdkField<String> API_KEY_SELECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiKeySelectionExpression").getter(CreateApiRequest.getter(CreateApiRequest::apiKeySelectionExpression)).setter(CreateApiRequest.setter(Builder::apiKeySelectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeySelectionExpression").build()}).build();
    private static final SdkField<Cors> CORS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CorsConfiguration").getter(CreateApiRequest.getter(CreateApiRequest::corsConfiguration)).setter(CreateApiRequest.setter(Builder::corsConfiguration)).constructor(Cors::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("corsConfiguration").build()}).build();
    private static final SdkField<String> CREDENTIALS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CredentialsArn").getter(CreateApiRequest.getter(CreateApiRequest::credentialsArn)).setter(CreateApiRequest.setter(Builder::credentialsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateApiRequest.getter(CreateApiRequest::description)).setter(CreateApiRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> DISABLE_SCHEMA_VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableSchemaValidation").getter(CreateApiRequest.getter(CreateApiRequest::disableSchemaValidation)).setter(CreateApiRequest.setter(Builder::disableSchemaValidation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableSchemaValidation").build()}).build();
    private static final SdkField<Boolean> DISABLE_EXECUTE_API_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableExecuteApiEndpoint").getter(CreateApiRequest.getter(CreateApiRequest::disableExecuteApiEndpoint)).setter(CreateApiRequest.setter(Builder::disableExecuteApiEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableExecuteApiEndpoint").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateApiRequest.getter(CreateApiRequest::name)).setter(CreateApiRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROTOCOL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtocolType").getter(CreateApiRequest.getter(CreateApiRequest::protocolTypeAsString)).setter(CreateApiRequest.setter(Builder::protocolType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolType").build()}).build();
    private static final SdkField<String> ROUTE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteKey").getter(CreateApiRequest.getter(CreateApiRequest::routeKey)).setter(CreateApiRequest.setter(Builder::routeKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeKey").build()}).build();
    private static final SdkField<String> ROUTE_SELECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteSelectionExpression").getter(CreateApiRequest.getter(CreateApiRequest::routeSelectionExpression)).setter(CreateApiRequest.setter(Builder::routeSelectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeSelectionExpression").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateApiRequest.getter(CreateApiRequest::tags)).setter(CreateApiRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Target").getter(CreateApiRequest.getter(CreateApiRequest::target)).setter(CreateApiRequest.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(CreateApiRequest.getter(CreateApiRequest::version)).setter(CreateApiRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_KEY_SELECTION_EXPRESSION_FIELD, CORS_CONFIGURATION_FIELD, CREDENTIALS_ARN_FIELD, DESCRIPTION_FIELD, DISABLE_SCHEMA_VALIDATION_FIELD, DISABLE_EXECUTE_API_ENDPOINT_FIELD, NAME_FIELD, PROTOCOL_TYPE_FIELD, ROUTE_KEY_FIELD, ROUTE_SELECTION_EXPRESSION_FIELD, TAGS_FIELD, TARGET_FIELD, VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("apiKeySelectionExpression", API_KEY_SELECTION_EXPRESSION_FIELD);
            this.put("corsConfiguration", CORS_CONFIGURATION_FIELD);
            this.put("credentialsArn", CREDENTIALS_ARN_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("disableSchemaValidation", DISABLE_SCHEMA_VALIDATION_FIELD);
            this.put("disableExecuteApiEndpoint", DISABLE_EXECUTE_API_ENDPOINT_FIELD);
            this.put("name", NAME_FIELD);
            this.put("protocolType", PROTOCOL_TYPE_FIELD);
            this.put("routeKey", ROUTE_KEY_FIELD);
            this.put("routeSelectionExpression", ROUTE_SELECTION_EXPRESSION_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("target", TARGET_FIELD);
            this.put("version", VERSION_FIELD);
        }
    });
    private final String apiKeySelectionExpression;
    private final Cors corsConfiguration;
    private final String credentialsArn;
    private final String description;
    private final Boolean disableSchemaValidation;
    private final Boolean disableExecuteApiEndpoint;
    private final String name;
    private final String protocolType;
    private final String routeKey;
    private final String routeSelectionExpression;
    private final Map<String, String> tags;
    private final String target;
    private final String version;

    private CreateApiRequest(BuilderImpl builder) {
        super(builder);
        this.apiKeySelectionExpression = builder.apiKeySelectionExpression;
        this.corsConfiguration = builder.corsConfiguration;
        this.credentialsArn = builder.credentialsArn;
        this.description = builder.description;
        this.disableSchemaValidation = builder.disableSchemaValidation;
        this.disableExecuteApiEndpoint = builder.disableExecuteApiEndpoint;
        this.name = builder.name;
        this.protocolType = builder.protocolType;
        this.routeKey = builder.routeKey;
        this.routeSelectionExpression = builder.routeSelectionExpression;
        this.tags = builder.tags;
        this.target = builder.target;
        this.version = builder.version;
    }

    public final String apiKeySelectionExpression() {
        return this.apiKeySelectionExpression;
    }

    public final Cors corsConfiguration() {
        return this.corsConfiguration;
    }

    public final String credentialsArn() {
        return this.credentialsArn;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean disableSchemaValidation() {
        return this.disableSchemaValidation;
    }

    public final Boolean disableExecuteApiEndpoint() {
        return this.disableExecuteApiEndpoint;
    }

    public final String name() {
        return this.name;
    }

    public final ProtocolType protocolType() {
        return ProtocolType.fromValue(this.protocolType);
    }

    public final String protocolTypeAsString() {
        return this.protocolType;
    }

    public final String routeKey() {
        return this.routeKey;
    }

    public final String routeSelectionExpression() {
        return this.routeSelectionExpression;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String target() {
        return this.target;
    }

    public final String version() {
        return this.version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeySelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.corsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableSchemaValidation());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableExecuteApiEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApiRequest)) {
            return false;
        }
        CreateApiRequest other = (CreateApiRequest)((Object)obj);
        return Objects.equals(this.apiKeySelectionExpression(), other.apiKeySelectionExpression()) && Objects.equals(this.corsConfiguration(), other.corsConfiguration()) && Objects.equals(this.credentialsArn(), other.credentialsArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.disableSchemaValidation(), other.disableSchemaValidation()) && Objects.equals(this.disableExecuteApiEndpoint(), other.disableExecuteApiEndpoint()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.protocolTypeAsString(), other.protocolTypeAsString()) && Objects.equals(this.routeKey(), other.routeKey()) && Objects.equals(this.routeSelectionExpression(), other.routeSelectionExpression()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"CreateApiRequest").add("ApiKeySelectionExpression", (Object)this.apiKeySelectionExpression()).add("CorsConfiguration", (Object)this.corsConfiguration()).add("CredentialsArn", (Object)this.credentialsArn()).add("Description", (Object)this.description()).add("DisableSchemaValidation", (Object)this.disableSchemaValidation()).add("DisableExecuteApiEndpoint", (Object)this.disableExecuteApiEndpoint()).add("Name", (Object)this.name()).add("ProtocolType", (Object)this.protocolTypeAsString()).add("RouteKey", (Object)this.routeKey()).add("RouteSelectionExpression", (Object)this.routeSelectionExpression()).add("Tags", this.hasTags() ? this.tags() : null).add("Target", (Object)this.target()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiKeySelectionExpression": {
                return Optional.ofNullable(clazz.cast(this.apiKeySelectionExpression()));
            }
            case "CorsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.corsConfiguration()));
            }
            case "CredentialsArn": {
                return Optional.ofNullable(clazz.cast(this.credentialsArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisableSchemaValidation": {
                return Optional.ofNullable(clazz.cast(this.disableSchemaValidation()));
            }
            case "DisableExecuteApiEndpoint": {
                return Optional.ofNullable(clazz.cast(this.disableExecuteApiEndpoint()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ProtocolType": {
                return Optional.ofNullable(clazz.cast(this.protocolTypeAsString()));
            }
            case "RouteKey": {
                return Optional.ofNullable(clazz.cast(this.routeKey()));
            }
            case "RouteSelectionExpression": {
                return Optional.ofNullable(clazz.cast(this.routeSelectionExpression()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateApiRequest, T> g) {
        return obj -> g.apply((CreateApiRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private String apiKeySelectionExpression;
        private Cors corsConfiguration;
        private String credentialsArn;
        private String description;
        private Boolean disableSchemaValidation;
        private Boolean disableExecuteApiEndpoint;
        private String name;
        private String protocolType;
        private String routeKey;
        private String routeSelectionExpression;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String target;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApiRequest model) {
            super(model);
            this.apiKeySelectionExpression(model.apiKeySelectionExpression);
            this.corsConfiguration(model.corsConfiguration);
            this.credentialsArn(model.credentialsArn);
            this.description(model.description);
            this.disableSchemaValidation(model.disableSchemaValidation);
            this.disableExecuteApiEndpoint(model.disableExecuteApiEndpoint);
            this.name(model.name);
            this.protocolType(model.protocolType);
            this.routeKey(model.routeKey);
            this.routeSelectionExpression(model.routeSelectionExpression);
            this.tags(model.tags);
            this.target(model.target);
            this.version(model.version);
        }

        public final String getApiKeySelectionExpression() {
            return this.apiKeySelectionExpression;
        }

        public final void setApiKeySelectionExpression(String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
        }

        @Override
        public final Builder apiKeySelectionExpression(String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
            return this;
        }

        public final Cors.Builder getCorsConfiguration() {
            return this.corsConfiguration != null ? this.corsConfiguration.toBuilder() : null;
        }

        public final void setCorsConfiguration(Cors.BuilderImpl corsConfiguration) {
            this.corsConfiguration = corsConfiguration != null ? corsConfiguration.build() : null;
        }

        @Override
        public final Builder corsConfiguration(Cors corsConfiguration) {
            this.corsConfiguration = corsConfiguration;
            return this;
        }

        public final String getCredentialsArn() {
            return this.credentialsArn;
        }

        public final void setCredentialsArn(String credentialsArn) {
            this.credentialsArn = credentialsArn;
        }

        @Override
        public final Builder credentialsArn(String credentialsArn) {
            this.credentialsArn = credentialsArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getDisableSchemaValidation() {
            return this.disableSchemaValidation;
        }

        public final void setDisableSchemaValidation(Boolean disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
        }

        @Override
        public final Builder disableSchemaValidation(Boolean disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
            return this;
        }

        public final Boolean getDisableExecuteApiEndpoint() {
            return this.disableExecuteApiEndpoint;
        }

        public final void setDisableExecuteApiEndpoint(Boolean disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
        }

        @Override
        public final Builder disableExecuteApiEndpoint(Boolean disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProtocolType() {
            return this.protocolType;
        }

        public final void setProtocolType(String protocolType) {
            this.protocolType = protocolType;
        }

        @Override
        public final Builder protocolType(String protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        @Override
        public final Builder protocolType(ProtocolType protocolType) {
            this.protocolType(protocolType == null ? null : protocolType.toString());
            return this;
        }

        public final String getRouteKey() {
            return this.routeKey;
        }

        public final void setRouteKey(String routeKey) {
            this.routeKey = routeKey;
        }

        @Override
        public final Builder routeKey(String routeKey) {
            this.routeKey = routeKey;
            return this;
        }

        public final String getRouteSelectionExpression() {
            return this.routeSelectionExpression;
        }

        public final void setRouteSelectionExpression(String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
        }

        @Override
        public final Builder routeSelectionExpression(String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApiRequest build() {
            return new CreateApiRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApiRequest> {
        public Builder apiKeySelectionExpression(String var1);

        public Builder corsConfiguration(Cors var1);

        default public Builder corsConfiguration(Consumer<Cors.Builder> corsConfiguration) {
            return this.corsConfiguration((Cors)((Cors.Builder)Cors.builder().applyMutation(corsConfiguration)).build());
        }

        public Builder credentialsArn(String var1);

        public Builder description(String var1);

        public Builder disableSchemaValidation(Boolean var1);

        public Builder disableExecuteApiEndpoint(Boolean var1);

        public Builder name(String var1);

        public Builder protocolType(String var1);

        public Builder protocolType(ProtocolType var1);

        public Builder routeKey(String var1);

        public Builder routeSelectionExpression(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder target(String var1);

        public Builder version(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

