/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRouteResponsesRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, GetRouteResponsesRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiId").getter(GetRouteResponsesRequest.getter(GetRouteResponsesRequest::apiId)).setter(GetRouteResponsesRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<String> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxResults").getter(GetRouteResponsesRequest.getter(GetRouteResponsesRequest::maxResults)).setter(GetRouteResponsesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetRouteResponsesRequest.getter(GetRouteResponsesRequest::nextToken)).setter(GetRouteResponsesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> ROUTE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteId").getter(GetRouteResponsesRequest.getter(GetRouteResponsesRequest::routeId)).setter(GetRouteResponsesRequest.setter(Builder::routeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("routeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ROUTE_ID_FIELD));
    private final String apiId;
    private final String maxResults;
    private final String nextToken;
    private final String routeId;

    private GetRouteResponsesRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.routeId = builder.routeId;
    }

    public final String apiId() {
        return this.apiId;
    }

    public final String maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String routeId() {
        return this.routeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRouteResponsesRequest)) {
            return false;
        }
        GetRouteResponsesRequest other = (GetRouteResponsesRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.routeId(), other.routeId());
    }

    public final String toString() {
        return ToString.builder((String)"GetRouteResponsesRequest").add("ApiId", (Object)this.apiId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("RouteId", (Object)this.routeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RouteId": {
                return Optional.ofNullable(clazz.cast(this.routeId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRouteResponsesRequest, T> g) {
        return obj -> g.apply((GetRouteResponsesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private String apiId;
        private String maxResults;
        private String nextToken;
        private String routeId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRouteResponsesRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.routeId(model.routeId);
        }

        public final String getApiId() {
            return this.apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(String maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(String maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRouteId() {
            return this.routeId;
        }

        public final void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        @Override
        public final Builder routeId(String routeId) {
            this.routeId = routeId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRouteResponsesRequest build() {
            return new GetRouteResponsesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRouteResponsesRequest> {
        public Builder apiId(String var1);

        public Builder maxResults(String var1);

        public Builder nextToken(String var1);

        public Builder routeId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

