/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.apigatewayv2.ApiGatewayV2AsyncClient;
import software.amazon.awssdk.services.apigatewayv2.ApiGatewayV2AsyncClientBuilder;
import software.amazon.awssdk.services.apigatewayv2.ApiGatewayV2ServiceClientConfiguration;
import software.amazon.awssdk.services.apigatewayv2.DefaultApiGatewayV2AsyncClient;
import software.amazon.awssdk.services.apigatewayv2.DefaultApiGatewayV2BaseClientBuilder;
import software.amazon.awssdk.services.apigatewayv2.endpoints.ApiGatewayV2EndpointProvider;

@SdkInternalApi
final class DefaultApiGatewayV2AsyncClientBuilder
extends DefaultApiGatewayV2BaseClientBuilder<ApiGatewayV2AsyncClientBuilder, ApiGatewayV2AsyncClient>
implements ApiGatewayV2AsyncClientBuilder {
    DefaultApiGatewayV2AsyncClientBuilder() {
    }

    @Override
    public DefaultApiGatewayV2AsyncClientBuilder endpointProvider(ApiGatewayV2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ApiGatewayV2AsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultApiGatewayV2AsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        ApiGatewayV2ServiceClientConfiguration serviceClientConfiguration = ApiGatewayV2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultApiGatewayV2AsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

