/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.LoggingLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteSettings> {
    private static final SdkField<Boolean> DATA_TRACE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DataTraceEnabled").getter(RouteSettings.getter(RouteSettings::dataTraceEnabled)).setter(RouteSettings.setter(Builder::dataTraceEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTraceEnabled").build()}).build();
    private static final SdkField<Boolean> DETAILED_METRICS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DetailedMetricsEnabled").getter(RouteSettings.getter(RouteSettings::detailedMetricsEnabled)).setter(RouteSettings.setter(Builder::detailedMetricsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detailedMetricsEnabled").build()}).build();
    private static final SdkField<String> LOGGING_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoggingLevel").getter(RouteSettings.getter(RouteSettings::loggingLevelAsString)).setter(RouteSettings.setter(Builder::loggingLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingLevel").build()}).build();
    private static final SdkField<Integer> THROTTLING_BURST_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThrottlingBurstLimit").getter(RouteSettings.getter(RouteSettings::throttlingBurstLimit)).setter(RouteSettings.setter(Builder::throttlingBurstLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throttlingBurstLimit").build()}).build();
    private static final SdkField<Double> THROTTLING_RATE_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ThrottlingRateLimit").getter(RouteSettings.getter(RouteSettings::throttlingRateLimit)).setter(RouteSettings.setter(Builder::throttlingRateLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throttlingRateLimit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TRACE_ENABLED_FIELD, DETAILED_METRICS_ENABLED_FIELD, LOGGING_LEVEL_FIELD, THROTTLING_BURST_LIMIT_FIELD, THROTTLING_RATE_LIMIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean dataTraceEnabled;
    private final Boolean detailedMetricsEnabled;
    private final String loggingLevel;
    private final Integer throttlingBurstLimit;
    private final Double throttlingRateLimit;

    private RouteSettings(BuilderImpl builder) {
        this.dataTraceEnabled = builder.dataTraceEnabled;
        this.detailedMetricsEnabled = builder.detailedMetricsEnabled;
        this.loggingLevel = builder.loggingLevel;
        this.throttlingBurstLimit = builder.throttlingBurstLimit;
        this.throttlingRateLimit = builder.throttlingRateLimit;
    }

    public final Boolean dataTraceEnabled() {
        return this.dataTraceEnabled;
    }

    public final Boolean detailedMetricsEnabled() {
        return this.detailedMetricsEnabled;
    }

    public final LoggingLevel loggingLevel() {
        return LoggingLevel.fromValue(this.loggingLevel);
    }

    public final String loggingLevelAsString() {
        return this.loggingLevel;
    }

    public final Integer throttlingBurstLimit() {
        return this.throttlingBurstLimit;
    }

    public final Double throttlingRateLimit() {
        return this.throttlingRateLimit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTraceEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.detailedMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.throttlingBurstLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.throttlingRateLimit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteSettings)) {
            return false;
        }
        RouteSettings other = (RouteSettings)obj;
        return Objects.equals(this.dataTraceEnabled(), other.dataTraceEnabled()) && Objects.equals(this.detailedMetricsEnabled(), other.detailedMetricsEnabled()) && Objects.equals(this.loggingLevelAsString(), other.loggingLevelAsString()) && Objects.equals(this.throttlingBurstLimit(), other.throttlingBurstLimit()) && Objects.equals(this.throttlingRateLimit(), other.throttlingRateLimit());
    }

    public final String toString() {
        return ToString.builder((String)"RouteSettings").add("DataTraceEnabled", (Object)this.dataTraceEnabled()).add("DetailedMetricsEnabled", (Object)this.detailedMetricsEnabled()).add("LoggingLevel", (Object)this.loggingLevelAsString()).add("ThrottlingBurstLimit", (Object)this.throttlingBurstLimit()).add("ThrottlingRateLimit", (Object)this.throttlingRateLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataTraceEnabled": {
                return Optional.ofNullable(clazz.cast(this.dataTraceEnabled()));
            }
            case "DetailedMetricsEnabled": {
                return Optional.ofNullable(clazz.cast(this.detailedMetricsEnabled()));
            }
            case "LoggingLevel": {
                return Optional.ofNullable(clazz.cast(this.loggingLevelAsString()));
            }
            case "ThrottlingBurstLimit": {
                return Optional.ofNullable(clazz.cast(this.throttlingBurstLimit()));
            }
            case "ThrottlingRateLimit": {
                return Optional.ofNullable(clazz.cast(this.throttlingRateLimit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RouteSettings, T> g) {
        return obj -> g.apply((RouteSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean dataTraceEnabled;
        private Boolean detailedMetricsEnabled;
        private String loggingLevel;
        private Integer throttlingBurstLimit;
        private Double throttlingRateLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteSettings model) {
            this.dataTraceEnabled(model.dataTraceEnabled);
            this.detailedMetricsEnabled(model.detailedMetricsEnabled);
            this.loggingLevel(model.loggingLevel);
            this.throttlingBurstLimit(model.throttlingBurstLimit);
            this.throttlingRateLimit(model.throttlingRateLimit);
        }

        public final Boolean getDataTraceEnabled() {
            return this.dataTraceEnabled;
        }

        @Override
        public final Builder dataTraceEnabled(Boolean dataTraceEnabled) {
            this.dataTraceEnabled = dataTraceEnabled;
            return this;
        }

        public final void setDataTraceEnabled(Boolean dataTraceEnabled) {
            this.dataTraceEnabled = dataTraceEnabled;
        }

        public final Boolean getDetailedMetricsEnabled() {
            return this.detailedMetricsEnabled;
        }

        @Override
        public final Builder detailedMetricsEnabled(Boolean detailedMetricsEnabled) {
            this.detailedMetricsEnabled = detailedMetricsEnabled;
            return this;
        }

        public final void setDetailedMetricsEnabled(Boolean detailedMetricsEnabled) {
            this.detailedMetricsEnabled = detailedMetricsEnabled;
        }

        public final String getLoggingLevel() {
            return this.loggingLevel;
        }

        @Override
        public final Builder loggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        @Override
        public final Builder loggingLevel(LoggingLevel loggingLevel) {
            this.loggingLevel(loggingLevel == null ? null : loggingLevel.toString());
            return this;
        }

        public final void setLoggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
        }

        public final Integer getThrottlingBurstLimit() {
            return this.throttlingBurstLimit;
        }

        @Override
        public final Builder throttlingBurstLimit(Integer throttlingBurstLimit) {
            this.throttlingBurstLimit = throttlingBurstLimit;
            return this;
        }

        public final void setThrottlingBurstLimit(Integer throttlingBurstLimit) {
            this.throttlingBurstLimit = throttlingBurstLimit;
        }

        public final Double getThrottlingRateLimit() {
            return this.throttlingRateLimit;
        }

        @Override
        public final Builder throttlingRateLimit(Double throttlingRateLimit) {
            this.throttlingRateLimit = throttlingRateLimit;
            return this;
        }

        public final void setThrottlingRateLimit(Double throttlingRateLimit) {
            this.throttlingRateLimit = throttlingRateLimit;
        }

        public RouteSettings build() {
            return new RouteSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteSettings> {
        public Builder dataTraceEnabled(Boolean var1);

        public Builder detailedMetricsEnabled(Boolean var1);

        public Builder loggingLevel(String var1);

        public Builder loggingLevel(LoggingLevel var1);

        public Builder throttlingBurstLimit(Integer var1);

        public Builder throttlingRateLimit(Double var1);
    }
}

