/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApiMappingRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, UpdateApiMappingRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiId").getter(UpdateApiMappingRequest.getter(UpdateApiMappingRequest::apiId)).setter(UpdateApiMappingRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiId").build()}).build();
    private static final SdkField<String> API_MAPPING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiMappingId").getter(UpdateApiMappingRequest.getter(UpdateApiMappingRequest::apiMappingId)).setter(UpdateApiMappingRequest.setter(Builder::apiMappingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiMappingId").build()}).build();
    private static final SdkField<String> API_MAPPING_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiMappingKey").getter(UpdateApiMappingRequest.getter(UpdateApiMappingRequest::apiMappingKey)).setter(UpdateApiMappingRequest.setter(Builder::apiMappingKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiMappingKey").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(UpdateApiMappingRequest.getter(UpdateApiMappingRequest::domainName)).setter(UpdateApiMappingRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainName").build()}).build();
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Stage").getter(UpdateApiMappingRequest.getter(UpdateApiMappingRequest::stage)).setter(UpdateApiMappingRequest.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, API_MAPPING_ID_FIELD, API_MAPPING_KEY_FIELD, DOMAIN_NAME_FIELD, STAGE_FIELD));
    private final String apiId;
    private final String apiMappingId;
    private final String apiMappingKey;
    private final String domainName;
    private final String stage;

    private UpdateApiMappingRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.apiMappingId = builder.apiMappingId;
        this.apiMappingKey = builder.apiMappingKey;
        this.domainName = builder.domainName;
        this.stage = builder.stage;
    }

    public String apiId() {
        return this.apiId;
    }

    public String apiMappingId() {
        return this.apiMappingId;
    }

    public String apiMappingKey() {
        return this.apiMappingKey;
    }

    public String domainName() {
        return this.domainName;
    }

    public String stage() {
        return this.stage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiMappingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiMappingKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApiMappingRequest)) {
            return false;
        }
        UpdateApiMappingRequest other = (UpdateApiMappingRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.apiMappingId(), other.apiMappingId()) && Objects.equals(this.apiMappingKey(), other.apiMappingKey()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.stage(), other.stage());
    }

    public String toString() {
        return ToString.builder((String)"UpdateApiMappingRequest").add("ApiId", (Object)this.apiId()).add("ApiMappingId", (Object)this.apiMappingId()).add("ApiMappingKey", (Object)this.apiMappingKey()).add("DomainName", (Object)this.domainName()).add("Stage", (Object)this.stage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "ApiMappingId": {
                return Optional.ofNullable(clazz.cast(this.apiMappingId()));
            }
            case "ApiMappingKey": {
                return Optional.ofNullable(clazz.cast(this.apiMappingKey()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "Stage": {
                return Optional.ofNullable(clazz.cast(this.stage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApiMappingRequest, T> g) {
        return obj -> g.apply((UpdateApiMappingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private String apiId;
        private String apiMappingId;
        private String apiMappingKey;
        private String domainName;
        private String stage;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApiMappingRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.apiMappingId(model.apiMappingId);
            this.apiMappingKey(model.apiMappingKey);
            this.domainName(model.domainName);
            this.stage(model.stage);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getApiMappingId() {
            return this.apiMappingId;
        }

        @Override
        public final Builder apiMappingId(String apiMappingId) {
            this.apiMappingId = apiMappingId;
            return this;
        }

        public final void setApiMappingId(String apiMappingId) {
            this.apiMappingId = apiMappingId;
        }

        public final String getApiMappingKey() {
            return this.apiMappingKey;
        }

        @Override
        public final Builder apiMappingKey(String apiMappingKey) {
            this.apiMappingKey = apiMappingKey;
            return this;
        }

        public final void setApiMappingKey(String apiMappingKey) {
            this.apiMappingKey = apiMappingKey;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getStage() {
            return this.stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApiMappingRequest build() {
            return new UpdateApiMappingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApiMappingRequest> {
        public Builder apiId(String var1);

        public Builder apiMappingId(String var1);

        public Builder apiMappingKey(String var1);

        public Builder domainName(String var1);

        public Builder stage(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

