/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.services.apigatewayv2.model.ParameterConstraints;
import software.amazon.awssdk.services.apigatewayv2.model.RouteModelsCopier;
import software.amazon.awssdk.services.apigatewayv2.model.RouteParametersCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRouteResponseRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, CreateRouteResponseRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiId").getter(CreateRouteResponseRequest.getter(CreateRouteResponseRequest::apiId)).setter(CreateRouteResponseRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<String> MODEL_SELECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelSelectionExpression").getter(CreateRouteResponseRequest.getter(CreateRouteResponseRequest::modelSelectionExpression)).setter(CreateRouteResponseRequest.setter(Builder::modelSelectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSelectionExpression").build()}).build();
    private static final SdkField<Map<String, String>> RESPONSE_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ResponseModels").getter(CreateRouteResponseRequest.getter(CreateRouteResponseRequest::responseModels)).setter(CreateRouteResponseRequest.setter(Builder::responseModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseModels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ParameterConstraints>> RESPONSE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ResponseParameters").getter(CreateRouteResponseRequest.getter(CreateRouteResponseRequest::responseParameters)).setter(CreateRouteResponseRequest.setter(Builder::responseParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterConstraints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ROUTE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteId").getter(CreateRouteResponseRequest.getter(CreateRouteResponseRequest::routeId)).setter(CreateRouteResponseRequest.setter(Builder::routeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("routeId").build()}).build();
    private static final SdkField<String> ROUTE_RESPONSE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteResponseKey").getter(CreateRouteResponseRequest.getter(CreateRouteResponseRequest::routeResponseKey)).setter(CreateRouteResponseRequest.setter(Builder::routeResponseKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeResponseKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, MODEL_SELECTION_EXPRESSION_FIELD, RESPONSE_MODELS_FIELD, RESPONSE_PARAMETERS_FIELD, ROUTE_ID_FIELD, ROUTE_RESPONSE_KEY_FIELD));
    private final String apiId;
    private final String modelSelectionExpression;
    private final Map<String, String> responseModels;
    private final Map<String, ParameterConstraints> responseParameters;
    private final String routeId;
    private final String routeResponseKey;

    private CreateRouteResponseRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.modelSelectionExpression = builder.modelSelectionExpression;
        this.responseModels = builder.responseModels;
        this.responseParameters = builder.responseParameters;
        this.routeId = builder.routeId;
        this.routeResponseKey = builder.routeResponseKey;
    }

    public String apiId() {
        return this.apiId;
    }

    public String modelSelectionExpression() {
        return this.modelSelectionExpression;
    }

    public boolean hasResponseModels() {
        return this.responseModels != null && !(this.responseModels instanceof SdkAutoConstructMap);
    }

    public Map<String, String> responseModels() {
        return this.responseModels;
    }

    public boolean hasResponseParameters() {
        return this.responseParameters != null && !(this.responseParameters instanceof SdkAutoConstructMap);
    }

    public Map<String, ParameterConstraints> responseParameters() {
        return this.responseParameters;
    }

    public String routeId() {
        return this.routeId;
    }

    public String routeResponseKey() {
        return this.routeResponseKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseModels() ? this.responseModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseParameters() ? this.responseParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.routeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeResponseKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouteResponseRequest)) {
            return false;
        }
        CreateRouteResponseRequest other = (CreateRouteResponseRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.modelSelectionExpression(), other.modelSelectionExpression()) && this.hasResponseModels() == other.hasResponseModels() && Objects.equals(this.responseModels(), other.responseModels()) && this.hasResponseParameters() == other.hasResponseParameters() && Objects.equals(this.responseParameters(), other.responseParameters()) && Objects.equals(this.routeId(), other.routeId()) && Objects.equals(this.routeResponseKey(), other.routeResponseKey());
    }

    public String toString() {
        return ToString.builder((String)"CreateRouteResponseRequest").add("ApiId", (Object)this.apiId()).add("ModelSelectionExpression", (Object)this.modelSelectionExpression()).add("ResponseModels", this.hasResponseModels() ? this.responseModels() : null).add("ResponseParameters", this.hasResponseParameters() ? this.responseParameters() : null).add("RouteId", (Object)this.routeId()).add("RouteResponseKey", (Object)this.routeResponseKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "ModelSelectionExpression": {
                return Optional.ofNullable(clazz.cast(this.modelSelectionExpression()));
            }
            case "ResponseModels": {
                return Optional.ofNullable(clazz.cast(this.responseModels()));
            }
            case "ResponseParameters": {
                return Optional.ofNullable(clazz.cast(this.responseParameters()));
            }
            case "RouteId": {
                return Optional.ofNullable(clazz.cast(this.routeId()));
            }
            case "RouteResponseKey": {
                return Optional.ofNullable(clazz.cast(this.routeResponseKey()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRouteResponseRequest, T> g) {
        return obj -> g.apply((CreateRouteResponseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private String apiId;
        private String modelSelectionExpression;
        private Map<String, String> responseModels = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, ParameterConstraints> responseParameters = DefaultSdkAutoConstructMap.getInstance();
        private String routeId;
        private String routeResponseKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouteResponseRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.modelSelectionExpression(model.modelSelectionExpression);
            this.responseModels(model.responseModels);
            this.responseParameters(model.responseParameters);
            this.routeId(model.routeId);
            this.routeResponseKey(model.routeResponseKey);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getModelSelectionExpression() {
            return this.modelSelectionExpression;
        }

        @Override
        public final Builder modelSelectionExpression(String modelSelectionExpression) {
            this.modelSelectionExpression = modelSelectionExpression;
            return this;
        }

        public final void setModelSelectionExpression(String modelSelectionExpression) {
            this.modelSelectionExpression = modelSelectionExpression;
        }

        public final Map<String, String> getResponseModels() {
            if (this.responseModels instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.responseModels;
        }

        @Override
        public final Builder responseModels(Map<String, String> responseModels) {
            this.responseModels = RouteModelsCopier.copy(responseModels);
            return this;
        }

        public final void setResponseModels(Map<String, String> responseModels) {
            this.responseModels = RouteModelsCopier.copy(responseModels);
        }

        public final Map<String, ParameterConstraints.Builder> getResponseParameters() {
            if (this.responseParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.responseParameters != null ? CollectionUtils.mapValues(this.responseParameters, ParameterConstraints::toBuilder) : null;
        }

        @Override
        public final Builder responseParameters(Map<String, ParameterConstraints> responseParameters) {
            this.responseParameters = RouteParametersCopier.copy(responseParameters);
            return this;
        }

        public final void setResponseParameters(Map<String, ParameterConstraints.BuilderImpl> responseParameters) {
            this.responseParameters = RouteParametersCopier.copyFromBuilder(responseParameters);
        }

        public final String getRouteId() {
            return this.routeId;
        }

        @Override
        public final Builder routeId(String routeId) {
            this.routeId = routeId;
            return this;
        }

        public final void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        public final String getRouteResponseKey() {
            return this.routeResponseKey;
        }

        @Override
        public final Builder routeResponseKey(String routeResponseKey) {
            this.routeResponseKey = routeResponseKey;
            return this;
        }

        public final void setRouteResponseKey(String routeResponseKey) {
            this.routeResponseKey = routeResponseKey;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRouteResponseRequest build() {
            return new CreateRouteResponseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRouteResponseRequest> {
        public Builder apiId(String var1);

        public Builder modelSelectionExpression(String var1);

        public Builder responseModels(Map<String, String> var1);

        public Builder responseParameters(Map<String, ParameterConstraints> var1);

        public Builder routeId(String var1);

        public Builder routeResponseKey(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

