/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Response;
import software.amazon.awssdk.services.apigatewayv2.model.SecurityGroupIdListCopier;
import software.amazon.awssdk.services.apigatewayv2.model.SubnetIdListCopier;
import software.amazon.awssdk.services.apigatewayv2.model.TagsCopier;
import software.amazon.awssdk.services.apigatewayv2.model.VpcLinkStatus;
import software.amazon.awssdk.services.apigatewayv2.model.VpcLinkVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVpcLinkResponse
extends ApiGatewayV2Response
implements ToCopyableBuilder<Builder, UpdateVpcLinkResponse> {
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(UpdateVpcLinkResponse.getter(UpdateVpcLinkResponse::createdDate)).setter(UpdateVpcLinkResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateVpcLinkResponse.getter(UpdateVpcLinkResponse::name)).setter(UpdateVpcLinkResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(UpdateVpcLinkResponse.getter(UpdateVpcLinkResponse::securityGroupIds)).setter(UpdateVpcLinkResponse.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(UpdateVpcLinkResponse.getter(UpdateVpcLinkResponse::subnetIds)).setter(UpdateVpcLinkResponse.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(UpdateVpcLinkResponse.getter(UpdateVpcLinkResponse::tags)).setter(UpdateVpcLinkResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_LINK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcLinkId").getter(UpdateVpcLinkResponse.getter(UpdateVpcLinkResponse::vpcLinkId)).setter(UpdateVpcLinkResponse.setter(Builder::vpcLinkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcLinkId").build()}).build();
    private static final SdkField<String> VPC_LINK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcLinkStatus").getter(UpdateVpcLinkResponse.getter(UpdateVpcLinkResponse::vpcLinkStatusAsString)).setter(UpdateVpcLinkResponse.setter(Builder::vpcLinkStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcLinkStatus").build()}).build();
    private static final SdkField<String> VPC_LINK_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcLinkStatusMessage").getter(UpdateVpcLinkResponse.getter(UpdateVpcLinkResponse::vpcLinkStatusMessage)).setter(UpdateVpcLinkResponse.setter(Builder::vpcLinkStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcLinkStatusMessage").build()}).build();
    private static final SdkField<String> VPC_LINK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcLinkVersion").getter(UpdateVpcLinkResponse.getter(UpdateVpcLinkResponse::vpcLinkVersionAsString)).setter(UpdateVpcLinkResponse.setter(Builder::vpcLinkVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcLinkVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_DATE_FIELD, NAME_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_IDS_FIELD, TAGS_FIELD, VPC_LINK_ID_FIELD, VPC_LINK_STATUS_FIELD, VPC_LINK_STATUS_MESSAGE_FIELD, VPC_LINK_VERSION_FIELD));
    private final Instant createdDate;
    private final String name;
    private final List<String> securityGroupIds;
    private final List<String> subnetIds;
    private final Map<String, String> tags;
    private final String vpcLinkId;
    private final String vpcLinkStatus;
    private final String vpcLinkStatusMessage;
    private final String vpcLinkVersion;

    private UpdateVpcLinkResponse(BuilderImpl builder) {
        super(builder);
        this.createdDate = builder.createdDate;
        this.name = builder.name;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
        this.vpcLinkId = builder.vpcLinkId;
        this.vpcLinkStatus = builder.vpcLinkStatus;
        this.vpcLinkStatusMessage = builder.vpcLinkStatusMessage;
        this.vpcLinkVersion = builder.vpcLinkVersion;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public String name() {
        return this.name;
    }

    public boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String vpcLinkId() {
        return this.vpcLinkId;
    }

    public VpcLinkStatus vpcLinkStatus() {
        return VpcLinkStatus.fromValue(this.vpcLinkStatus);
    }

    public String vpcLinkStatusAsString() {
        return this.vpcLinkStatus;
    }

    public String vpcLinkStatusMessage() {
        return this.vpcLinkStatusMessage;
    }

    public VpcLinkVersion vpcLinkVersion() {
        return VpcLinkVersion.fromValue(this.vpcLinkVersion);
    }

    public String vpcLinkVersionAsString() {
        return this.vpcLinkVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcLinkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcLinkStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcLinkStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcLinkVersionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVpcLinkResponse)) {
            return false;
        }
        UpdateVpcLinkResponse other = (UpdateVpcLinkResponse)((Object)obj);
        return Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpcLinkId(), other.vpcLinkId()) && Objects.equals(this.vpcLinkStatusAsString(), other.vpcLinkStatusAsString()) && Objects.equals(this.vpcLinkStatusMessage(), other.vpcLinkStatusMessage()) && Objects.equals(this.vpcLinkVersionAsString(), other.vpcLinkVersionAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateVpcLinkResponse").add("CreatedDate", (Object)this.createdDate()).add("Name", (Object)this.name()).add("SecurityGroupIds", this.securityGroupIds()).add("SubnetIds", this.subnetIds()).add("Tags", this.tags()).add("VpcLinkId", (Object)this.vpcLinkId()).add("VpcLinkStatus", (Object)this.vpcLinkStatusAsString()).add("VpcLinkStatusMessage", (Object)this.vpcLinkStatusMessage()).add("VpcLinkVersion", (Object)this.vpcLinkVersionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "VpcLinkId": {
                return Optional.ofNullable(clazz.cast(this.vpcLinkId()));
            }
            case "VpcLinkStatus": {
                return Optional.ofNullable(clazz.cast(this.vpcLinkStatusAsString()));
            }
            case "VpcLinkStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.vpcLinkStatusMessage()));
            }
            case "VpcLinkVersion": {
                return Optional.ofNullable(clazz.cast(this.vpcLinkVersionAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVpcLinkResponse, T> g) {
        return obj -> g.apply((UpdateVpcLinkResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Response.BuilderImpl
    implements Builder {
        private Instant createdDate;
        private String name;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String vpcLinkId;
        private String vpcLinkStatus;
        private String vpcLinkStatusMessage;
        private String vpcLinkVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVpcLinkResponse model) {
            super(model);
            this.createdDate(model.createdDate);
            this.name(model.name);
            this.securityGroupIds(model.securityGroupIds);
            this.subnetIds(model.subnetIds);
            this.tags(model.tags);
            this.vpcLinkId(model.vpcLinkId);
            this.vpcLinkStatus(model.vpcLinkStatus);
            this.vpcLinkStatusMessage(model.vpcLinkStatusMessage);
            this.vpcLinkVersion(model.vpcLinkVersion);
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final String getVpcLinkId() {
            return this.vpcLinkId;
        }

        @Override
        public final Builder vpcLinkId(String vpcLinkId) {
            this.vpcLinkId = vpcLinkId;
            return this;
        }

        public final void setVpcLinkId(String vpcLinkId) {
            this.vpcLinkId = vpcLinkId;
        }

        public final String getVpcLinkStatus() {
            return this.vpcLinkStatus;
        }

        @Override
        public final Builder vpcLinkStatus(String vpcLinkStatus) {
            this.vpcLinkStatus = vpcLinkStatus;
            return this;
        }

        @Override
        public final Builder vpcLinkStatus(VpcLinkStatus vpcLinkStatus) {
            this.vpcLinkStatus(vpcLinkStatus == null ? null : vpcLinkStatus.toString());
            return this;
        }

        public final void setVpcLinkStatus(String vpcLinkStatus) {
            this.vpcLinkStatus = vpcLinkStatus;
        }

        public final String getVpcLinkStatusMessage() {
            return this.vpcLinkStatusMessage;
        }

        @Override
        public final Builder vpcLinkStatusMessage(String vpcLinkStatusMessage) {
            this.vpcLinkStatusMessage = vpcLinkStatusMessage;
            return this;
        }

        public final void setVpcLinkStatusMessage(String vpcLinkStatusMessage) {
            this.vpcLinkStatusMessage = vpcLinkStatusMessage;
        }

        public final String getVpcLinkVersion() {
            return this.vpcLinkVersion;
        }

        @Override
        public final Builder vpcLinkVersion(String vpcLinkVersion) {
            this.vpcLinkVersion = vpcLinkVersion;
            return this;
        }

        @Override
        public final Builder vpcLinkVersion(VpcLinkVersion vpcLinkVersion) {
            this.vpcLinkVersion(vpcLinkVersion == null ? null : vpcLinkVersion.toString());
            return this;
        }

        public final void setVpcLinkVersion(String vpcLinkVersion) {
            this.vpcLinkVersion = vpcLinkVersion;
        }

        @Override
        public UpdateVpcLinkResponse build() {
            return new UpdateVpcLinkResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateVpcLinkResponse> {
        public Builder createdDate(Instant var1);

        public Builder name(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder vpcLinkId(String var1);

        public Builder vpcLinkStatus(String var1);

        public Builder vpcLinkStatus(VpcLinkStatus var1);

        public Builder vpcLinkStatusMessage(String var1);

        public Builder vpcLinkVersion(String var1);

        public Builder vpcLinkVersion(VpcLinkVersion var1);
    }
}

