/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.services.apigatewayv2.model.Cors;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApiRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, UpdateApiRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateApiRequest.getter(UpdateApiRequest::apiId)).setter(UpdateApiRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<String> API_KEY_SELECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateApiRequest.getter(UpdateApiRequest::apiKeySelectionExpression)).setter(UpdateApiRequest.setter(Builder::apiKeySelectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeySelectionExpression").build()}).build();
    private static final SdkField<Cors> CORS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateApiRequest.getter(UpdateApiRequest::corsConfiguration)).setter(UpdateApiRequest.setter(Builder::corsConfiguration)).constructor(Cors::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("corsConfiguration").build()}).build();
    private static final SdkField<String> CREDENTIALS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateApiRequest.getter(UpdateApiRequest::credentialsArn)).setter(UpdateApiRequest.setter(Builder::credentialsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateApiRequest.getter(UpdateApiRequest::description)).setter(UpdateApiRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> DISABLE_SCHEMA_VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateApiRequest.getter(UpdateApiRequest::disableSchemaValidation)).setter(UpdateApiRequest.setter(Builder::disableSchemaValidation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableSchemaValidation").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateApiRequest.getter(UpdateApiRequest::name)).setter(UpdateApiRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ROUTE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateApiRequest.getter(UpdateApiRequest::routeKey)).setter(UpdateApiRequest.setter(Builder::routeKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeKey").build()}).build();
    private static final SdkField<String> ROUTE_SELECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateApiRequest.getter(UpdateApiRequest::routeSelectionExpression)).setter(UpdateApiRequest.setter(Builder::routeSelectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeSelectionExpression").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateApiRequest.getter(UpdateApiRequest::target)).setter(UpdateApiRequest.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateApiRequest.getter(UpdateApiRequest::version)).setter(UpdateApiRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, API_KEY_SELECTION_EXPRESSION_FIELD, CORS_CONFIGURATION_FIELD, CREDENTIALS_ARN_FIELD, DESCRIPTION_FIELD, DISABLE_SCHEMA_VALIDATION_FIELD, NAME_FIELD, ROUTE_KEY_FIELD, ROUTE_SELECTION_EXPRESSION_FIELD, TARGET_FIELD, VERSION_FIELD));
    private final String apiId;
    private final String apiKeySelectionExpression;
    private final Cors corsConfiguration;
    private final String credentialsArn;
    private final String description;
    private final Boolean disableSchemaValidation;
    private final String name;
    private final String routeKey;
    private final String routeSelectionExpression;
    private final String target;
    private final String version;

    private UpdateApiRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.apiKeySelectionExpression = builder.apiKeySelectionExpression;
        this.corsConfiguration = builder.corsConfiguration;
        this.credentialsArn = builder.credentialsArn;
        this.description = builder.description;
        this.disableSchemaValidation = builder.disableSchemaValidation;
        this.name = builder.name;
        this.routeKey = builder.routeKey;
        this.routeSelectionExpression = builder.routeSelectionExpression;
        this.target = builder.target;
        this.version = builder.version;
    }

    public String apiId() {
        return this.apiId;
    }

    public String apiKeySelectionExpression() {
        return this.apiKeySelectionExpression;
    }

    public Cors corsConfiguration() {
        return this.corsConfiguration;
    }

    public String credentialsArn() {
        return this.credentialsArn;
    }

    public String description() {
        return this.description;
    }

    public Boolean disableSchemaValidation() {
        return this.disableSchemaValidation;
    }

    public String name() {
        return this.name;
    }

    public String routeKey() {
        return this.routeKey;
    }

    public String routeSelectionExpression() {
        return this.routeSelectionExpression;
    }

    public String target() {
        return this.target;
    }

    public String version() {
        return this.version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeySelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.corsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableSchemaValidation());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApiRequest)) {
            return false;
        }
        UpdateApiRequest other = (UpdateApiRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.apiKeySelectionExpression(), other.apiKeySelectionExpression()) && Objects.equals(this.corsConfiguration(), other.corsConfiguration()) && Objects.equals(this.credentialsArn(), other.credentialsArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.disableSchemaValidation(), other.disableSchemaValidation()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.routeKey(), other.routeKey()) && Objects.equals(this.routeSelectionExpression(), other.routeSelectionExpression()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.version(), other.version());
    }

    public String toString() {
        return ToString.builder((String)"UpdateApiRequest").add("ApiId", (Object)this.apiId()).add("ApiKeySelectionExpression", (Object)this.apiKeySelectionExpression()).add("CorsConfiguration", (Object)this.corsConfiguration()).add("CredentialsArn", (Object)this.credentialsArn()).add("Description", (Object)this.description()).add("DisableSchemaValidation", (Object)this.disableSchemaValidation()).add("Name", (Object)this.name()).add("RouteKey", (Object)this.routeKey()).add("RouteSelectionExpression", (Object)this.routeSelectionExpression()).add("Target", (Object)this.target()).add("Version", (Object)this.version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "ApiKeySelectionExpression": {
                return Optional.ofNullable(clazz.cast(this.apiKeySelectionExpression()));
            }
            case "CorsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.corsConfiguration()));
            }
            case "CredentialsArn": {
                return Optional.ofNullable(clazz.cast(this.credentialsArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisableSchemaValidation": {
                return Optional.ofNullable(clazz.cast(this.disableSchemaValidation()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RouteKey": {
                return Optional.ofNullable(clazz.cast(this.routeKey()));
            }
            case "RouteSelectionExpression": {
                return Optional.ofNullable(clazz.cast(this.routeSelectionExpression()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApiRequest, T> g) {
        return obj -> g.apply((UpdateApiRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private String apiId;
        private String apiKeySelectionExpression;
        private Cors corsConfiguration;
        private String credentialsArn;
        private String description;
        private Boolean disableSchemaValidation;
        private String name;
        private String routeKey;
        private String routeSelectionExpression;
        private String target;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApiRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.apiKeySelectionExpression(model.apiKeySelectionExpression);
            this.corsConfiguration(model.corsConfiguration);
            this.credentialsArn(model.credentialsArn);
            this.description(model.description);
            this.disableSchemaValidation(model.disableSchemaValidation);
            this.name(model.name);
            this.routeKey(model.routeKey);
            this.routeSelectionExpression(model.routeSelectionExpression);
            this.target(model.target);
            this.version(model.version);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getApiKeySelectionExpression() {
            return this.apiKeySelectionExpression;
        }

        @Override
        public final Builder apiKeySelectionExpression(String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
            return this;
        }

        public final void setApiKeySelectionExpression(String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
        }

        public final Cors.Builder getCorsConfiguration() {
            return this.corsConfiguration != null ? this.corsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder corsConfiguration(Cors corsConfiguration) {
            this.corsConfiguration = corsConfiguration;
            return this;
        }

        public final void setCorsConfiguration(Cors.BuilderImpl corsConfiguration) {
            this.corsConfiguration = corsConfiguration != null ? corsConfiguration.build() : null;
        }

        public final String getCredentialsArn() {
            return this.credentialsArn;
        }

        @Override
        public final Builder credentialsArn(String credentialsArn) {
            this.credentialsArn = credentialsArn;
            return this;
        }

        public final void setCredentialsArn(String credentialsArn) {
            this.credentialsArn = credentialsArn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getDisableSchemaValidation() {
            return this.disableSchemaValidation;
        }

        @Override
        public final Builder disableSchemaValidation(Boolean disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
            return this;
        }

        public final void setDisableSchemaValidation(Boolean disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRouteKey() {
            return this.routeKey;
        }

        @Override
        public final Builder routeKey(String routeKey) {
            this.routeKey = routeKey;
            return this;
        }

        public final void setRouteKey(String routeKey) {
            this.routeKey = routeKey;
        }

        public final String getRouteSelectionExpression() {
            return this.routeSelectionExpression;
        }

        @Override
        public final Builder routeSelectionExpression(String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
            return this;
        }

        public final void setRouteSelectionExpression(String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
        }

        public final String getTarget() {
            return this.target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApiRequest build() {
            return new UpdateApiRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApiRequest> {
        public Builder apiId(String var1);

        public Builder apiKeySelectionExpression(String var1);

        public Builder corsConfiguration(Cors var1);

        default public Builder corsConfiguration(Consumer<Cors.Builder> corsConfiguration) {
            return this.corsConfiguration((Cors)((Cors.Builder)Cors.builder().applyMutation(corsConfiguration)).build());
        }

        public Builder credentialsArn(String var1);

        public Builder description(String var1);

        public Builder disableSchemaValidation(Boolean var1);

        public Builder name(String var1);

        public Builder routeKey(String var1);

        public Builder routeSelectionExpression(String var1);

        public Builder target(String var1);

        public Builder version(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

