/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.services.apigatewayv2.model.AuthorizerType;
import software.amazon.awssdk.services.apigatewayv2.model.IdentitySourceListCopier;
import software.amazon.awssdk.services.apigatewayv2.model.JWTConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAuthorizerRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, CreateAuthorizerRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAuthorizerRequest.getter(CreateAuthorizerRequest::apiId)).setter(CreateAuthorizerRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<String> AUTHORIZER_CREDENTIALS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAuthorizerRequest.getter(CreateAuthorizerRequest::authorizerCredentialsArn)).setter(CreateAuthorizerRequest.setter(Builder::authorizerCredentialsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerCredentialsArn").build()}).build();
    private static final SdkField<Integer> AUTHORIZER_RESULT_TTL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateAuthorizerRequest.getter(CreateAuthorizerRequest::authorizerResultTtlInSeconds)).setter(CreateAuthorizerRequest.setter(Builder::authorizerResultTtlInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerResultTtlInSeconds").build()}).build();
    private static final SdkField<String> AUTHORIZER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAuthorizerRequest.getter(CreateAuthorizerRequest::authorizerTypeAsString)).setter(CreateAuthorizerRequest.setter(Builder::authorizerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerType").build()}).build();
    private static final SdkField<String> AUTHORIZER_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAuthorizerRequest.getter(CreateAuthorizerRequest::authorizerUri)).setter(CreateAuthorizerRequest.setter(Builder::authorizerUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerUri").build()}).build();
    private static final SdkField<List<String>> IDENTITY_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateAuthorizerRequest.getter(CreateAuthorizerRequest::identitySource)).setter(CreateAuthorizerRequest.setter(Builder::identitySource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identitySource").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IDENTITY_VALIDATION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAuthorizerRequest.getter(CreateAuthorizerRequest::identityValidationExpression)).setter(CreateAuthorizerRequest.setter(Builder::identityValidationExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityValidationExpression").build()}).build();
    private static final SdkField<JWTConfiguration> JWT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateAuthorizerRequest.getter(CreateAuthorizerRequest::jwtConfiguration)).setter(CreateAuthorizerRequest.setter(Builder::jwtConfiguration)).constructor(JWTConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jwtConfiguration").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAuthorizerRequest.getter(CreateAuthorizerRequest::name)).setter(CreateAuthorizerRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, AUTHORIZER_CREDENTIALS_ARN_FIELD, AUTHORIZER_RESULT_TTL_IN_SECONDS_FIELD, AUTHORIZER_TYPE_FIELD, AUTHORIZER_URI_FIELD, IDENTITY_SOURCE_FIELD, IDENTITY_VALIDATION_EXPRESSION_FIELD, JWT_CONFIGURATION_FIELD, NAME_FIELD));
    private final String apiId;
    private final String authorizerCredentialsArn;
    private final Integer authorizerResultTtlInSeconds;
    private final String authorizerType;
    private final String authorizerUri;
    private final List<String> identitySource;
    private final String identityValidationExpression;
    private final JWTConfiguration jwtConfiguration;
    private final String name;

    private CreateAuthorizerRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.authorizerCredentialsArn = builder.authorizerCredentialsArn;
        this.authorizerResultTtlInSeconds = builder.authorizerResultTtlInSeconds;
        this.authorizerType = builder.authorizerType;
        this.authorizerUri = builder.authorizerUri;
        this.identitySource = builder.identitySource;
        this.identityValidationExpression = builder.identityValidationExpression;
        this.jwtConfiguration = builder.jwtConfiguration;
        this.name = builder.name;
    }

    public String apiId() {
        return this.apiId;
    }

    public String authorizerCredentialsArn() {
        return this.authorizerCredentialsArn;
    }

    public Integer authorizerResultTtlInSeconds() {
        return this.authorizerResultTtlInSeconds;
    }

    public AuthorizerType authorizerType() {
        return AuthorizerType.fromValue(this.authorizerType);
    }

    public String authorizerTypeAsString() {
        return this.authorizerType;
    }

    public String authorizerUri() {
        return this.authorizerUri;
    }

    public List<String> identitySource() {
        return this.identitySource;
    }

    public String identityValidationExpression() {
        return this.identityValidationExpression;
    }

    public JWTConfiguration jwtConfiguration() {
        return this.jwtConfiguration;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerCredentialsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerResultTtlInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.identitySource());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityValidationExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.jwtConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAuthorizerRequest)) {
            return false;
        }
        CreateAuthorizerRequest other = (CreateAuthorizerRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.authorizerCredentialsArn(), other.authorizerCredentialsArn()) && Objects.equals(this.authorizerResultTtlInSeconds(), other.authorizerResultTtlInSeconds()) && Objects.equals(this.authorizerTypeAsString(), other.authorizerTypeAsString()) && Objects.equals(this.authorizerUri(), other.authorizerUri()) && Objects.equals(this.identitySource(), other.identitySource()) && Objects.equals(this.identityValidationExpression(), other.identityValidationExpression()) && Objects.equals(this.jwtConfiguration(), other.jwtConfiguration()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"CreateAuthorizerRequest").add("ApiId", (Object)this.apiId()).add("AuthorizerCredentialsArn", (Object)this.authorizerCredentialsArn()).add("AuthorizerResultTtlInSeconds", (Object)this.authorizerResultTtlInSeconds()).add("AuthorizerType", (Object)this.authorizerTypeAsString()).add("AuthorizerUri", (Object)this.authorizerUri()).add("IdentitySource", this.identitySource()).add("IdentityValidationExpression", (Object)this.identityValidationExpression()).add("JwtConfiguration", (Object)this.jwtConfiguration()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "AuthorizerCredentialsArn": {
                return Optional.ofNullable(clazz.cast(this.authorizerCredentialsArn()));
            }
            case "AuthorizerResultTtlInSeconds": {
                return Optional.ofNullable(clazz.cast(this.authorizerResultTtlInSeconds()));
            }
            case "AuthorizerType": {
                return Optional.ofNullable(clazz.cast(this.authorizerTypeAsString()));
            }
            case "AuthorizerUri": {
                return Optional.ofNullable(clazz.cast(this.authorizerUri()));
            }
            case "IdentitySource": {
                return Optional.ofNullable(clazz.cast(this.identitySource()));
            }
            case "IdentityValidationExpression": {
                return Optional.ofNullable(clazz.cast(this.identityValidationExpression()));
            }
            case "JwtConfiguration": {
                return Optional.ofNullable(clazz.cast(this.jwtConfiguration()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAuthorizerRequest, T> g) {
        return obj -> g.apply((CreateAuthorizerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private String apiId;
        private String authorizerCredentialsArn;
        private Integer authorizerResultTtlInSeconds;
        private String authorizerType;
        private String authorizerUri;
        private List<String> identitySource = DefaultSdkAutoConstructList.getInstance();
        private String identityValidationExpression;
        private JWTConfiguration jwtConfiguration;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAuthorizerRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.authorizerCredentialsArn(model.authorizerCredentialsArn);
            this.authorizerResultTtlInSeconds(model.authorizerResultTtlInSeconds);
            this.authorizerType(model.authorizerType);
            this.authorizerUri(model.authorizerUri);
            this.identitySource(model.identitySource);
            this.identityValidationExpression(model.identityValidationExpression);
            this.jwtConfiguration(model.jwtConfiguration);
            this.name(model.name);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getAuthorizerCredentialsArn() {
            return this.authorizerCredentialsArn;
        }

        @Override
        public final Builder authorizerCredentialsArn(String authorizerCredentialsArn) {
            this.authorizerCredentialsArn = authorizerCredentialsArn;
            return this;
        }

        public final void setAuthorizerCredentialsArn(String authorizerCredentialsArn) {
            this.authorizerCredentialsArn = authorizerCredentialsArn;
        }

        public final Integer getAuthorizerResultTtlInSeconds() {
            return this.authorizerResultTtlInSeconds;
        }

        @Override
        public final Builder authorizerResultTtlInSeconds(Integer authorizerResultTtlInSeconds) {
            this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds;
            return this;
        }

        public final void setAuthorizerResultTtlInSeconds(Integer authorizerResultTtlInSeconds) {
            this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds;
        }

        public final String getAuthorizerTypeAsString() {
            return this.authorizerType;
        }

        @Override
        public final Builder authorizerType(String authorizerType) {
            this.authorizerType = authorizerType;
            return this;
        }

        @Override
        public final Builder authorizerType(AuthorizerType authorizerType) {
            this.authorizerType(authorizerType == null ? null : authorizerType.toString());
            return this;
        }

        public final void setAuthorizerType(String authorizerType) {
            this.authorizerType = authorizerType;
        }

        public final String getAuthorizerUri() {
            return this.authorizerUri;
        }

        @Override
        public final Builder authorizerUri(String authorizerUri) {
            this.authorizerUri = authorizerUri;
            return this;
        }

        public final void setAuthorizerUri(String authorizerUri) {
            this.authorizerUri = authorizerUri;
        }

        public final Collection<String> getIdentitySource() {
            return this.identitySource;
        }

        @Override
        public final Builder identitySource(Collection<String> identitySource) {
            this.identitySource = IdentitySourceListCopier.copy(identitySource);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identitySource(String ... identitySource) {
            this.identitySource(Arrays.asList(identitySource));
            return this;
        }

        public final void setIdentitySource(Collection<String> identitySource) {
            this.identitySource = IdentitySourceListCopier.copy(identitySource);
        }

        public final String getIdentityValidationExpression() {
            return this.identityValidationExpression;
        }

        @Override
        public final Builder identityValidationExpression(String identityValidationExpression) {
            this.identityValidationExpression = identityValidationExpression;
            return this;
        }

        public final void setIdentityValidationExpression(String identityValidationExpression) {
            this.identityValidationExpression = identityValidationExpression;
        }

        public final JWTConfiguration.Builder getJwtConfiguration() {
            return this.jwtConfiguration != null ? this.jwtConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder jwtConfiguration(JWTConfiguration jwtConfiguration) {
            this.jwtConfiguration = jwtConfiguration;
            return this;
        }

        public final void setJwtConfiguration(JWTConfiguration.BuilderImpl jwtConfiguration) {
            this.jwtConfiguration = jwtConfiguration != null ? jwtConfiguration.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAuthorizerRequest build() {
            return new CreateAuthorizerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAuthorizerRequest> {
        public Builder apiId(String var1);

        public Builder authorizerCredentialsArn(String var1);

        public Builder authorizerResultTtlInSeconds(Integer var1);

        public Builder authorizerType(String var1);

        public Builder authorizerType(AuthorizerType var1);

        public Builder authorizerUri(String var1);

        public Builder identitySource(Collection<String> var1);

        public Builder identitySource(String ... var1);

        public Builder identityValidationExpression(String var1);

        public Builder jwtConfiguration(JWTConfiguration var1);

        default public Builder jwtConfiguration(Consumer<JWTConfiguration.Builder> jwtConfiguration) {
            return this.jwtConfiguration((JWTConfiguration)((JWTConfiguration.Builder)JWTConfiguration.builder().applyMutation(jwtConfiguration)).build());
        }

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

