/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Response;
import software.amazon.awssdk.services.apigatewayv2.model.ParameterConstraints;
import software.amazon.awssdk.services.apigatewayv2.model.RouteModelsCopier;
import software.amazon.awssdk.services.apigatewayv2.model.RouteParametersCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRouteResponseResponse
extends ApiGatewayV2Response
implements ToCopyableBuilder<Builder, CreateRouteResponseResponse> {
    private static final SdkField<String> MODEL_SELECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateRouteResponseResponse.getter(CreateRouteResponseResponse::modelSelectionExpression)).setter(CreateRouteResponseResponse.setter(Builder::modelSelectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSelectionExpression").build()}).build();
    private static final SdkField<Map<String, String>> RESPONSE_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateRouteResponseResponse.getter(CreateRouteResponseResponse::responseModels)).setter(CreateRouteResponseResponse.setter(Builder::responseModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseModels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ParameterConstraints>> RESPONSE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateRouteResponseResponse.getter(CreateRouteResponseResponse::responseParameters)).setter(CreateRouteResponseResponse.setter(Builder::responseParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterConstraints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ROUTE_RESPONSE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateRouteResponseResponse.getter(CreateRouteResponseResponse::routeResponseId)).setter(CreateRouteResponseResponse.setter(Builder::routeResponseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeResponseId").build()}).build();
    private static final SdkField<String> ROUTE_RESPONSE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateRouteResponseResponse.getter(CreateRouteResponseResponse::routeResponseKey)).setter(CreateRouteResponseResponse.setter(Builder::routeResponseKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeResponseKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_SELECTION_EXPRESSION_FIELD, RESPONSE_MODELS_FIELD, RESPONSE_PARAMETERS_FIELD, ROUTE_RESPONSE_ID_FIELD, ROUTE_RESPONSE_KEY_FIELD));
    private final String modelSelectionExpression;
    private final Map<String, String> responseModels;
    private final Map<String, ParameterConstraints> responseParameters;
    private final String routeResponseId;
    private final String routeResponseKey;

    private CreateRouteResponseResponse(BuilderImpl builder) {
        super(builder);
        this.modelSelectionExpression = builder.modelSelectionExpression;
        this.responseModels = builder.responseModels;
        this.responseParameters = builder.responseParameters;
        this.routeResponseId = builder.routeResponseId;
        this.routeResponseKey = builder.routeResponseKey;
    }

    public String modelSelectionExpression() {
        return this.modelSelectionExpression;
    }

    public Map<String, String> responseModels() {
        return this.responseModels;
    }

    public Map<String, ParameterConstraints> responseParameters() {
        return this.responseParameters;
    }

    public String routeResponseId() {
        return this.routeResponseId;
    }

    public String routeResponseKey() {
        return this.routeResponseKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseModels());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeResponseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeResponseKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouteResponseResponse)) {
            return false;
        }
        CreateRouteResponseResponse other = (CreateRouteResponseResponse)((Object)obj);
        return Objects.equals(this.modelSelectionExpression(), other.modelSelectionExpression()) && Objects.equals(this.responseModels(), other.responseModels()) && Objects.equals(this.responseParameters(), other.responseParameters()) && Objects.equals(this.routeResponseId(), other.routeResponseId()) && Objects.equals(this.routeResponseKey(), other.routeResponseKey());
    }

    public String toString() {
        return ToString.builder((String)"CreateRouteResponseResponse").add("ModelSelectionExpression", (Object)this.modelSelectionExpression()).add("ResponseModels", this.responseModels()).add("ResponseParameters", this.responseParameters()).add("RouteResponseId", (Object)this.routeResponseId()).add("RouteResponseKey", (Object)this.routeResponseKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelSelectionExpression": {
                return Optional.ofNullable(clazz.cast(this.modelSelectionExpression()));
            }
            case "ResponseModels": {
                return Optional.ofNullable(clazz.cast(this.responseModels()));
            }
            case "ResponseParameters": {
                return Optional.ofNullable(clazz.cast(this.responseParameters()));
            }
            case "RouteResponseId": {
                return Optional.ofNullable(clazz.cast(this.routeResponseId()));
            }
            case "RouteResponseKey": {
                return Optional.ofNullable(clazz.cast(this.routeResponseKey()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRouteResponseResponse, T> g) {
        return obj -> g.apply((CreateRouteResponseResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Response.BuilderImpl
    implements Builder {
        private String modelSelectionExpression;
        private Map<String, String> responseModels = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, ParameterConstraints> responseParameters = DefaultSdkAutoConstructMap.getInstance();
        private String routeResponseId;
        private String routeResponseKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouteResponseResponse model) {
            super(model);
            this.modelSelectionExpression(model.modelSelectionExpression);
            this.responseModels(model.responseModels);
            this.responseParameters(model.responseParameters);
            this.routeResponseId(model.routeResponseId);
            this.routeResponseKey(model.routeResponseKey);
        }

        public final String getModelSelectionExpression() {
            return this.modelSelectionExpression;
        }

        @Override
        public final Builder modelSelectionExpression(String modelSelectionExpression) {
            this.modelSelectionExpression = modelSelectionExpression;
            return this;
        }

        public final void setModelSelectionExpression(String modelSelectionExpression) {
            this.modelSelectionExpression = modelSelectionExpression;
        }

        public final Map<String, String> getResponseModels() {
            return this.responseModels;
        }

        @Override
        public final Builder responseModels(Map<String, String> responseModels) {
            this.responseModels = RouteModelsCopier.copy(responseModels);
            return this;
        }

        public final void setResponseModels(Map<String, String> responseModels) {
            this.responseModels = RouteModelsCopier.copy(responseModels);
        }

        public final Map<String, ParameterConstraints.Builder> getResponseParameters() {
            return this.responseParameters != null ? CollectionUtils.mapValues(this.responseParameters, ParameterConstraints::toBuilder) : null;
        }

        @Override
        public final Builder responseParameters(Map<String, ParameterConstraints> responseParameters) {
            this.responseParameters = RouteParametersCopier.copy(responseParameters);
            return this;
        }

        public final void setResponseParameters(Map<String, ParameterConstraints.BuilderImpl> responseParameters) {
            this.responseParameters = RouteParametersCopier.copyFromBuilder(responseParameters);
        }

        public final String getRouteResponseId() {
            return this.routeResponseId;
        }

        @Override
        public final Builder routeResponseId(String routeResponseId) {
            this.routeResponseId = routeResponseId;
            return this;
        }

        public final void setRouteResponseId(String routeResponseId) {
            this.routeResponseId = routeResponseId;
        }

        public final String getRouteResponseKey() {
            return this.routeResponseKey;
        }

        @Override
        public final Builder routeResponseKey(String routeResponseKey) {
            this.routeResponseKey = routeResponseKey;
            return this;
        }

        public final void setRouteResponseKey(String routeResponseKey) {
            this.routeResponseKey = routeResponseKey;
        }

        @Override
        public CreateRouteResponseResponse build() {
            return new CreateRouteResponseResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRouteResponseResponse> {
        public Builder modelSelectionExpression(String var1);

        public Builder responseModels(Map<String, String> var1);

        public Builder responseParameters(Map<String, ParameterConstraints> var1);

        public Builder routeResponseId(String var1);

        public Builder routeResponseKey(String var1);
    }
}

