/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayClient;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse;
import software.amazon.awssdk.services.apigateway.model.UsagePlanKey;

public class GetUsagePlanKeysIterable
implements SdkIterable<GetUsagePlanKeysResponse> {
    private final ApiGatewayClient client;
    private final GetUsagePlanKeysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetUsagePlanKeysIterable(ApiGatewayClient client, GetUsagePlanKeysRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetUsagePlanKeysResponseFetcher();
    }

    public Iterator<GetUsagePlanKeysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UsagePlanKey> items() {
        Function<GetUsagePlanKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetUsagePlanKeysResponseFetcher
    implements SyncPageFetcher<GetUsagePlanKeysResponse> {
        private GetUsagePlanKeysResponseFetcher() {
        }

        public boolean hasNextPage(GetUsagePlanKeysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public GetUsagePlanKeysResponse nextPage(GetUsagePlanKeysResponse previousPage) {
            if (previousPage == null) {
                return GetUsagePlanKeysIterable.this.client.getUsagePlanKeys(GetUsagePlanKeysIterable.this.firstRequest);
            }
            return GetUsagePlanKeysIterable.this.client.getUsagePlanKeys((GetUsagePlanKeysRequest)((Object)GetUsagePlanKeysIterable.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

