/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.ContentHandlingStrategy;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIntegrationResponseResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, UpdateIntegrationResponseResponse> {
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusCode").getter(UpdateIntegrationResponseResponse.getter(UpdateIntegrationResponseResponse::statusCode)).setter(UpdateIntegrationResponseResponse.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()}).build();
    private static final SdkField<String> SELECTION_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("selectionPattern").getter(UpdateIntegrationResponseResponse.getter(UpdateIntegrationResponseResponse::selectionPattern)).setter(UpdateIntegrationResponseResponse.setter(Builder::selectionPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectionPattern").build()}).build();
    private static final SdkField<Map<String, String>> RESPONSE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("responseParameters").getter(UpdateIntegrationResponseResponse.getter(UpdateIntegrationResponseResponse::responseParameters)).setter(UpdateIntegrationResponseResponse.setter(Builder::responseParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> RESPONSE_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("responseTemplates").getter(UpdateIntegrationResponseResponse.getter(UpdateIntegrationResponseResponse::responseTemplates)).setter(UpdateIntegrationResponseResponse.setter(Builder::responseTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseTemplates").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CONTENT_HANDLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentHandling").getter(UpdateIntegrationResponseResponse.getter(UpdateIntegrationResponseResponse::contentHandlingAsString)).setter(UpdateIntegrationResponseResponse.setter(Builder::contentHandling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentHandling").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODE_FIELD, SELECTION_PATTERN_FIELD, RESPONSE_PARAMETERS_FIELD, RESPONSE_TEMPLATES_FIELD, CONTENT_HANDLING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateIntegrationResponseResponse.memberNameToFieldInitializer();
    private final String statusCodeValue;
    private final String selectionPattern;
    private final Map<String, String> responseParameters;
    private final Map<String, String> responseTemplates;
    private final String contentHandling;

    private UpdateIntegrationResponseResponse(BuilderImpl builder) {
        super(builder);
        this.statusCodeValue = builder.statusCodeValue;
        this.selectionPattern = builder.selectionPattern;
        this.responseParameters = builder.responseParameters;
        this.responseTemplates = builder.responseTemplates;
        this.contentHandling = builder.contentHandling;
    }

    public final String statusCode() {
        return this.statusCodeValue;
    }

    public final String selectionPattern() {
        return this.selectionPattern;
    }

    public final boolean hasResponseParameters() {
        return this.responseParameters != null && !(this.responseParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> responseParameters() {
        return this.responseParameters;
    }

    public final boolean hasResponseTemplates() {
        return this.responseTemplates != null && !(this.responseTemplates instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> responseTemplates() {
        return this.responseTemplates;
    }

    public final ContentHandlingStrategy contentHandling() {
        return ContentHandlingStrategy.fromValue(this.contentHandling);
    }

    public final String contentHandlingAsString() {
        return this.contentHandling;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseParameters() ? this.responseParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseTemplates() ? this.responseTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contentHandlingAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIntegrationResponseResponse)) {
            return false;
        }
        UpdateIntegrationResponseResponse other = (UpdateIntegrationResponseResponse)((Object)obj);
        return Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.selectionPattern(), other.selectionPattern()) && this.hasResponseParameters() == other.hasResponseParameters() && Objects.equals(this.responseParameters(), other.responseParameters()) && this.hasResponseTemplates() == other.hasResponseTemplates() && Objects.equals(this.responseTemplates(), other.responseTemplates()) && Objects.equals(this.contentHandlingAsString(), other.contentHandlingAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateIntegrationResponseResponse").add("StatusCode", (Object)this.statusCode()).add("SelectionPattern", (Object)this.selectionPattern()).add("ResponseParameters", this.hasResponseParameters() ? this.responseParameters() : null).add("ResponseTemplates", this.hasResponseTemplates() ? this.responseTemplates() : null).add("ContentHandling", (Object)this.contentHandlingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "selectionPattern": {
                return Optional.ofNullable(clazz.cast(this.selectionPattern()));
            }
            case "responseParameters": {
                return Optional.ofNullable(clazz.cast(this.responseParameters()));
            }
            case "responseTemplates": {
                return Optional.ofNullable(clazz.cast(this.responseTemplates()));
            }
            case "contentHandling": {
                return Optional.ofNullable(clazz.cast(this.contentHandlingAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("statusCode", STATUS_CODE_FIELD);
        map.put("selectionPattern", SELECTION_PATTERN_FIELD);
        map.put("responseParameters", RESPONSE_PARAMETERS_FIELD);
        map.put("responseTemplates", RESPONSE_TEMPLATES_FIELD);
        map.put("contentHandling", CONTENT_HANDLING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIntegrationResponseResponse, T> g) {
        return obj -> g.apply((UpdateIntegrationResponseResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String statusCodeValue;
        private String selectionPattern;
        private Map<String, String> responseParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> responseTemplates = DefaultSdkAutoConstructMap.getInstance();
        private String contentHandling;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIntegrationResponseResponse model) {
            super(model);
            this.statusCode(model.statusCodeValue);
            this.selectionPattern(model.selectionPattern);
            this.responseParameters(model.responseParameters);
            this.responseTemplates(model.responseTemplates);
            this.contentHandling(model.contentHandling);
        }

        public final String getStatusCode() {
            return this.statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final String getSelectionPattern() {
            return this.selectionPattern;
        }

        public final void setSelectionPattern(String selectionPattern) {
            this.selectionPattern = selectionPattern;
        }

        @Override
        public final Builder selectionPattern(String selectionPattern) {
            this.selectionPattern = selectionPattern;
            return this;
        }

        public final Map<String, String> getResponseParameters() {
            if (this.responseParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.responseParameters;
        }

        public final void setResponseParameters(Map<String, String> responseParameters) {
            this.responseParameters = MapOfStringToStringCopier.copy(responseParameters);
        }

        @Override
        public final Builder responseParameters(Map<String, String> responseParameters) {
            this.responseParameters = MapOfStringToStringCopier.copy(responseParameters);
            return this;
        }

        public final Map<String, String> getResponseTemplates() {
            if (this.responseTemplates instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.responseTemplates;
        }

        public final void setResponseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = MapOfStringToStringCopier.copy(responseTemplates);
        }

        @Override
        public final Builder responseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = MapOfStringToStringCopier.copy(responseTemplates);
            return this;
        }

        public final String getContentHandling() {
            return this.contentHandling;
        }

        public final void setContentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
        }

        @Override
        public final Builder contentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        @Override
        public final Builder contentHandling(ContentHandlingStrategy contentHandling) {
            this.contentHandling(contentHandling == null ? null : contentHandling.toString());
            return this;
        }

        @Override
        public UpdateIntegrationResponseResponse build() {
            return new UpdateIntegrationResponseResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIntegrationResponseResponse> {
        public Builder statusCode(String var1);

        public Builder selectionPattern(String var1);

        public Builder responseParameters(Map<String, String> var1);

        public Builder responseTemplates(Map<String, String> var1);

        public Builder contentHandling(String var1);

        public Builder contentHandling(ContentHandlingStrategy var1);
    }
}

