/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ContentHandlingStrategy {
    CONVERT_TO_BINARY("CONVERT_TO_BINARY"),
    CONVERT_TO_TEXT("CONVERT_TO_TEXT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ContentHandlingStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContentHandlingStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ContentHandlingStrategy.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContentHandlingStrategy> knownValues() {
        return Stream.of(ContentHandlingStrategy.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

