/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayClient;
import software.amazon.awssdk.services.apigateway.model.GetResourcesRequest;
import software.amazon.awssdk.services.apigateway.model.GetResourcesResponse;
import software.amazon.awssdk.services.apigateway.model.Resource;

public class GetResourcesIterable
implements SdkIterable<GetResourcesResponse> {
    private final ApiGatewayClient client;
    private final GetResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetResourcesIterable(ApiGatewayClient client, GetResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetResourcesResponseFetcher();
    }

    public Iterator<GetResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Resource> items() {
        Function<GetResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final GetResourcesIterable resume(GetResourcesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetResourcesIterable(this.client, (GetResourcesRequest)((Object)this.firstRequest.toBuilder().position(lastSuccessfulPage.position()).build()));
        }
        return new GetResourcesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetResourcesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetResourcesResponseFetcher
    implements SyncPageFetcher<GetResourcesResponse> {
        private GetResourcesResponseFetcher() {
        }

        public boolean hasNextPage(GetResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public GetResourcesResponse nextPage(GetResourcesResponse previousPage) {
            if (previousPage == null) {
                return GetResourcesIterable.this.client.getResources(GetResourcesIterable.this.firstRequest);
            }
            return GetResourcesIterable.this.client.getResources((GetResourcesRequest)((Object)GetResourcesIterable.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

