/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayAsyncClient;
import software.amazon.awssdk.services.apigateway.model.GetUsageRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsageResponse;

public class GetUsagePublisher
implements SdkPublisher<GetUsageResponse> {
    private final ApiGatewayAsyncClient client;
    private final GetUsageRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetUsagePublisher(ApiGatewayAsyncClient client, GetUsageRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetUsagePublisher(ApiGatewayAsyncClient client, GetUsageRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetUsageResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetUsageResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Map.Entry<String, List<List<Long>>>> items() {
        Function<GetUsageResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().entrySet().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetUsageResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetUsageResponseFetcher
    implements AsyncPageFetcher<GetUsageResponse> {
        private GetUsageResponseFetcher() {
        }

        public boolean hasNextPage(GetUsageResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public CompletableFuture<GetUsageResponse> nextPage(GetUsageResponse previousPage) {
            if (previousPage == null) {
                return GetUsagePublisher.this.client.getUsage(GetUsagePublisher.this.firstRequest);
            }
            return GetUsagePublisher.this.client.getUsage((GetUsageRequest)((Object)GetUsagePublisher.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

