/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.CanarySettings;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStageRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, CreateStageRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("restApiId").getter(CreateStageRequest.getter(CreateStageRequest::restApiId)).setter(CreateStageRequest.setter(Builder::restApiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()}).build();
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stageName").getter(CreateStageRequest.getter(CreateStageRequest::stageName)).setter(CreateStageRequest.setter(Builder::stageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()}).build();
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentId").getter(CreateStageRequest.getter(CreateStageRequest::deploymentId)).setter(CreateStageRequest.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateStageRequest.getter(CreateStageRequest::description)).setter(CreateStageRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> CACHE_CLUSTER_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("cacheClusterEnabled").getter(CreateStageRequest.getter(CreateStageRequest::cacheClusterEnabled)).setter(CreateStageRequest.setter(Builder::cacheClusterEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheClusterEnabled").build()}).build();
    private static final SdkField<String> CACHE_CLUSTER_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cacheClusterSize").getter(CreateStageRequest.getter(CreateStageRequest::cacheClusterSize)).setter(CreateStageRequest.setter(Builder::cacheClusterSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheClusterSize").build()}).build();
    private static final SdkField<Map<String, String>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("variables").getter(CreateStageRequest.getter(CreateStageRequest::variables)).setter(CreateStageRequest.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DOCUMENTATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("documentationVersion").getter(CreateStageRequest.getter(CreateStageRequest::documentationVersion)).setter(CreateStageRequest.setter(Builder::documentationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentationVersion").build()}).build();
    private static final SdkField<CanarySettings> CANARY_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("canarySettings").getter(CreateStageRequest.getter(CreateStageRequest::canarySettings)).setter(CreateStageRequest.setter(Builder::canarySettings)).constructor(CanarySettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canarySettings").build()}).build();
    private static final SdkField<Boolean> TRACING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("tracingEnabled").getter(CreateStageRequest.getter(CreateStageRequest::tracingEnabled)).setter(CreateStageRequest.setter(Builder::tracingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracingEnabled").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateStageRequest.getter(CreateStageRequest::tags)).setter(CreateStageRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD, STAGE_NAME_FIELD, DEPLOYMENT_ID_FIELD, DESCRIPTION_FIELD, CACHE_CLUSTER_ENABLED_FIELD, CACHE_CLUSTER_SIZE_FIELD, VARIABLES_FIELD, DOCUMENTATION_VERSION_FIELD, CANARY_SETTINGS_FIELD, TRACING_ENABLED_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateStageRequest.memberNameToFieldInitializer();
    private final String restApiId;
    private final String stageName;
    private final String deploymentId;
    private final String description;
    private final Boolean cacheClusterEnabled;
    private final String cacheClusterSize;
    private final Map<String, String> variables;
    private final String documentationVersion;
    private final CanarySettings canarySettings;
    private final Boolean tracingEnabled;
    private final Map<String, String> tags;

    private CreateStageRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.stageName = builder.stageName;
        this.deploymentId = builder.deploymentId;
        this.description = builder.description;
        this.cacheClusterEnabled = builder.cacheClusterEnabled;
        this.cacheClusterSize = builder.cacheClusterSize;
        this.variables = builder.variables;
        this.documentationVersion = builder.documentationVersion;
        this.canarySettings = builder.canarySettings;
        this.tracingEnabled = builder.tracingEnabled;
        this.tags = builder.tags;
    }

    public final String restApiId() {
        return this.restApiId;
    }

    public final String stageName() {
        return this.stageName;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean cacheClusterEnabled() {
        return this.cacheClusterEnabled;
    }

    public final String cacheClusterSize() {
        return this.cacheClusterSize;
    }

    public final boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> variables() {
        return this.variables;
    }

    public final String documentationVersion() {
        return this.documentationVersion;
    }

    public final CanarySettings canarySettings() {
        return this.canarySettings;
    }

    public final Boolean tracingEnabled() {
        return this.tracingEnabled;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariables() ? this.variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.documentationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.canarySettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.tracingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStageRequest)) {
            return false;
        }
        CreateStageRequest other = (CreateStageRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.stageName(), other.stageName()) && Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.cacheClusterEnabled(), other.cacheClusterEnabled()) && Objects.equals(this.cacheClusterSize(), other.cacheClusterSize()) && this.hasVariables() == other.hasVariables() && Objects.equals(this.variables(), other.variables()) && Objects.equals(this.documentationVersion(), other.documentationVersion()) && Objects.equals(this.canarySettings(), other.canarySettings()) && Objects.equals(this.tracingEnabled(), other.tracingEnabled()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStageRequest").add("RestApiId", (Object)this.restApiId()).add("StageName", (Object)this.stageName()).add("DeploymentId", (Object)this.deploymentId()).add("Description", (Object)this.description()).add("CacheClusterEnabled", (Object)this.cacheClusterEnabled()).add("CacheClusterSize", (Object)this.cacheClusterSize()).add("Variables", this.hasVariables() ? this.variables() : null).add("DocumentationVersion", (Object)this.documentationVersion()).add("CanarySettings", (Object)this.canarySettings()).add("TracingEnabled", (Object)this.tracingEnabled()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "stageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
            case "deploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "cacheClusterEnabled": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterEnabled()));
            }
            case "cacheClusterSize": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterSize()));
            }
            case "variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
            case "documentationVersion": {
                return Optional.ofNullable(clazz.cast(this.documentationVersion()));
            }
            case "canarySettings": {
                return Optional.ofNullable(clazz.cast(this.canarySettings()));
            }
            case "tracingEnabled": {
                return Optional.ofNullable(clazz.cast(this.tracingEnabled()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("restapi_id", REST_API_ID_FIELD);
        map.put("stageName", STAGE_NAME_FIELD);
        map.put("deploymentId", DEPLOYMENT_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("cacheClusterEnabled", CACHE_CLUSTER_ENABLED_FIELD);
        map.put("cacheClusterSize", CACHE_CLUSTER_SIZE_FIELD);
        map.put("variables", VARIABLES_FIELD);
        map.put("documentationVersion", DOCUMENTATION_VERSION_FIELD);
        map.put("canarySettings", CANARY_SETTINGS_FIELD);
        map.put("tracingEnabled", TRACING_ENABLED_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStageRequest, T> g) {
        return obj -> g.apply((CreateStageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String stageName;
        private String deploymentId;
        private String description;
        private Boolean cacheClusterEnabled;
        private String cacheClusterSize;
        private Map<String, String> variables = DefaultSdkAutoConstructMap.getInstance();
        private String documentationVersion;
        private CanarySettings canarySettings;
        private Boolean tracingEnabled;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStageRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.stageName(model.stageName);
            this.deploymentId(model.deploymentId);
            this.description(model.description);
            this.cacheClusterEnabled(model.cacheClusterEnabled);
            this.cacheClusterSize(model.cacheClusterSize);
            this.variables(model.variables);
            this.documentationVersion(model.documentationVersion);
            this.canarySettings(model.canarySettings);
            this.tracingEnabled(model.tracingEnabled);
            this.tags(model.tags);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getStageName() {
            return this.stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getCacheClusterEnabled() {
            return this.cacheClusterEnabled;
        }

        public final void setCacheClusterEnabled(Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
        }

        @Override
        public final Builder cacheClusterEnabled(Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
            return this;
        }

        public final String getCacheClusterSize() {
            return this.cacheClusterSize;
        }

        public final void setCacheClusterSize(String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
        }

        @Override
        public final Builder cacheClusterSize(String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
            return this;
        }

        public final Map<String, String> getVariables() {
            if (this.variables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.variables;
        }

        public final void setVariables(Map<String, String> variables) {
            this.variables = MapOfStringToStringCopier.copy(variables);
        }

        @Override
        public final Builder variables(Map<String, String> variables) {
            this.variables = MapOfStringToStringCopier.copy(variables);
            return this;
        }

        public final String getDocumentationVersion() {
            return this.documentationVersion;
        }

        public final void setDocumentationVersion(String documentationVersion) {
            this.documentationVersion = documentationVersion;
        }

        @Override
        public final Builder documentationVersion(String documentationVersion) {
            this.documentationVersion = documentationVersion;
            return this;
        }

        public final CanarySettings.Builder getCanarySettings() {
            return this.canarySettings != null ? this.canarySettings.toBuilder() : null;
        }

        public final void setCanarySettings(CanarySettings.BuilderImpl canarySettings) {
            this.canarySettings = canarySettings != null ? canarySettings.build() : null;
        }

        @Override
        public final Builder canarySettings(CanarySettings canarySettings) {
            this.canarySettings = canarySettings;
            return this;
        }

        public final Boolean getTracingEnabled() {
            return this.tracingEnabled;
        }

        public final void setTracingEnabled(Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
        }

        @Override
        public final Builder tracingEnabled(Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStageRequest build() {
            return new CreateStageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStageRequest> {
        public Builder restApiId(String var1);

        public Builder stageName(String var1);

        public Builder deploymentId(String var1);

        public Builder description(String var1);

        public Builder cacheClusterEnabled(Boolean var1);

        public Builder cacheClusterSize(String var1);

        public Builder variables(Map<String, String> var1);

        public Builder documentationVersion(String var1);

        public Builder canarySettings(CanarySettings var1);

        default public Builder canarySettings(Consumer<CanarySettings.Builder> canarySettings) {
            return this.canarySettings((CanarySettings)((CanarySettings.Builder)CanarySettings.builder().applyMutation(canarySettings)).build());
        }

        public Builder tracingEnabled(Boolean var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

