/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.DeploymentCanarySettings;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDeploymentRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, CreateDeploymentRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("restApiId").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::restApiId)).setter(CreateDeploymentRequest.setter(Builder::restApiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()}).build();
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stageName").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::stageName)).setter(CreateDeploymentRequest.setter(Builder::stageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()}).build();
    private static final SdkField<String> STAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stageDescription").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::stageDescription)).setter(CreateDeploymentRequest.setter(Builder::stageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageDescription").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::description)).setter(CreateDeploymentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> CACHE_CLUSTER_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("cacheClusterEnabled").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::cacheClusterEnabled)).setter(CreateDeploymentRequest.setter(Builder::cacheClusterEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheClusterEnabled").build()}).build();
    private static final SdkField<String> CACHE_CLUSTER_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cacheClusterSize").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::cacheClusterSize)).setter(CreateDeploymentRequest.setter(Builder::cacheClusterSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheClusterSize").build()}).build();
    private static final SdkField<Map<String, String>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("variables").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::variables)).setter(CreateDeploymentRequest.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<DeploymentCanarySettings> CANARY_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("canarySettings").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::canarySettings)).setter(CreateDeploymentRequest.setter(Builder::canarySettings)).constructor(DeploymentCanarySettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canarySettings").build()}).build();
    private static final SdkField<Boolean> TRACING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("tracingEnabled").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::tracingEnabled)).setter(CreateDeploymentRequest.setter(Builder::tracingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracingEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD, STAGE_NAME_FIELD, STAGE_DESCRIPTION_FIELD, DESCRIPTION_FIELD, CACHE_CLUSTER_ENABLED_FIELD, CACHE_CLUSTER_SIZE_FIELD, VARIABLES_FIELD, CANARY_SETTINGS_FIELD, TRACING_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDeploymentRequest.memberNameToFieldInitializer();
    private final String restApiId;
    private final String stageName;
    private final String stageDescription;
    private final String description;
    private final Boolean cacheClusterEnabled;
    private final String cacheClusterSize;
    private final Map<String, String> variables;
    private final DeploymentCanarySettings canarySettings;
    private final Boolean tracingEnabled;

    private CreateDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.stageName = builder.stageName;
        this.stageDescription = builder.stageDescription;
        this.description = builder.description;
        this.cacheClusterEnabled = builder.cacheClusterEnabled;
        this.cacheClusterSize = builder.cacheClusterSize;
        this.variables = builder.variables;
        this.canarySettings = builder.canarySettings;
        this.tracingEnabled = builder.tracingEnabled;
    }

    public final String restApiId() {
        return this.restApiId;
    }

    public final String stageName() {
        return this.stageName;
    }

    public final String stageDescription() {
        return this.stageDescription;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean cacheClusterEnabled() {
        return this.cacheClusterEnabled;
    }

    public final String cacheClusterSize() {
        return this.cacheClusterSize;
    }

    public final boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> variables() {
        return this.variables;
    }

    public final DeploymentCanarySettings canarySettings() {
        return this.canarySettings;
    }

    public final Boolean tracingEnabled() {
        return this.tracingEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariables() ? this.variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.canarySettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.tracingEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentRequest)) {
            return false;
        }
        CreateDeploymentRequest other = (CreateDeploymentRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.stageName(), other.stageName()) && Objects.equals(this.stageDescription(), other.stageDescription()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.cacheClusterEnabled(), other.cacheClusterEnabled()) && Objects.equals(this.cacheClusterSize(), other.cacheClusterSize()) && this.hasVariables() == other.hasVariables() && Objects.equals(this.variables(), other.variables()) && Objects.equals(this.canarySettings(), other.canarySettings()) && Objects.equals(this.tracingEnabled(), other.tracingEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDeploymentRequest").add("RestApiId", (Object)this.restApiId()).add("StageName", (Object)this.stageName()).add("StageDescription", (Object)this.stageDescription()).add("Description", (Object)this.description()).add("CacheClusterEnabled", (Object)this.cacheClusterEnabled()).add("CacheClusterSize", (Object)this.cacheClusterSize()).add("Variables", this.hasVariables() ? this.variables() : null).add("CanarySettings", (Object)this.canarySettings()).add("TracingEnabled", (Object)this.tracingEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "stageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
            case "stageDescription": {
                return Optional.ofNullable(clazz.cast(this.stageDescription()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "cacheClusterEnabled": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterEnabled()));
            }
            case "cacheClusterSize": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterSize()));
            }
            case "variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
            case "canarySettings": {
                return Optional.ofNullable(clazz.cast(this.canarySettings()));
            }
            case "tracingEnabled": {
                return Optional.ofNullable(clazz.cast(this.tracingEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("restapi_id", REST_API_ID_FIELD);
        map.put("stageName", STAGE_NAME_FIELD);
        map.put("stageDescription", STAGE_DESCRIPTION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("cacheClusterEnabled", CACHE_CLUSTER_ENABLED_FIELD);
        map.put("cacheClusterSize", CACHE_CLUSTER_SIZE_FIELD);
        map.put("variables", VARIABLES_FIELD);
        map.put("canarySettings", CANARY_SETTINGS_FIELD);
        map.put("tracingEnabled", TRACING_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentRequest, T> g) {
        return obj -> g.apply((CreateDeploymentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String stageName;
        private String stageDescription;
        private String description;
        private Boolean cacheClusterEnabled;
        private String cacheClusterSize;
        private Map<String, String> variables = DefaultSdkAutoConstructMap.getInstance();
        private DeploymentCanarySettings canarySettings;
        private Boolean tracingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.stageName(model.stageName);
            this.stageDescription(model.stageDescription);
            this.description(model.description);
            this.cacheClusterEnabled(model.cacheClusterEnabled);
            this.cacheClusterSize(model.cacheClusterSize);
            this.variables(model.variables);
            this.canarySettings(model.canarySettings);
            this.tracingEnabled(model.tracingEnabled);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getStageName() {
            return this.stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final String getStageDescription() {
            return this.stageDescription;
        }

        public final void setStageDescription(String stageDescription) {
            this.stageDescription = stageDescription;
        }

        @Override
        public final Builder stageDescription(String stageDescription) {
            this.stageDescription = stageDescription;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getCacheClusterEnabled() {
            return this.cacheClusterEnabled;
        }

        public final void setCacheClusterEnabled(Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
        }

        @Override
        public final Builder cacheClusterEnabled(Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
            return this;
        }

        public final String getCacheClusterSize() {
            return this.cacheClusterSize;
        }

        public final void setCacheClusterSize(String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
        }

        @Override
        public final Builder cacheClusterSize(String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
            return this;
        }

        public final Map<String, String> getVariables() {
            if (this.variables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.variables;
        }

        public final void setVariables(Map<String, String> variables) {
            this.variables = MapOfStringToStringCopier.copy(variables);
        }

        @Override
        public final Builder variables(Map<String, String> variables) {
            this.variables = MapOfStringToStringCopier.copy(variables);
            return this;
        }

        public final DeploymentCanarySettings.Builder getCanarySettings() {
            return this.canarySettings != null ? this.canarySettings.toBuilder() : null;
        }

        public final void setCanarySettings(DeploymentCanarySettings.BuilderImpl canarySettings) {
            this.canarySettings = canarySettings != null ? canarySettings.build() : null;
        }

        @Override
        public final Builder canarySettings(DeploymentCanarySettings canarySettings) {
            this.canarySettings = canarySettings;
            return this;
        }

        public final Boolean getTracingEnabled() {
            return this.tracingEnabled;
        }

        public final void setTracingEnabled(Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
        }

        @Override
        public final Builder tracingEnabled(Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentRequest build() {
            return new CreateDeploymentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDeploymentRequest> {
        public Builder restApiId(String var1);

        public Builder stageName(String var1);

        public Builder stageDescription(String var1);

        public Builder description(String var1);

        public Builder cacheClusterEnabled(Boolean var1);

        public Builder cacheClusterSize(String var1);

        public Builder variables(Map<String, String> var1);

        public Builder canarySettings(DeploymentCanarySettings var1);

        default public Builder canarySettings(Consumer<DeploymentCanarySettings.Builder> canarySettings) {
            return this.canarySettings((DeploymentCanarySettings)((DeploymentCanarySettings.Builder)DeploymentCanarySettings.builder().applyMutation(canarySettings)).build());
        }

        public Builder tracingEnabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

