/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.EndpointConfiguration;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.services.apigateway.model.MutualTlsAuthenticationInput;
import software.amazon.awssdk.services.apigateway.model.RoutingMode;
import software.amazon.awssdk.services.apigateway.model.SecurityPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDomainNameRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, CreateDomainNameRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(CreateDomainNameRequest.getter(CreateDomainNameRequest::domainName)).setter(CreateDomainNameRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<String> CERTIFICATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateName").getter(CreateDomainNameRequest.getter(CreateDomainNameRequest::certificateName)).setter(CreateDomainNameRequest.setter(Builder::certificateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateName").build()}).build();
    private static final SdkField<String> CERTIFICATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateBody").getter(CreateDomainNameRequest.getter(CreateDomainNameRequest::certificateBody)).setter(CreateDomainNameRequest.setter(Builder::certificateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateBody").build()}).build();
    private static final SdkField<String> CERTIFICATE_PRIVATE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificatePrivateKey").getter(CreateDomainNameRequest.getter(CreateDomainNameRequest::certificatePrivateKey)).setter(CreateDomainNameRequest.setter(Builder::certificatePrivateKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatePrivateKey").build()}).build();
    private static final SdkField<String> CERTIFICATE_CHAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateChain").getter(CreateDomainNameRequest.getter(CreateDomainNameRequest::certificateChain)).setter(CreateDomainNameRequest.setter(Builder::certificateChain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateChain").build()}).build();
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateArn").getter(CreateDomainNameRequest.getter(CreateDomainNameRequest::certificateArn)).setter(CreateDomainNameRequest.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()}).build();
    private static final SdkField<String> REGIONAL_CERTIFICATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("regionalCertificateName").getter(CreateDomainNameRequest.getter(CreateDomainNameRequest::regionalCertificateName)).setter(CreateDomainNameRequest.setter(Builder::regionalCertificateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionalCertificateName").build()}).build();
    private static final SdkField<String> REGIONAL_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("regionalCertificateArn").getter(CreateDomainNameRequest.getter(CreateDomainNameRequest::regionalCertificateArn)).setter(CreateDomainNameRequest.setter(Builder::regionalCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionalCertificateArn").build()}).build();
    private static final SdkField<EndpointConfiguration> ENDPOINT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("endpointConfiguration").getter(CreateDomainNameRequest.getter(CreateDomainNameRequest::endpointConfiguration)).setter(CreateDomainNameRequest.setter(Builder::endpointConfiguration)).constructor(EndpointConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateDomainNameRequest.getter(CreateDomainNameRequest::tags)).setter(CreateDomainNameRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SECURITY_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("securityPolicy").getter(CreateDomainNameRequest.getter(CreateDomainNameRequest::securityPolicyAsString)).setter(CreateDomainNameRequest.setter(Builder::securityPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityPolicy").build()}).build();
    private static final SdkField<MutualTlsAuthenticationInput> MUTUAL_TLS_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("mutualTlsAuthentication").getter(CreateDomainNameRequest.getter(CreateDomainNameRequest::mutualTlsAuthentication)).setter(CreateDomainNameRequest.setter(Builder::mutualTlsAuthentication)).constructor(MutualTlsAuthenticationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mutualTlsAuthentication").build()}).build();
    private static final SdkField<String> OWNERSHIP_VERIFICATION_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownershipVerificationCertificateArn").getter(CreateDomainNameRequest.getter(CreateDomainNameRequest::ownershipVerificationCertificateArn)).setter(CreateDomainNameRequest.setter(Builder::ownershipVerificationCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownershipVerificationCertificateArn").build()}).build();
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policy").getter(CreateDomainNameRequest.getter(CreateDomainNameRequest::policy)).setter(CreateDomainNameRequest.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()}).build();
    private static final SdkField<String> ROUTING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("routingMode").getter(CreateDomainNameRequest.getter(CreateDomainNameRequest::routingModeAsString)).setter(CreateDomainNameRequest.setter(Builder::routingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, CERTIFICATE_NAME_FIELD, CERTIFICATE_BODY_FIELD, CERTIFICATE_PRIVATE_KEY_FIELD, CERTIFICATE_CHAIN_FIELD, CERTIFICATE_ARN_FIELD, REGIONAL_CERTIFICATE_NAME_FIELD, REGIONAL_CERTIFICATE_ARN_FIELD, ENDPOINT_CONFIGURATION_FIELD, TAGS_FIELD, SECURITY_POLICY_FIELD, MUTUAL_TLS_AUTHENTICATION_FIELD, OWNERSHIP_VERIFICATION_CERTIFICATE_ARN_FIELD, POLICY_FIELD, ROUTING_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDomainNameRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final String certificateName;
    private final String certificateBody;
    private final String certificatePrivateKey;
    private final String certificateChain;
    private final String certificateArn;
    private final String regionalCertificateName;
    private final String regionalCertificateArn;
    private final EndpointConfiguration endpointConfiguration;
    private final Map<String, String> tags;
    private final String securityPolicy;
    private final MutualTlsAuthenticationInput mutualTlsAuthentication;
    private final String ownershipVerificationCertificateArn;
    private final String policy;
    private final String routingMode;

    private CreateDomainNameRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.certificateName = builder.certificateName;
        this.certificateBody = builder.certificateBody;
        this.certificatePrivateKey = builder.certificatePrivateKey;
        this.certificateChain = builder.certificateChain;
        this.certificateArn = builder.certificateArn;
        this.regionalCertificateName = builder.regionalCertificateName;
        this.regionalCertificateArn = builder.regionalCertificateArn;
        this.endpointConfiguration = builder.endpointConfiguration;
        this.tags = builder.tags;
        this.securityPolicy = builder.securityPolicy;
        this.mutualTlsAuthentication = builder.mutualTlsAuthentication;
        this.ownershipVerificationCertificateArn = builder.ownershipVerificationCertificateArn;
        this.policy = builder.policy;
        this.routingMode = builder.routingMode;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String certificateName() {
        return this.certificateName;
    }

    public final String certificateBody() {
        return this.certificateBody;
    }

    public final String certificatePrivateKey() {
        return this.certificatePrivateKey;
    }

    public final String certificateChain() {
        return this.certificateChain;
    }

    public final String certificateArn() {
        return this.certificateArn;
    }

    public final String regionalCertificateName() {
        return this.regionalCertificateName;
    }

    public final String regionalCertificateArn() {
        return this.regionalCertificateArn;
    }

    public final EndpointConfiguration endpointConfiguration() {
        return this.endpointConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final SecurityPolicy securityPolicy() {
        return SecurityPolicy.fromValue(this.securityPolicy);
    }

    public final String securityPolicyAsString() {
        return this.securityPolicy;
    }

    public final MutualTlsAuthenticationInput mutualTlsAuthentication() {
        return this.mutualTlsAuthentication;
    }

    public final String ownershipVerificationCertificateArn() {
        return this.ownershipVerificationCertificateArn;
    }

    public final String policy() {
        return this.policy;
    }

    public final RoutingMode routingMode() {
        return RoutingMode.fromValue(this.routingMode);
    }

    public final String routingModeAsString() {
        return this.routingMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificatePrivateKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateChain());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionalCertificateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionalCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.securityPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mutualTlsAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownershipVerificationCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainNameRequest)) {
            return false;
        }
        CreateDomainNameRequest other = (CreateDomainNameRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.certificateName(), other.certificateName()) && Objects.equals(this.certificateBody(), other.certificateBody()) && Objects.equals(this.certificatePrivateKey(), other.certificatePrivateKey()) && Objects.equals(this.certificateChain(), other.certificateChain()) && Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.regionalCertificateName(), other.regionalCertificateName()) && Objects.equals(this.regionalCertificateArn(), other.regionalCertificateArn()) && Objects.equals(this.endpointConfiguration(), other.endpointConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.securityPolicyAsString(), other.securityPolicyAsString()) && Objects.equals(this.mutualTlsAuthentication(), other.mutualTlsAuthentication()) && Objects.equals(this.ownershipVerificationCertificateArn(), other.ownershipVerificationCertificateArn()) && Objects.equals(this.policy(), other.policy()) && Objects.equals(this.routingModeAsString(), other.routingModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDomainNameRequest").add("DomainName", (Object)this.domainName()).add("CertificateName", (Object)this.certificateName()).add("CertificateBody", (Object)this.certificateBody()).add("CertificatePrivateKey", (Object)this.certificatePrivateKey()).add("CertificateChain", (Object)this.certificateChain()).add("CertificateArn", (Object)this.certificateArn()).add("RegionalCertificateName", (Object)this.regionalCertificateName()).add("RegionalCertificateArn", (Object)this.regionalCertificateArn()).add("EndpointConfiguration", (Object)this.endpointConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).add("SecurityPolicy", (Object)this.securityPolicyAsString()).add("MutualTlsAuthentication", (Object)this.mutualTlsAuthentication()).add("OwnershipVerificationCertificateArn", (Object)this.ownershipVerificationCertificateArn()).add("Policy", (Object)this.policy()).add("RoutingMode", (Object)this.routingModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "certificateName": {
                return Optional.ofNullable(clazz.cast(this.certificateName()));
            }
            case "certificateBody": {
                return Optional.ofNullable(clazz.cast(this.certificateBody()));
            }
            case "certificatePrivateKey": {
                return Optional.ofNullable(clazz.cast(this.certificatePrivateKey()));
            }
            case "certificateChain": {
                return Optional.ofNullable(clazz.cast(this.certificateChain()));
            }
            case "certificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "regionalCertificateName": {
                return Optional.ofNullable(clazz.cast(this.regionalCertificateName()));
            }
            case "regionalCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.regionalCertificateArn()));
            }
            case "endpointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.endpointConfiguration()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "securityPolicy": {
                return Optional.ofNullable(clazz.cast(this.securityPolicyAsString()));
            }
            case "mutualTlsAuthentication": {
                return Optional.ofNullable(clazz.cast(this.mutualTlsAuthentication()));
            }
            case "ownershipVerificationCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.ownershipVerificationCertificateArn()));
            }
            case "policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "routingMode": {
                return Optional.ofNullable(clazz.cast(this.routingModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("certificateName", CERTIFICATE_NAME_FIELD);
        map.put("certificateBody", CERTIFICATE_BODY_FIELD);
        map.put("certificatePrivateKey", CERTIFICATE_PRIVATE_KEY_FIELD);
        map.put("certificateChain", CERTIFICATE_CHAIN_FIELD);
        map.put("certificateArn", CERTIFICATE_ARN_FIELD);
        map.put("regionalCertificateName", REGIONAL_CERTIFICATE_NAME_FIELD);
        map.put("regionalCertificateArn", REGIONAL_CERTIFICATE_ARN_FIELD);
        map.put("endpointConfiguration", ENDPOINT_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("securityPolicy", SECURITY_POLICY_FIELD);
        map.put("mutualTlsAuthentication", MUTUAL_TLS_AUTHENTICATION_FIELD);
        map.put("ownershipVerificationCertificateArn", OWNERSHIP_VERIFICATION_CERTIFICATE_ARN_FIELD);
        map.put("policy", POLICY_FIELD);
        map.put("routingMode", ROUTING_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainNameRequest, T> g) {
        return obj -> g.apply((CreateDomainNameRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String certificateName;
        private String certificateBody;
        private String certificatePrivateKey;
        private String certificateChain;
        private String certificateArn;
        private String regionalCertificateName;
        private String regionalCertificateArn;
        private EndpointConfiguration endpointConfiguration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String securityPolicy;
        private MutualTlsAuthenticationInput mutualTlsAuthentication;
        private String ownershipVerificationCertificateArn;
        private String policy;
        private String routingMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainNameRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.certificateName(model.certificateName);
            this.certificateBody(model.certificateBody);
            this.certificatePrivateKey(model.certificatePrivateKey);
            this.certificateChain(model.certificateChain);
            this.certificateArn(model.certificateArn);
            this.regionalCertificateName(model.regionalCertificateName);
            this.regionalCertificateArn(model.regionalCertificateArn);
            this.endpointConfiguration(model.endpointConfiguration);
            this.tags(model.tags);
            this.securityPolicy(model.securityPolicy);
            this.mutualTlsAuthentication(model.mutualTlsAuthentication);
            this.ownershipVerificationCertificateArn(model.ownershipVerificationCertificateArn);
            this.policy(model.policy);
            this.routingMode(model.routingMode);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getCertificateName() {
            return this.certificateName;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final String getCertificateBody() {
            return this.certificateBody;
        }

        public final void setCertificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
        }

        @Override
        public final Builder certificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
            return this;
        }

        public final String getCertificatePrivateKey() {
            return this.certificatePrivateKey;
        }

        public final void setCertificatePrivateKey(String certificatePrivateKey) {
            this.certificatePrivateKey = certificatePrivateKey;
        }

        @Override
        public final Builder certificatePrivateKey(String certificatePrivateKey) {
            this.certificatePrivateKey = certificatePrivateKey;
            return this;
        }

        public final String getCertificateChain() {
            return this.certificateChain;
        }

        public final void setCertificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
        }

        @Override
        public final Builder certificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
            return this;
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getRegionalCertificateName() {
            return this.regionalCertificateName;
        }

        public final void setRegionalCertificateName(String regionalCertificateName) {
            this.regionalCertificateName = regionalCertificateName;
        }

        @Override
        public final Builder regionalCertificateName(String regionalCertificateName) {
            this.regionalCertificateName = regionalCertificateName;
            return this;
        }

        public final String getRegionalCertificateArn() {
            return this.regionalCertificateArn;
        }

        public final void setRegionalCertificateArn(String regionalCertificateArn) {
            this.regionalCertificateArn = regionalCertificateArn;
        }

        @Override
        public final Builder regionalCertificateArn(String regionalCertificateArn) {
            this.regionalCertificateArn = regionalCertificateArn;
            return this;
        }

        public final EndpointConfiguration.Builder getEndpointConfiguration() {
            return this.endpointConfiguration != null ? this.endpointConfiguration.toBuilder() : null;
        }

        public final void setEndpointConfiguration(EndpointConfiguration.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        @Override
        public final Builder endpointConfiguration(EndpointConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
            return this;
        }

        public final String getSecurityPolicy() {
            return this.securityPolicy;
        }

        public final void setSecurityPolicy(String securityPolicy) {
            this.securityPolicy = securityPolicy;
        }

        @Override
        public final Builder securityPolicy(String securityPolicy) {
            this.securityPolicy = securityPolicy;
            return this;
        }

        @Override
        public final Builder securityPolicy(SecurityPolicy securityPolicy) {
            this.securityPolicy(securityPolicy == null ? null : securityPolicy.toString());
            return this;
        }

        public final MutualTlsAuthenticationInput.Builder getMutualTlsAuthentication() {
            return this.mutualTlsAuthentication != null ? this.mutualTlsAuthentication.toBuilder() : null;
        }

        public final void setMutualTlsAuthentication(MutualTlsAuthenticationInput.BuilderImpl mutualTlsAuthentication) {
            this.mutualTlsAuthentication = mutualTlsAuthentication != null ? mutualTlsAuthentication.build() : null;
        }

        @Override
        public final Builder mutualTlsAuthentication(MutualTlsAuthenticationInput mutualTlsAuthentication) {
            this.mutualTlsAuthentication = mutualTlsAuthentication;
            return this;
        }

        public final String getOwnershipVerificationCertificateArn() {
            return this.ownershipVerificationCertificateArn;
        }

        public final void setOwnershipVerificationCertificateArn(String ownershipVerificationCertificateArn) {
            this.ownershipVerificationCertificateArn = ownershipVerificationCertificateArn;
        }

        @Override
        public final Builder ownershipVerificationCertificateArn(String ownershipVerificationCertificateArn) {
            this.ownershipVerificationCertificateArn = ownershipVerificationCertificateArn;
            return this;
        }

        public final String getPolicy() {
            return this.policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final String getRoutingMode() {
            return this.routingMode;
        }

        public final void setRoutingMode(String routingMode) {
            this.routingMode = routingMode;
        }

        @Override
        public final Builder routingMode(String routingMode) {
            this.routingMode = routingMode;
            return this;
        }

        @Override
        public final Builder routingMode(RoutingMode routingMode) {
            this.routingMode(routingMode == null ? null : routingMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainNameRequest build() {
            return new CreateDomainNameRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDomainNameRequest> {
        public Builder domainName(String var1);

        public Builder certificateName(String var1);

        public Builder certificateBody(String var1);

        public Builder certificatePrivateKey(String var1);

        public Builder certificateChain(String var1);

        public Builder certificateArn(String var1);

        public Builder regionalCertificateName(String var1);

        public Builder regionalCertificateArn(String var1);

        public Builder endpointConfiguration(EndpointConfiguration var1);

        default public Builder endpointConfiguration(Consumer<EndpointConfiguration.Builder> endpointConfiguration) {
            return this.endpointConfiguration((EndpointConfiguration)((EndpointConfiguration.Builder)EndpointConfiguration.builder().applyMutation(endpointConfiguration)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder securityPolicy(String var1);

        public Builder securityPolicy(SecurityPolicy var1);

        public Builder mutualTlsAuthentication(MutualTlsAuthenticationInput var1);

        default public Builder mutualTlsAuthentication(Consumer<MutualTlsAuthenticationInput.Builder> mutualTlsAuthentication) {
            return this.mutualTlsAuthentication((MutualTlsAuthenticationInput)((MutualTlsAuthenticationInput.Builder)MutualTlsAuthenticationInput.builder().applyMutation(mutualTlsAuthentication)).build());
        }

        public Builder ownershipVerificationCertificateArn(String var1);

        public Builder policy(String var1);

        public Builder routingMode(String var1);

        public Builder routingMode(RoutingMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

