/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.DomainNameStatus;
import software.amazon.awssdk.services.apigateway.model.EndpointConfiguration;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.services.apigateway.model.MutualTlsAuthentication;
import software.amazon.awssdk.services.apigateway.model.SecurityPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDomainNameResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, CreateDomainNameResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(CreateDomainNameResponse.getter(CreateDomainNameResponse::domainName)).setter(CreateDomainNameResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainNameId").getter(CreateDomainNameResponse.getter(CreateDomainNameResponse::domainNameId)).setter(CreateDomainNameResponse.setter(Builder::domainNameId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainNameId").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainNameArn").getter(CreateDomainNameResponse.getter(CreateDomainNameResponse::domainNameArn)).setter(CreateDomainNameResponse.setter(Builder::domainNameArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainNameArn").build()}).build();
    private static final SdkField<String> CERTIFICATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateName").getter(CreateDomainNameResponse.getter(CreateDomainNameResponse::certificateName)).setter(CreateDomainNameResponse.setter(Builder::certificateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateName").build()}).build();
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateArn").getter(CreateDomainNameResponse.getter(CreateDomainNameResponse::certificateArn)).setter(CreateDomainNameResponse.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()}).build();
    private static final SdkField<Instant> CERTIFICATE_UPLOAD_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("certificateUploadDate").getter(CreateDomainNameResponse.getter(CreateDomainNameResponse::certificateUploadDate)).setter(CreateDomainNameResponse.setter(Builder::certificateUploadDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateUploadDate").build()}).build();
    private static final SdkField<String> REGIONAL_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("regionalDomainName").getter(CreateDomainNameResponse.getter(CreateDomainNameResponse::regionalDomainName)).setter(CreateDomainNameResponse.setter(Builder::regionalDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionalDomainName").build()}).build();
    private static final SdkField<String> REGIONAL_HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("regionalHostedZoneId").getter(CreateDomainNameResponse.getter(CreateDomainNameResponse::regionalHostedZoneId)).setter(CreateDomainNameResponse.setter(Builder::regionalHostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionalHostedZoneId").build()}).build();
    private static final SdkField<String> REGIONAL_CERTIFICATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("regionalCertificateName").getter(CreateDomainNameResponse.getter(CreateDomainNameResponse::regionalCertificateName)).setter(CreateDomainNameResponse.setter(Builder::regionalCertificateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionalCertificateName").build()}).build();
    private static final SdkField<String> REGIONAL_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("regionalCertificateArn").getter(CreateDomainNameResponse.getter(CreateDomainNameResponse::regionalCertificateArn)).setter(CreateDomainNameResponse.setter(Builder::regionalCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionalCertificateArn").build()}).build();
    private static final SdkField<String> DISTRIBUTION_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("distributionDomainName").getter(CreateDomainNameResponse.getter(CreateDomainNameResponse::distributionDomainName)).setter(CreateDomainNameResponse.setter(Builder::distributionDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionDomainName").build()}).build();
    private static final SdkField<String> DISTRIBUTION_HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("distributionHostedZoneId").getter(CreateDomainNameResponse.getter(CreateDomainNameResponse::distributionHostedZoneId)).setter(CreateDomainNameResponse.setter(Builder::distributionHostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionHostedZoneId").build()}).build();
    private static final SdkField<EndpointConfiguration> ENDPOINT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("endpointConfiguration").getter(CreateDomainNameResponse.getter(CreateDomainNameResponse::endpointConfiguration)).setter(CreateDomainNameResponse.setter(Builder::endpointConfiguration)).constructor(EndpointConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointConfiguration").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainNameStatus").getter(CreateDomainNameResponse.getter(CreateDomainNameResponse::domainNameStatusAsString)).setter(CreateDomainNameResponse.setter(Builder::domainNameStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainNameStatus").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainNameStatusMessage").getter(CreateDomainNameResponse.getter(CreateDomainNameResponse::domainNameStatusMessage)).setter(CreateDomainNameResponse.setter(Builder::domainNameStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainNameStatusMessage").build()}).build();
    private static final SdkField<String> SECURITY_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("securityPolicy").getter(CreateDomainNameResponse.getter(CreateDomainNameResponse::securityPolicyAsString)).setter(CreateDomainNameResponse.setter(Builder::securityPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityPolicy").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateDomainNameResponse.getter(CreateDomainNameResponse::tags)).setter(CreateDomainNameResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<MutualTlsAuthentication> MUTUAL_TLS_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("mutualTlsAuthentication").getter(CreateDomainNameResponse.getter(CreateDomainNameResponse::mutualTlsAuthentication)).setter(CreateDomainNameResponse.setter(Builder::mutualTlsAuthentication)).constructor(MutualTlsAuthentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mutualTlsAuthentication").build()}).build();
    private static final SdkField<String> OWNERSHIP_VERIFICATION_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownershipVerificationCertificateArn").getter(CreateDomainNameResponse.getter(CreateDomainNameResponse::ownershipVerificationCertificateArn)).setter(CreateDomainNameResponse.setter(Builder::ownershipVerificationCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownershipVerificationCertificateArn").build()}).build();
    private static final SdkField<String> MANAGEMENT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managementPolicy").getter(CreateDomainNameResponse.getter(CreateDomainNameResponse::managementPolicy)).setter(CreateDomainNameResponse.setter(Builder::managementPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managementPolicy").build()}).build();
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policy").getter(CreateDomainNameResponse.getter(CreateDomainNameResponse::policy)).setter(CreateDomainNameResponse.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, DOMAIN_NAME_ID_FIELD, DOMAIN_NAME_ARN_FIELD, CERTIFICATE_NAME_FIELD, CERTIFICATE_ARN_FIELD, CERTIFICATE_UPLOAD_DATE_FIELD, REGIONAL_DOMAIN_NAME_FIELD, REGIONAL_HOSTED_ZONE_ID_FIELD, REGIONAL_CERTIFICATE_NAME_FIELD, REGIONAL_CERTIFICATE_ARN_FIELD, DISTRIBUTION_DOMAIN_NAME_FIELD, DISTRIBUTION_HOSTED_ZONE_ID_FIELD, ENDPOINT_CONFIGURATION_FIELD, DOMAIN_NAME_STATUS_FIELD, DOMAIN_NAME_STATUS_MESSAGE_FIELD, SECURITY_POLICY_FIELD, TAGS_FIELD, MUTUAL_TLS_AUTHENTICATION_FIELD, OWNERSHIP_VERIFICATION_CERTIFICATE_ARN_FIELD, MANAGEMENT_POLICY_FIELD, POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDomainNameResponse.memberNameToFieldInitializer();
    private final String domainName;
    private final String domainNameId;
    private final String domainNameArn;
    private final String certificateName;
    private final String certificateArn;
    private final Instant certificateUploadDate;
    private final String regionalDomainName;
    private final String regionalHostedZoneId;
    private final String regionalCertificateName;
    private final String regionalCertificateArn;
    private final String distributionDomainName;
    private final String distributionHostedZoneId;
    private final EndpointConfiguration endpointConfiguration;
    private final String domainNameStatus;
    private final String domainNameStatusMessage;
    private final String securityPolicy;
    private final Map<String, String> tags;
    private final MutualTlsAuthentication mutualTlsAuthentication;
    private final String ownershipVerificationCertificateArn;
    private final String managementPolicy;
    private final String policy;

    private CreateDomainNameResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.domainNameId = builder.domainNameId;
        this.domainNameArn = builder.domainNameArn;
        this.certificateName = builder.certificateName;
        this.certificateArn = builder.certificateArn;
        this.certificateUploadDate = builder.certificateUploadDate;
        this.regionalDomainName = builder.regionalDomainName;
        this.regionalHostedZoneId = builder.regionalHostedZoneId;
        this.regionalCertificateName = builder.regionalCertificateName;
        this.regionalCertificateArn = builder.regionalCertificateArn;
        this.distributionDomainName = builder.distributionDomainName;
        this.distributionHostedZoneId = builder.distributionHostedZoneId;
        this.endpointConfiguration = builder.endpointConfiguration;
        this.domainNameStatus = builder.domainNameStatus;
        this.domainNameStatusMessage = builder.domainNameStatusMessage;
        this.securityPolicy = builder.securityPolicy;
        this.tags = builder.tags;
        this.mutualTlsAuthentication = builder.mutualTlsAuthentication;
        this.ownershipVerificationCertificateArn = builder.ownershipVerificationCertificateArn;
        this.managementPolicy = builder.managementPolicy;
        this.policy = builder.policy;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String domainNameId() {
        return this.domainNameId;
    }

    public final String domainNameArn() {
        return this.domainNameArn;
    }

    public final String certificateName() {
        return this.certificateName;
    }

    public final String certificateArn() {
        return this.certificateArn;
    }

    public final Instant certificateUploadDate() {
        return this.certificateUploadDate;
    }

    public final String regionalDomainName() {
        return this.regionalDomainName;
    }

    public final String regionalHostedZoneId() {
        return this.regionalHostedZoneId;
    }

    public final String regionalCertificateName() {
        return this.regionalCertificateName;
    }

    public final String regionalCertificateArn() {
        return this.regionalCertificateArn;
    }

    public final String distributionDomainName() {
        return this.distributionDomainName;
    }

    public final String distributionHostedZoneId() {
        return this.distributionHostedZoneId;
    }

    public final EndpointConfiguration endpointConfiguration() {
        return this.endpointConfiguration;
    }

    public final DomainNameStatus domainNameStatus() {
        return DomainNameStatus.fromValue(this.domainNameStatus);
    }

    public final String domainNameStatusAsString() {
        return this.domainNameStatus;
    }

    public final String domainNameStatusMessage() {
        return this.domainNameStatusMessage;
    }

    public final SecurityPolicy securityPolicy() {
        return SecurityPolicy.fromValue(this.securityPolicy);
    }

    public final String securityPolicyAsString() {
        return this.securityPolicy;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final MutualTlsAuthentication mutualTlsAuthentication() {
        return this.mutualTlsAuthentication;
    }

    public final String ownershipVerificationCertificateArn() {
        return this.ownershipVerificationCertificateArn;
    }

    public final String managementPolicy() {
        return this.managementPolicy;
    }

    public final String policy() {
        return this.policy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainNameId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainNameArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateUploadDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionalDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionalHostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionalCertificateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionalCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionHostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainNameStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainNameStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.mutualTlsAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownershipVerificationCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.managementPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainNameResponse)) {
            return false;
        }
        CreateDomainNameResponse other = (CreateDomainNameResponse)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.domainNameId(), other.domainNameId()) && Objects.equals(this.domainNameArn(), other.domainNameArn()) && Objects.equals(this.certificateName(), other.certificateName()) && Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.certificateUploadDate(), other.certificateUploadDate()) && Objects.equals(this.regionalDomainName(), other.regionalDomainName()) && Objects.equals(this.regionalHostedZoneId(), other.regionalHostedZoneId()) && Objects.equals(this.regionalCertificateName(), other.regionalCertificateName()) && Objects.equals(this.regionalCertificateArn(), other.regionalCertificateArn()) && Objects.equals(this.distributionDomainName(), other.distributionDomainName()) && Objects.equals(this.distributionHostedZoneId(), other.distributionHostedZoneId()) && Objects.equals(this.endpointConfiguration(), other.endpointConfiguration()) && Objects.equals(this.domainNameStatusAsString(), other.domainNameStatusAsString()) && Objects.equals(this.domainNameStatusMessage(), other.domainNameStatusMessage()) && Objects.equals(this.securityPolicyAsString(), other.securityPolicyAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.mutualTlsAuthentication(), other.mutualTlsAuthentication()) && Objects.equals(this.ownershipVerificationCertificateArn(), other.ownershipVerificationCertificateArn()) && Objects.equals(this.managementPolicy(), other.managementPolicy()) && Objects.equals(this.policy(), other.policy());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDomainNameResponse").add("DomainName", (Object)this.domainName()).add("DomainNameId", (Object)this.domainNameId()).add("DomainNameArn", (Object)this.domainNameArn()).add("CertificateName", (Object)this.certificateName()).add("CertificateArn", (Object)this.certificateArn()).add("CertificateUploadDate", (Object)this.certificateUploadDate()).add("RegionalDomainName", (Object)this.regionalDomainName()).add("RegionalHostedZoneId", (Object)this.regionalHostedZoneId()).add("RegionalCertificateName", (Object)this.regionalCertificateName()).add("RegionalCertificateArn", (Object)this.regionalCertificateArn()).add("DistributionDomainName", (Object)this.distributionDomainName()).add("DistributionHostedZoneId", (Object)this.distributionHostedZoneId()).add("EndpointConfiguration", (Object)this.endpointConfiguration()).add("DomainNameStatus", (Object)this.domainNameStatusAsString()).add("DomainNameStatusMessage", (Object)this.domainNameStatusMessage()).add("SecurityPolicy", (Object)this.securityPolicyAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("MutualTlsAuthentication", (Object)this.mutualTlsAuthentication()).add("OwnershipVerificationCertificateArn", (Object)this.ownershipVerificationCertificateArn()).add("ManagementPolicy", (Object)this.managementPolicy()).add("Policy", (Object)this.policy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "domainNameId": {
                return Optional.ofNullable(clazz.cast(this.domainNameId()));
            }
            case "domainNameArn": {
                return Optional.ofNullable(clazz.cast(this.domainNameArn()));
            }
            case "certificateName": {
                return Optional.ofNullable(clazz.cast(this.certificateName()));
            }
            case "certificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "certificateUploadDate": {
                return Optional.ofNullable(clazz.cast(this.certificateUploadDate()));
            }
            case "regionalDomainName": {
                return Optional.ofNullable(clazz.cast(this.regionalDomainName()));
            }
            case "regionalHostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.regionalHostedZoneId()));
            }
            case "regionalCertificateName": {
                return Optional.ofNullable(clazz.cast(this.regionalCertificateName()));
            }
            case "regionalCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.regionalCertificateArn()));
            }
            case "distributionDomainName": {
                return Optional.ofNullable(clazz.cast(this.distributionDomainName()));
            }
            case "distributionHostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.distributionHostedZoneId()));
            }
            case "endpointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.endpointConfiguration()));
            }
            case "domainNameStatus": {
                return Optional.ofNullable(clazz.cast(this.domainNameStatusAsString()));
            }
            case "domainNameStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.domainNameStatusMessage()));
            }
            case "securityPolicy": {
                return Optional.ofNullable(clazz.cast(this.securityPolicyAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "mutualTlsAuthentication": {
                return Optional.ofNullable(clazz.cast(this.mutualTlsAuthentication()));
            }
            case "ownershipVerificationCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.ownershipVerificationCertificateArn()));
            }
            case "managementPolicy": {
                return Optional.ofNullable(clazz.cast(this.managementPolicy()));
            }
            case "policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("domainNameId", DOMAIN_NAME_ID_FIELD);
        map.put("domainNameArn", DOMAIN_NAME_ARN_FIELD);
        map.put("certificateName", CERTIFICATE_NAME_FIELD);
        map.put("certificateArn", CERTIFICATE_ARN_FIELD);
        map.put("certificateUploadDate", CERTIFICATE_UPLOAD_DATE_FIELD);
        map.put("regionalDomainName", REGIONAL_DOMAIN_NAME_FIELD);
        map.put("regionalHostedZoneId", REGIONAL_HOSTED_ZONE_ID_FIELD);
        map.put("regionalCertificateName", REGIONAL_CERTIFICATE_NAME_FIELD);
        map.put("regionalCertificateArn", REGIONAL_CERTIFICATE_ARN_FIELD);
        map.put("distributionDomainName", DISTRIBUTION_DOMAIN_NAME_FIELD);
        map.put("distributionHostedZoneId", DISTRIBUTION_HOSTED_ZONE_ID_FIELD);
        map.put("endpointConfiguration", ENDPOINT_CONFIGURATION_FIELD);
        map.put("domainNameStatus", DOMAIN_NAME_STATUS_FIELD);
        map.put("domainNameStatusMessage", DOMAIN_NAME_STATUS_MESSAGE_FIELD);
        map.put("securityPolicy", SECURITY_POLICY_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("mutualTlsAuthentication", MUTUAL_TLS_AUTHENTICATION_FIELD);
        map.put("ownershipVerificationCertificateArn", OWNERSHIP_VERIFICATION_CERTIFICATE_ARN_FIELD);
        map.put("managementPolicy", MANAGEMENT_POLICY_FIELD);
        map.put("policy", POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainNameResponse, T> g) {
        return obj -> g.apply((CreateDomainNameResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String domainName;
        private String domainNameId;
        private String domainNameArn;
        private String certificateName;
        private String certificateArn;
        private Instant certificateUploadDate;
        private String regionalDomainName;
        private String regionalHostedZoneId;
        private String regionalCertificateName;
        private String regionalCertificateArn;
        private String distributionDomainName;
        private String distributionHostedZoneId;
        private EndpointConfiguration endpointConfiguration;
        private String domainNameStatus;
        private String domainNameStatusMessage;
        private String securityPolicy;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private MutualTlsAuthentication mutualTlsAuthentication;
        private String ownershipVerificationCertificateArn;
        private String managementPolicy;
        private String policy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainNameResponse model) {
            super(model);
            this.domainName(model.domainName);
            this.domainNameId(model.domainNameId);
            this.domainNameArn(model.domainNameArn);
            this.certificateName(model.certificateName);
            this.certificateArn(model.certificateArn);
            this.certificateUploadDate(model.certificateUploadDate);
            this.regionalDomainName(model.regionalDomainName);
            this.regionalHostedZoneId(model.regionalHostedZoneId);
            this.regionalCertificateName(model.regionalCertificateName);
            this.regionalCertificateArn(model.regionalCertificateArn);
            this.distributionDomainName(model.distributionDomainName);
            this.distributionHostedZoneId(model.distributionHostedZoneId);
            this.endpointConfiguration(model.endpointConfiguration);
            this.domainNameStatus(model.domainNameStatus);
            this.domainNameStatusMessage(model.domainNameStatusMessage);
            this.securityPolicy(model.securityPolicy);
            this.tags(model.tags);
            this.mutualTlsAuthentication(model.mutualTlsAuthentication);
            this.ownershipVerificationCertificateArn(model.ownershipVerificationCertificateArn);
            this.managementPolicy(model.managementPolicy);
            this.policy(model.policy);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getDomainNameId() {
            return this.domainNameId;
        }

        public final void setDomainNameId(String domainNameId) {
            this.domainNameId = domainNameId;
        }

        @Override
        public final Builder domainNameId(String domainNameId) {
            this.domainNameId = domainNameId;
            return this;
        }

        public final String getDomainNameArn() {
            return this.domainNameArn;
        }

        public final void setDomainNameArn(String domainNameArn) {
            this.domainNameArn = domainNameArn;
        }

        @Override
        public final Builder domainNameArn(String domainNameArn) {
            this.domainNameArn = domainNameArn;
            return this;
        }

        public final String getCertificateName() {
            return this.certificateName;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final Instant getCertificateUploadDate() {
            return this.certificateUploadDate;
        }

        public final void setCertificateUploadDate(Instant certificateUploadDate) {
            this.certificateUploadDate = certificateUploadDate;
        }

        @Override
        public final Builder certificateUploadDate(Instant certificateUploadDate) {
            this.certificateUploadDate = certificateUploadDate;
            return this;
        }

        public final String getRegionalDomainName() {
            return this.regionalDomainName;
        }

        public final void setRegionalDomainName(String regionalDomainName) {
            this.regionalDomainName = regionalDomainName;
        }

        @Override
        public final Builder regionalDomainName(String regionalDomainName) {
            this.regionalDomainName = regionalDomainName;
            return this;
        }

        public final String getRegionalHostedZoneId() {
            return this.regionalHostedZoneId;
        }

        public final void setRegionalHostedZoneId(String regionalHostedZoneId) {
            this.regionalHostedZoneId = regionalHostedZoneId;
        }

        @Override
        public final Builder regionalHostedZoneId(String regionalHostedZoneId) {
            this.regionalHostedZoneId = regionalHostedZoneId;
            return this;
        }

        public final String getRegionalCertificateName() {
            return this.regionalCertificateName;
        }

        public final void setRegionalCertificateName(String regionalCertificateName) {
            this.regionalCertificateName = regionalCertificateName;
        }

        @Override
        public final Builder regionalCertificateName(String regionalCertificateName) {
            this.regionalCertificateName = regionalCertificateName;
            return this;
        }

        public final String getRegionalCertificateArn() {
            return this.regionalCertificateArn;
        }

        public final void setRegionalCertificateArn(String regionalCertificateArn) {
            this.regionalCertificateArn = regionalCertificateArn;
        }

        @Override
        public final Builder regionalCertificateArn(String regionalCertificateArn) {
            this.regionalCertificateArn = regionalCertificateArn;
            return this;
        }

        public final String getDistributionDomainName() {
            return this.distributionDomainName;
        }

        public final void setDistributionDomainName(String distributionDomainName) {
            this.distributionDomainName = distributionDomainName;
        }

        @Override
        public final Builder distributionDomainName(String distributionDomainName) {
            this.distributionDomainName = distributionDomainName;
            return this;
        }

        public final String getDistributionHostedZoneId() {
            return this.distributionHostedZoneId;
        }

        public final void setDistributionHostedZoneId(String distributionHostedZoneId) {
            this.distributionHostedZoneId = distributionHostedZoneId;
        }

        @Override
        public final Builder distributionHostedZoneId(String distributionHostedZoneId) {
            this.distributionHostedZoneId = distributionHostedZoneId;
            return this;
        }

        public final EndpointConfiguration.Builder getEndpointConfiguration() {
            return this.endpointConfiguration != null ? this.endpointConfiguration.toBuilder() : null;
        }

        public final void setEndpointConfiguration(EndpointConfiguration.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        @Override
        public final Builder endpointConfiguration(EndpointConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final String getDomainNameStatus() {
            return this.domainNameStatus;
        }

        public final void setDomainNameStatus(String domainNameStatus) {
            this.domainNameStatus = domainNameStatus;
        }

        @Override
        public final Builder domainNameStatus(String domainNameStatus) {
            this.domainNameStatus = domainNameStatus;
            return this;
        }

        @Override
        public final Builder domainNameStatus(DomainNameStatus domainNameStatus) {
            this.domainNameStatus(domainNameStatus == null ? null : domainNameStatus.toString());
            return this;
        }

        public final String getDomainNameStatusMessage() {
            return this.domainNameStatusMessage;
        }

        public final void setDomainNameStatusMessage(String domainNameStatusMessage) {
            this.domainNameStatusMessage = domainNameStatusMessage;
        }

        @Override
        public final Builder domainNameStatusMessage(String domainNameStatusMessage) {
            this.domainNameStatusMessage = domainNameStatusMessage;
            return this;
        }

        public final String getSecurityPolicy() {
            return this.securityPolicy;
        }

        public final void setSecurityPolicy(String securityPolicy) {
            this.securityPolicy = securityPolicy;
        }

        @Override
        public final Builder securityPolicy(String securityPolicy) {
            this.securityPolicy = securityPolicy;
            return this;
        }

        @Override
        public final Builder securityPolicy(SecurityPolicy securityPolicy) {
            this.securityPolicy(securityPolicy == null ? null : securityPolicy.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
            return this;
        }

        public final MutualTlsAuthentication.Builder getMutualTlsAuthentication() {
            return this.mutualTlsAuthentication != null ? this.mutualTlsAuthentication.toBuilder() : null;
        }

        public final void setMutualTlsAuthentication(MutualTlsAuthentication.BuilderImpl mutualTlsAuthentication) {
            this.mutualTlsAuthentication = mutualTlsAuthentication != null ? mutualTlsAuthentication.build() : null;
        }

        @Override
        public final Builder mutualTlsAuthentication(MutualTlsAuthentication mutualTlsAuthentication) {
            this.mutualTlsAuthentication = mutualTlsAuthentication;
            return this;
        }

        public final String getOwnershipVerificationCertificateArn() {
            return this.ownershipVerificationCertificateArn;
        }

        public final void setOwnershipVerificationCertificateArn(String ownershipVerificationCertificateArn) {
            this.ownershipVerificationCertificateArn = ownershipVerificationCertificateArn;
        }

        @Override
        public final Builder ownershipVerificationCertificateArn(String ownershipVerificationCertificateArn) {
            this.ownershipVerificationCertificateArn = ownershipVerificationCertificateArn;
            return this;
        }

        public final String getManagementPolicy() {
            return this.managementPolicy;
        }

        public final void setManagementPolicy(String managementPolicy) {
            this.managementPolicy = managementPolicy;
        }

        @Override
        public final Builder managementPolicy(String managementPolicy) {
            this.managementPolicy = managementPolicy;
            return this;
        }

        public final String getPolicy() {
            return this.policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public CreateDomainNameResponse build() {
            return new CreateDomainNameResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDomainNameResponse> {
        public Builder domainName(String var1);

        public Builder domainNameId(String var1);

        public Builder domainNameArn(String var1);

        public Builder certificateName(String var1);

        public Builder certificateArn(String var1);

        public Builder certificateUploadDate(Instant var1);

        public Builder regionalDomainName(String var1);

        public Builder regionalHostedZoneId(String var1);

        public Builder regionalCertificateName(String var1);

        public Builder regionalCertificateArn(String var1);

        public Builder distributionDomainName(String var1);

        public Builder distributionHostedZoneId(String var1);

        public Builder endpointConfiguration(EndpointConfiguration var1);

        default public Builder endpointConfiguration(Consumer<EndpointConfiguration.Builder> endpointConfiguration) {
            return this.endpointConfiguration((EndpointConfiguration)((EndpointConfiguration.Builder)EndpointConfiguration.builder().applyMutation(endpointConfiguration)).build());
        }

        public Builder domainNameStatus(String var1);

        public Builder domainNameStatus(DomainNameStatus var1);

        public Builder domainNameStatusMessage(String var1);

        public Builder securityPolicy(String var1);

        public Builder securityPolicy(SecurityPolicy var1);

        public Builder tags(Map<String, String> var1);

        public Builder mutualTlsAuthentication(MutualTlsAuthentication var1);

        default public Builder mutualTlsAuthentication(Consumer<MutualTlsAuthentication.Builder> mutualTlsAuthentication) {
            return this.mutualTlsAuthentication((MutualTlsAuthentication)((MutualTlsAuthentication.Builder)MutualTlsAuthentication.builder().applyMutation(mutualTlsAuthentication)).build());
        }

        public Builder ownershipVerificationCertificateArn(String var1);

        public Builder managementPolicy(String var1);

        public Builder policy(String var1);
    }
}

