/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.ListOfStringCopier;
import software.amazon.awssdk.services.apigateway.model.ThrottleSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccountResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, GetAccountResponse> {
    private static final SdkField<String> CLOUDWATCH_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudwatchRoleArn").getter(GetAccountResponse.getter(GetAccountResponse::cloudwatchRoleArn)).setter(GetAccountResponse.setter(Builder::cloudwatchRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudwatchRoleArn").build()}).build();
    private static final SdkField<ThrottleSettings> THROTTLE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("throttleSettings").getter(GetAccountResponse.getter(GetAccountResponse::throttleSettings)).setter(GetAccountResponse.setter(Builder::throttleSettings)).constructor(ThrottleSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throttleSettings").build()}).build();
    private static final SdkField<List<String>> FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("features").getter(GetAccountResponse.getter(GetAccountResponse::features)).setter(GetAccountResponse.setter(Builder::features)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> API_KEY_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiKeyVersion").getter(GetAccountResponse.getter(GetAccountResponse::apiKeyVersion)).setter(GetAccountResponse.setter(Builder::apiKeyVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeyVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUDWATCH_ROLE_ARN_FIELD, THROTTLE_SETTINGS_FIELD, FEATURES_FIELD, API_KEY_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAccountResponse.memberNameToFieldInitializer();
    private final String cloudwatchRoleArn;
    private final ThrottleSettings throttleSettings;
    private final List<String> features;
    private final String apiKeyVersion;

    private GetAccountResponse(BuilderImpl builder) {
        super(builder);
        this.cloudwatchRoleArn = builder.cloudwatchRoleArn;
        this.throttleSettings = builder.throttleSettings;
        this.features = builder.features;
        this.apiKeyVersion = builder.apiKeyVersion;
    }

    public final String cloudwatchRoleArn() {
        return this.cloudwatchRoleArn;
    }

    public final ThrottleSettings throttleSettings() {
        return this.throttleSettings;
    }

    public final boolean hasFeatures() {
        return this.features != null && !(this.features instanceof SdkAutoConstructList);
    }

    public final List<String> features() {
        return this.features;
    }

    public final String apiKeyVersion() {
        return this.apiKeyVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudwatchRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.throttleSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatures() ? this.features() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeyVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountResponse)) {
            return false;
        }
        GetAccountResponse other = (GetAccountResponse)((Object)obj);
        return Objects.equals(this.cloudwatchRoleArn(), other.cloudwatchRoleArn()) && Objects.equals(this.throttleSettings(), other.throttleSettings()) && this.hasFeatures() == other.hasFeatures() && Objects.equals(this.features(), other.features()) && Objects.equals(this.apiKeyVersion(), other.apiKeyVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccountResponse").add("CloudwatchRoleArn", (Object)this.cloudwatchRoleArn()).add("ThrottleSettings", (Object)this.throttleSettings()).add("Features", this.hasFeatures() ? this.features() : null).add("ApiKeyVersion", (Object)this.apiKeyVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudwatchRoleArn": {
                return Optional.ofNullable(clazz.cast(this.cloudwatchRoleArn()));
            }
            case "throttleSettings": {
                return Optional.ofNullable(clazz.cast(this.throttleSettings()));
            }
            case "features": {
                return Optional.ofNullable(clazz.cast(this.features()));
            }
            case "apiKeyVersion": {
                return Optional.ofNullable(clazz.cast(this.apiKeyVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cloudwatchRoleArn", CLOUDWATCH_ROLE_ARN_FIELD);
        map.put("throttleSettings", THROTTLE_SETTINGS_FIELD);
        map.put("features", FEATURES_FIELD);
        map.put("apiKeyVersion", API_KEY_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccountResponse, T> g) {
        return obj -> g.apply((GetAccountResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String cloudwatchRoleArn;
        private ThrottleSettings throttleSettings;
        private List<String> features = DefaultSdkAutoConstructList.getInstance();
        private String apiKeyVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountResponse model) {
            super(model);
            this.cloudwatchRoleArn(model.cloudwatchRoleArn);
            this.throttleSettings(model.throttleSettings);
            this.features(model.features);
            this.apiKeyVersion(model.apiKeyVersion);
        }

        public final String getCloudwatchRoleArn() {
            return this.cloudwatchRoleArn;
        }

        public final void setCloudwatchRoleArn(String cloudwatchRoleArn) {
            this.cloudwatchRoleArn = cloudwatchRoleArn;
        }

        @Override
        public final Builder cloudwatchRoleArn(String cloudwatchRoleArn) {
            this.cloudwatchRoleArn = cloudwatchRoleArn;
            return this;
        }

        public final ThrottleSettings.Builder getThrottleSettings() {
            return this.throttleSettings != null ? this.throttleSettings.toBuilder() : null;
        }

        public final void setThrottleSettings(ThrottleSettings.BuilderImpl throttleSettings) {
            this.throttleSettings = throttleSettings != null ? throttleSettings.build() : null;
        }

        @Override
        public final Builder throttleSettings(ThrottleSettings throttleSettings) {
            this.throttleSettings = throttleSettings;
            return this;
        }

        public final Collection<String> getFeatures() {
            if (this.features instanceof SdkAutoConstructList) {
                return null;
            }
            return this.features;
        }

        public final void setFeatures(Collection<String> features) {
            this.features = ListOfStringCopier.copy(features);
        }

        @Override
        public final Builder features(Collection<String> features) {
            this.features = ListOfStringCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(String ... features) {
            this.features(Arrays.asList(features));
            return this;
        }

        public final String getApiKeyVersion() {
            return this.apiKeyVersion;
        }

        public final void setApiKeyVersion(String apiKeyVersion) {
            this.apiKeyVersion = apiKeyVersion;
        }

        @Override
        public final Builder apiKeyVersion(String apiKeyVersion) {
            this.apiKeyVersion = apiKeyVersion;
            return this;
        }

        @Override
        public GetAccountResponse build() {
            return new GetAccountResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccountResponse> {
        public Builder cloudwatchRoleArn(String var1);

        public Builder throttleSettings(ThrottleSettings var1);

        default public Builder throttleSettings(Consumer<ThrottleSettings.Builder> throttleSettings) {
            return this.throttleSettings((ThrottleSettings)((ThrottleSettings.Builder)ThrottleSettings.builder().applyMutation(throttleSettings)).build());
        }

        public Builder features(Collection<String> var1);

        public Builder features(String ... var1);

        public Builder apiKeyVersion(String var1);
    }
}

