/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.ConnectionType;
import software.amazon.awssdk.services.apigateway.model.ContentHandlingStrategy;
import software.amazon.awssdk.services.apigateway.model.IntegrationType;
import software.amazon.awssdk.services.apigateway.model.ListOfStringCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.services.apigateway.model.TlsConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutIntegrationRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, PutIntegrationRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("restApiId").getter(PutIntegrationRequest.getter(PutIntegrationRequest::restApiId)).setter(PutIntegrationRequest.setter(Builder::restApiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(PutIntegrationRequest.getter(PutIntegrationRequest::resourceId)).setter(PutIntegrationRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("resource_id").build()}).build();
    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("httpMethod").getter(PutIntegrationRequest.getter(PutIntegrationRequest::httpMethod)).setter(PutIntegrationRequest.setter(Builder::httpMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("http_method").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(PutIntegrationRequest.getter(PutIntegrationRequest::typeAsString)).setter(PutIntegrationRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> INTEGRATION_HTTP_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("integrationHttpMethod").getter(PutIntegrationRequest.getter(PutIntegrationRequest::integrationHttpMethod)).setter(PutIntegrationRequest.setter(Builder::integrationHttpMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpMethod").build()}).build();
    private static final SdkField<String> URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uri").getter(PutIntegrationRequest.getter(PutIntegrationRequest::uri)).setter(PutIntegrationRequest.setter(Builder::uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()}).build();
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionType").getter(PutIntegrationRequest.getter(PutIntegrationRequest::connectionTypeAsString)).setter(PutIntegrationRequest.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionType").build()}).build();
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionId").getter(PutIntegrationRequest.getter(PutIntegrationRequest::connectionId)).setter(PutIntegrationRequest.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()}).build();
    private static final SdkField<String> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("credentials").getter(PutIntegrationRequest.getter(PutIntegrationRequest::credentials)).setter(PutIntegrationRequest.setter(Builder::credentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentials").build()}).build();
    private static final SdkField<Map<String, String>> REQUEST_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("requestParameters").getter(PutIntegrationRequest.getter(PutIntegrationRequest::requestParameters)).setter(PutIntegrationRequest.setter(Builder::requestParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> REQUEST_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("requestTemplates").getter(PutIntegrationRequest.getter(PutIntegrationRequest::requestTemplates)).setter(PutIntegrationRequest.setter(Builder::requestTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestTemplates").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> PASSTHROUGH_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("passthroughBehavior").getter(PutIntegrationRequest.getter(PutIntegrationRequest::passthroughBehavior)).setter(PutIntegrationRequest.setter(Builder::passthroughBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passthroughBehavior").build()}).build();
    private static final SdkField<String> CACHE_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cacheNamespace").getter(PutIntegrationRequest.getter(PutIntegrationRequest::cacheNamespace)).setter(PutIntegrationRequest.setter(Builder::cacheNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheNamespace").build()}).build();
    private static final SdkField<List<String>> CACHE_KEY_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cacheKeyParameters").getter(PutIntegrationRequest.getter(PutIntegrationRequest::cacheKeyParameters)).setter(PutIntegrationRequest.setter(Builder::cacheKeyParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheKeyParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONTENT_HANDLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentHandling").getter(PutIntegrationRequest.getter(PutIntegrationRequest::contentHandlingAsString)).setter(PutIntegrationRequest.setter(Builder::contentHandling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentHandling").build()}).build();
    private static final SdkField<Integer> TIMEOUT_IN_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutInMillis").getter(PutIntegrationRequest.getter(PutIntegrationRequest::timeoutInMillis)).setter(PutIntegrationRequest.setter(Builder::timeoutInMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInMillis").build()}).build();
    private static final SdkField<TlsConfig> TLS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tlsConfig").getter(PutIntegrationRequest.getter(PutIntegrationRequest::tlsConfig)).setter(PutIntegrationRequest.setter(Builder::tlsConfig)).constructor(TlsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tlsConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD, RESOURCE_ID_FIELD, HTTP_METHOD_FIELD, TYPE_FIELD, INTEGRATION_HTTP_METHOD_FIELD, URI_FIELD, CONNECTION_TYPE_FIELD, CONNECTION_ID_FIELD, CREDENTIALS_FIELD, REQUEST_PARAMETERS_FIELD, REQUEST_TEMPLATES_FIELD, PASSTHROUGH_BEHAVIOR_FIELD, CACHE_NAMESPACE_FIELD, CACHE_KEY_PARAMETERS_FIELD, CONTENT_HANDLING_FIELD, TIMEOUT_IN_MILLIS_FIELD, TLS_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("restapi_id", REST_API_ID_FIELD);
            this.put("resource_id", RESOURCE_ID_FIELD);
            this.put("http_method", HTTP_METHOD_FIELD);
            this.put("type", TYPE_FIELD);
            this.put("httpMethod", INTEGRATION_HTTP_METHOD_FIELD);
            this.put("uri", URI_FIELD);
            this.put("connectionType", CONNECTION_TYPE_FIELD);
            this.put("connectionId", CONNECTION_ID_FIELD);
            this.put("credentials", CREDENTIALS_FIELD);
            this.put("requestParameters", REQUEST_PARAMETERS_FIELD);
            this.put("requestTemplates", REQUEST_TEMPLATES_FIELD);
            this.put("passthroughBehavior", PASSTHROUGH_BEHAVIOR_FIELD);
            this.put("cacheNamespace", CACHE_NAMESPACE_FIELD);
            this.put("cacheKeyParameters", CACHE_KEY_PARAMETERS_FIELD);
            this.put("contentHandling", CONTENT_HANDLING_FIELD);
            this.put("timeoutInMillis", TIMEOUT_IN_MILLIS_FIELD);
            this.put("tlsConfig", TLS_CONFIG_FIELD);
        }
    });
    private final String restApiId;
    private final String resourceId;
    private final String httpMethod;
    private final String type;
    private final String integrationHttpMethod;
    private final String uri;
    private final String connectionType;
    private final String connectionId;
    private final String credentials;
    private final Map<String, String> requestParameters;
    private final Map<String, String> requestTemplates;
    private final String passthroughBehavior;
    private final String cacheNamespace;
    private final List<String> cacheKeyParameters;
    private final String contentHandling;
    private final Integer timeoutInMillis;
    private final TlsConfig tlsConfig;

    private PutIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.resourceId = builder.resourceId;
        this.httpMethod = builder.httpMethod;
        this.type = builder.type;
        this.integrationHttpMethod = builder.integrationHttpMethod;
        this.uri = builder.uri;
        this.connectionType = builder.connectionType;
        this.connectionId = builder.connectionId;
        this.credentials = builder.credentials;
        this.requestParameters = builder.requestParameters;
        this.requestTemplates = builder.requestTemplates;
        this.passthroughBehavior = builder.passthroughBehavior;
        this.cacheNamespace = builder.cacheNamespace;
        this.cacheKeyParameters = builder.cacheKeyParameters;
        this.contentHandling = builder.contentHandling;
        this.timeoutInMillis = builder.timeoutInMillis;
        this.tlsConfig = builder.tlsConfig;
    }

    public final String restApiId() {
        return this.restApiId;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String httpMethod() {
        return this.httpMethod;
    }

    public final IntegrationType type() {
        return IntegrationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String integrationHttpMethod() {
        return this.integrationHttpMethod;
    }

    public final String uri() {
        return this.uri;
    }

    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(this.connectionType);
    }

    public final String connectionTypeAsString() {
        return this.connectionType;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public final String credentials() {
        return this.credentials;
    }

    public final boolean hasRequestParameters() {
        return this.requestParameters != null && !(this.requestParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> requestParameters() {
        return this.requestParameters;
    }

    public final boolean hasRequestTemplates() {
        return this.requestTemplates != null && !(this.requestTemplates instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> requestTemplates() {
        return this.requestTemplates;
    }

    public final String passthroughBehavior() {
        return this.passthroughBehavior;
    }

    public final String cacheNamespace() {
        return this.cacheNamespace;
    }

    public final boolean hasCacheKeyParameters() {
        return this.cacheKeyParameters != null && !(this.cacheKeyParameters instanceof SdkAutoConstructList);
    }

    public final List<String> cacheKeyParameters() {
        return this.cacheKeyParameters;
    }

    public final ContentHandlingStrategy contentHandling() {
        return ContentHandlingStrategy.fromValue(this.contentHandling);
    }

    public final String contentHandlingAsString() {
        return this.contentHandling;
    }

    public final Integer timeoutInMillis() {
        return this.timeoutInMillis;
    }

    public final TlsConfig tlsConfig() {
        return this.tlsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationHttpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestParameters() ? this.requestParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestTemplates() ? this.requestTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.passthroughBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheKeyParameters() ? this.cacheKeyParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contentHandlingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIntegrationRequest)) {
            return false;
        }
        PutIntegrationRequest other = (PutIntegrationRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.httpMethod(), other.httpMethod()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.integrationHttpMethod(), other.integrationHttpMethod()) && Objects.equals(this.uri(), other.uri()) && Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString()) && Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.credentials(), other.credentials()) && this.hasRequestParameters() == other.hasRequestParameters() && Objects.equals(this.requestParameters(), other.requestParameters()) && this.hasRequestTemplates() == other.hasRequestTemplates() && Objects.equals(this.requestTemplates(), other.requestTemplates()) && Objects.equals(this.passthroughBehavior(), other.passthroughBehavior()) && Objects.equals(this.cacheNamespace(), other.cacheNamespace()) && this.hasCacheKeyParameters() == other.hasCacheKeyParameters() && Objects.equals(this.cacheKeyParameters(), other.cacheKeyParameters()) && Objects.equals(this.contentHandlingAsString(), other.contentHandlingAsString()) && Objects.equals(this.timeoutInMillis(), other.timeoutInMillis()) && Objects.equals(this.tlsConfig(), other.tlsConfig());
    }

    public final String toString() {
        return ToString.builder((String)"PutIntegrationRequest").add("RestApiId", (Object)this.restApiId()).add("ResourceId", (Object)this.resourceId()).add("HttpMethod", (Object)this.httpMethod()).add("Type", (Object)this.typeAsString()).add("IntegrationHttpMethod", (Object)this.integrationHttpMethod()).add("Uri", (Object)this.uri()).add("ConnectionType", (Object)this.connectionTypeAsString()).add("ConnectionId", (Object)this.connectionId()).add("Credentials", (Object)this.credentials()).add("RequestParameters", this.hasRequestParameters() ? this.requestParameters() : null).add("RequestTemplates", this.hasRequestTemplates() ? this.requestTemplates() : null).add("PassthroughBehavior", (Object)this.passthroughBehavior()).add("CacheNamespace", (Object)this.cacheNamespace()).add("CacheKeyParameters", this.hasCacheKeyParameters() ? this.cacheKeyParameters() : null).add("ContentHandling", (Object)this.contentHandlingAsString()).add("TimeoutInMillis", (Object)this.timeoutInMillis()).add("TlsConfig", (Object)this.tlsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "httpMethod": {
                return Optional.ofNullable(clazz.cast(this.httpMethod()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "integrationHttpMethod": {
                return Optional.ofNullable(clazz.cast(this.integrationHttpMethod()));
            }
            case "uri": {
                return Optional.ofNullable(clazz.cast(this.uri()));
            }
            case "connectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "requestParameters": {
                return Optional.ofNullable(clazz.cast(this.requestParameters()));
            }
            case "requestTemplates": {
                return Optional.ofNullable(clazz.cast(this.requestTemplates()));
            }
            case "passthroughBehavior": {
                return Optional.ofNullable(clazz.cast(this.passthroughBehavior()));
            }
            case "cacheNamespace": {
                return Optional.ofNullable(clazz.cast(this.cacheNamespace()));
            }
            case "cacheKeyParameters": {
                return Optional.ofNullable(clazz.cast(this.cacheKeyParameters()));
            }
            case "contentHandling": {
                return Optional.ofNullable(clazz.cast(this.contentHandlingAsString()));
            }
            case "timeoutInMillis": {
                return Optional.ofNullable(clazz.cast(this.timeoutInMillis()));
            }
            case "tlsConfig": {
                return Optional.ofNullable(clazz.cast(this.tlsConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutIntegrationRequest, T> g) {
        return obj -> g.apply((PutIntegrationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String resourceId;
        private String httpMethod;
        private String type;
        private String integrationHttpMethod;
        private String uri;
        private String connectionType;
        private String connectionId;
        private String credentials;
        private Map<String, String> requestParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> requestTemplates = DefaultSdkAutoConstructMap.getInstance();
        private String passthroughBehavior;
        private String cacheNamespace;
        private List<String> cacheKeyParameters = DefaultSdkAutoConstructList.getInstance();
        private String contentHandling;
        private Integer timeoutInMillis;
        private TlsConfig tlsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(PutIntegrationRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.resourceId(model.resourceId);
            this.httpMethod(model.httpMethod);
            this.type(model.type);
            this.integrationHttpMethod(model.integrationHttpMethod);
            this.uri(model.uri);
            this.connectionType(model.connectionType);
            this.connectionId(model.connectionId);
            this.credentials(model.credentials);
            this.requestParameters(model.requestParameters);
            this.requestTemplates(model.requestTemplates);
            this.passthroughBehavior(model.passthroughBehavior);
            this.cacheNamespace(model.cacheNamespace);
            this.cacheKeyParameters(model.cacheKeyParameters);
            this.contentHandling(model.contentHandling);
            this.timeoutInMillis(model.timeoutInMillis);
            this.tlsConfig(model.tlsConfig);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getHttpMethod() {
            return this.httpMethod;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IntegrationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getIntegrationHttpMethod() {
            return this.integrationHttpMethod;
        }

        public final void setIntegrationHttpMethod(String integrationHttpMethod) {
            this.integrationHttpMethod = integrationHttpMethod;
        }

        @Override
        public final Builder integrationHttpMethod(String integrationHttpMethod) {
            this.integrationHttpMethod = integrationHttpMethod;
            return this;
        }

        public final String getUri() {
            return this.uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getCredentials() {
            return this.credentials;
        }

        public final void setCredentials(String credentials) {
            this.credentials = credentials;
        }

        @Override
        public final Builder credentials(String credentials) {
            this.credentials = credentials;
            return this;
        }

        public final Map<String, String> getRequestParameters() {
            if (this.requestParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requestParameters;
        }

        public final void setRequestParameters(Map<String, String> requestParameters) {
            this.requestParameters = MapOfStringToStringCopier.copy(requestParameters);
        }

        @Override
        public final Builder requestParameters(Map<String, String> requestParameters) {
            this.requestParameters = MapOfStringToStringCopier.copy(requestParameters);
            return this;
        }

        public final Map<String, String> getRequestTemplates() {
            if (this.requestTemplates instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requestTemplates;
        }

        public final void setRequestTemplates(Map<String, String> requestTemplates) {
            this.requestTemplates = MapOfStringToStringCopier.copy(requestTemplates);
        }

        @Override
        public final Builder requestTemplates(Map<String, String> requestTemplates) {
            this.requestTemplates = MapOfStringToStringCopier.copy(requestTemplates);
            return this;
        }

        public final String getPassthroughBehavior() {
            return this.passthroughBehavior;
        }

        public final void setPassthroughBehavior(String passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
        }

        @Override
        public final Builder passthroughBehavior(String passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
            return this;
        }

        public final String getCacheNamespace() {
            return this.cacheNamespace;
        }

        public final void setCacheNamespace(String cacheNamespace) {
            this.cacheNamespace = cacheNamespace;
        }

        @Override
        public final Builder cacheNamespace(String cacheNamespace) {
            this.cacheNamespace = cacheNamespace;
            return this;
        }

        public final Collection<String> getCacheKeyParameters() {
            if (this.cacheKeyParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cacheKeyParameters;
        }

        public final void setCacheKeyParameters(Collection<String> cacheKeyParameters) {
            this.cacheKeyParameters = ListOfStringCopier.copy(cacheKeyParameters);
        }

        @Override
        public final Builder cacheKeyParameters(Collection<String> cacheKeyParameters) {
            this.cacheKeyParameters = ListOfStringCopier.copy(cacheKeyParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheKeyParameters(String ... cacheKeyParameters) {
            this.cacheKeyParameters(Arrays.asList(cacheKeyParameters));
            return this;
        }

        public final String getContentHandling() {
            return this.contentHandling;
        }

        public final void setContentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
        }

        @Override
        public final Builder contentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        @Override
        public final Builder contentHandling(ContentHandlingStrategy contentHandling) {
            this.contentHandling(contentHandling == null ? null : contentHandling.toString());
            return this;
        }

        public final Integer getTimeoutInMillis() {
            return this.timeoutInMillis;
        }

        public final void setTimeoutInMillis(Integer timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
        }

        @Override
        public final Builder timeoutInMillis(Integer timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
            return this;
        }

        public final TlsConfig.Builder getTlsConfig() {
            return this.tlsConfig != null ? this.tlsConfig.toBuilder() : null;
        }

        public final void setTlsConfig(TlsConfig.BuilderImpl tlsConfig) {
            this.tlsConfig = tlsConfig != null ? tlsConfig.build() : null;
        }

        @Override
        public final Builder tlsConfig(TlsConfig tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutIntegrationRequest build() {
            return new PutIntegrationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutIntegrationRequest> {
        public Builder restApiId(String var1);

        public Builder resourceId(String var1);

        public Builder httpMethod(String var1);

        public Builder type(String var1);

        public Builder type(IntegrationType var1);

        public Builder integrationHttpMethod(String var1);

        public Builder uri(String var1);

        public Builder connectionType(String var1);

        public Builder connectionType(ConnectionType var1);

        public Builder connectionId(String var1);

        public Builder credentials(String var1);

        public Builder requestParameters(Map<String, String> var1);

        public Builder requestTemplates(Map<String, String> var1);

        public Builder passthroughBehavior(String var1);

        public Builder cacheNamespace(String var1);

        public Builder cacheKeyParameters(Collection<String> var1);

        public Builder cacheKeyParameters(String ... var1);

        public Builder contentHandling(String var1);

        public Builder contentHandling(ContentHandlingStrategy var1);

        public Builder timeoutInMillis(Integer var1);

        public Builder tlsConfig(TlsConfig var1);

        default public Builder tlsConfig(Consumer<TlsConfig.Builder> tlsConfig) {
            return this.tlsConfig((TlsConfig)((TlsConfig.Builder)TlsConfig.builder().applyMutation(tlsConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

