/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A type of SDK that API Gateway can generate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SdkType implements SdkPojo, Serializable, ToCopyableBuilder<SdkType.Builder, SdkType> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(SdkType::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> FRIENDLY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("friendlyName").getter(getter(SdkType::friendlyName)).setter(setter(Builder::friendlyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("friendlyName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(SdkType::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<SdkConfigurationProperty>> CONFIGURATION_PROPERTIES_FIELD = SdkField
            .<List<SdkConfigurationProperty>> builder(MarshallingType.LIST)
            .memberName("configurationProperties")
            .getter(getter(SdkType::configurationProperties))
            .setter(setter(Builder::configurationProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SdkConfigurationProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(SdkConfigurationProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, FRIENDLY_NAME_FIELD,
            DESCRIPTION_FIELD, CONFIGURATION_PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String friendlyName;

    private final String description;

    private final List<SdkConfigurationProperty> configurationProperties;

    private SdkType(BuilderImpl builder) {
        this.id = builder.id;
        this.friendlyName = builder.friendlyName;
        this.description = builder.description;
        this.configurationProperties = builder.configurationProperties;
    }

    /**
     * <p>
     * The identifier of an SdkType instance.
     * </p>
     * 
     * @return The identifier of an SdkType instance.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The user-friendly name of an SdkType instance.
     * </p>
     * 
     * @return The user-friendly name of an SdkType instance.
     */
    public final String friendlyName() {
        return friendlyName;
    }

    /**
     * <p>
     * The description of an SdkType.
     * </p>
     * 
     * @return The description of an SdkType.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigurationProperties property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConfigurationProperties() {
        return configurationProperties != null && !(configurationProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of configuration properties of an SdkType.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurationProperties} method.
     * </p>
     * 
     * @return A list of configuration properties of an SdkType.
     */
    public final List<SdkConfigurationProperty> configurationProperties() {
        return configurationProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(friendlyName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurationProperties() ? configurationProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SdkType)) {
            return false;
        }
        SdkType other = (SdkType) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(friendlyName(), other.friendlyName())
                && Objects.equals(description(), other.description())
                && hasConfigurationProperties() == other.hasConfigurationProperties()
                && Objects.equals(configurationProperties(), other.configurationProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SdkType").add("Id", id()).add("FriendlyName", friendlyName()).add("Description", description())
                .add("ConfigurationProperties", hasConfigurationProperties() ? configurationProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "friendlyName":
            return Optional.ofNullable(clazz.cast(friendlyName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "configurationProperties":
            return Optional.ofNullable(clazz.cast(configurationProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SdkType, T> g) {
        return obj -> g.apply((SdkType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SdkType> {
        /**
         * <p>
         * The identifier of an SdkType instance.
         * </p>
         * 
         * @param id
         *        The identifier of an SdkType instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The user-friendly name of an SdkType instance.
         * </p>
         * 
         * @param friendlyName
         *        The user-friendly name of an SdkType instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder friendlyName(String friendlyName);

        /**
         * <p>
         * The description of an SdkType.
         * </p>
         * 
         * @param description
         *        The description of an SdkType.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of configuration properties of an SdkType.
         * </p>
         * 
         * @param configurationProperties
         *        A list of configuration properties of an SdkType.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationProperties(Collection<SdkConfigurationProperty> configurationProperties);

        /**
         * <p>
         * A list of configuration properties of an SdkType.
         * </p>
         * 
         * @param configurationProperties
         *        A list of configuration properties of an SdkType.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationProperties(SdkConfigurationProperty... configurationProperties);

        /**
         * <p>
         * A list of configuration properties of an SdkType.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apigateway.model.SdkConfigurationProperty.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.apigateway.model.SdkConfigurationProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apigateway.model.SdkConfigurationProperty.Builder#build()} is called
         * immediately and its result is passed to {@link #configurationProperties(List<SdkConfigurationProperty>)}.
         * 
         * @param configurationProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apigateway.model.SdkConfigurationProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationProperties(java.util.Collection<SdkConfigurationProperty>)
         */
        Builder configurationProperties(Consumer<SdkConfigurationProperty.Builder>... configurationProperties);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String friendlyName;

        private String description;

        private List<SdkConfigurationProperty> configurationProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SdkType model) {
            id(model.id);
            friendlyName(model.friendlyName);
            description(model.description);
            configurationProperties(model.configurationProperties);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getFriendlyName() {
            return friendlyName;
        }

        public final void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        @Override
        public final Builder friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<SdkConfigurationProperty.Builder> getConfigurationProperties() {
            List<SdkConfigurationProperty.Builder> result = ListOfSdkConfigurationPropertyCopier
                    .copyToBuilder(this.configurationProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationProperties(Collection<SdkConfigurationProperty.BuilderImpl> configurationProperties) {
            this.configurationProperties = ListOfSdkConfigurationPropertyCopier.copyFromBuilder(configurationProperties);
        }

        @Override
        public final Builder configurationProperties(Collection<SdkConfigurationProperty> configurationProperties) {
            this.configurationProperties = ListOfSdkConfigurationPropertyCopier.copy(configurationProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationProperties(SdkConfigurationProperty... configurationProperties) {
            configurationProperties(Arrays.asList(configurationProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationProperties(Consumer<SdkConfigurationProperty.Builder>... configurationProperties) {
            configurationProperties(Stream.of(configurationProperties)
                    .map(c -> SdkConfigurationProperty.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SdkType build() {
            return new SdkType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
