/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayAsyncClient;
import software.amazon.awssdk.services.apigateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.apigateway.model.DomainName;
import software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest;
import software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse;

public class GetDomainNamesPublisher
implements SdkPublisher<GetDomainNamesResponse> {
    private final ApiGatewayAsyncClient client;
    private final GetDomainNamesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetDomainNamesPublisher(ApiGatewayAsyncClient client, GetDomainNamesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetDomainNamesPublisher(ApiGatewayAsyncClient client, GetDomainNamesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetDomainNamesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetDomainNamesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DomainName> items() {
        Function<GetDomainNamesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetDomainNamesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetDomainNamesResponseFetcher
    implements AsyncPageFetcher<GetDomainNamesResponse> {
        private GetDomainNamesResponseFetcher() {
        }

        public boolean hasNextPage(GetDomainNamesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public CompletableFuture<GetDomainNamesResponse> nextPage(GetDomainNamesResponse previousPage) {
            if (previousPage == null) {
                return GetDomainNamesPublisher.this.client.getDomainNames(GetDomainNamesPublisher.this.firstRequest);
            }
            return GetDomainNamesPublisher.this.client.getDomainNames((GetDomainNamesRequest)((Object)GetDomainNamesPublisher.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

