/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.ApiKey;
import software.amazon.awssdk.services.apigateway.model.ListOfApiKeyCopier;
import software.amazon.awssdk.services.apigateway.model.ListOfStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApiKeysResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, GetApiKeysResponse> {
    private static final SdkField<List<String>> WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetApiKeysResponse.getter(GetApiKeysResponse::warnings)).setter(GetApiKeysResponse.setter(Builder::warnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warnings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetApiKeysResponse.getter(GetApiKeysResponse::position)).setter(GetApiKeysResponse.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()}).build();
    private static final SdkField<List<ApiKey>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetApiKeysResponse.getter(GetApiKeysResponse::items)).setter(GetApiKeysResponse.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("item").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApiKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WARNINGS_FIELD, POSITION_FIELD, ITEMS_FIELD));
    private final List<String> warnings;
    private final String position;
    private final List<ApiKey> items;

    private GetApiKeysResponse(BuilderImpl builder) {
        super(builder);
        this.warnings = builder.warnings;
        this.position = builder.position;
        this.items = builder.items;
    }

    public List<String> warnings() {
        return this.warnings;
    }

    public String position() {
        return this.position;
    }

    public List<ApiKey> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.warnings());
        hashCode = 31 * hashCode + Objects.hashCode(this.position());
        hashCode = 31 * hashCode + Objects.hashCode(this.items());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApiKeysResponse)) {
            return false;
        }
        GetApiKeysResponse other = (GetApiKeysResponse)((Object)obj);
        return Objects.equals(this.warnings(), other.warnings()) && Objects.equals(this.position(), other.position()) && Objects.equals(this.items(), other.items());
    }

    public String toString() {
        return ToString.builder((String)"GetApiKeysResponse").add("Warnings", this.warnings()).add("Position", (Object)this.position()).add("Items", this.items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "warnings": {
                return Optional.ofNullable(clazz.cast(this.warnings()));
            }
            case "position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApiKeysResponse, T> g) {
        return obj -> g.apply((GetApiKeysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private List<String> warnings = DefaultSdkAutoConstructList.getInstance();
        private String position;
        private List<ApiKey> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetApiKeysResponse model) {
            super(model);
            this.warnings(model.warnings);
            this.position(model.position);
            this.items(model.items);
        }

        public final Collection<String> getWarnings() {
            return this.warnings;
        }

        @Override
        public final Builder warnings(Collection<String> warnings) {
            this.warnings = ListOfStringCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(String ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        public final void setWarnings(Collection<String> warnings) {
            this.warnings = ListOfStringCopier.copy(warnings);
        }

        public final String getPosition() {
            return this.position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        public final Collection<ApiKey.Builder> getItems() {
            return this.items != null ? (Collection)this.items.stream().map(ApiKey::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<ApiKey> items) {
            this.items = ListOfApiKeyCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(ApiKey ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<ApiKey.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (ApiKey)((ApiKey.Builder)ApiKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<ApiKey.BuilderImpl> items) {
            this.items = ListOfApiKeyCopier.copyFromBuilder(items);
        }

        @Override
        public GetApiKeysResponse build() {
            return new GetApiKeysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetApiKeysResponse> {
        public Builder warnings(Collection<String> var1);

        public Builder warnings(String ... var1);

        public Builder position(String var1);

        public Builder items(Collection<ApiKey> var1);

        public Builder items(ApiKey ... var1);

        public Builder items(Consumer<ApiKey.Builder> ... var1);
    }
}

