/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DocumentationPartType {
    API("API"),
    AUTHORIZER("AUTHORIZER"),
    MODEL("MODEL"),
    RESOURCE("RESOURCE"),
    METHOD("METHOD"),
    PATH_PARAMETER("PATH_PARAMETER"),
    QUERY_PARAMETER("QUERY_PARAMETER"),
    REQUEST_HEADER("REQUEST_HEADER"),
    REQUEST_BODY("REQUEST_BODY"),
    RESPONSE("RESPONSE"),
    RESPONSE_HEADER("RESPONSE_HEADER"),
    RESPONSE_BODY("RESPONSE_BODY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DocumentationPartType> VALUE_MAP;
    private final String value;

    private DocumentationPartType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentationPartType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DocumentationPartType> knownValues() {
        EnumSet<DocumentationPartType> knownValues = EnumSet.allOf(DocumentationPartType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DocumentationPartType.class, DocumentationPartType::toString);
    }
}

