/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.GatewayResponseType;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutGatewayResponseRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, PutGatewayResponseRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("restApiId").getter(PutGatewayResponseRequest.getter(PutGatewayResponseRequest::restApiId)).setter(PutGatewayResponseRequest.setter(Builder::restApiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()}).build();
    private static final SdkField<String> RESPONSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("responseType").getter(PutGatewayResponseRequest.getter(PutGatewayResponseRequest::responseTypeAsString)).setter(PutGatewayResponseRequest.setter(Builder::responseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("response_type").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusCode").getter(PutGatewayResponseRequest.getter(PutGatewayResponseRequest::statusCode)).setter(PutGatewayResponseRequest.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()}).build();
    private static final SdkField<Map<String, String>> RESPONSE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("responseParameters").getter(PutGatewayResponseRequest.getter(PutGatewayResponseRequest::responseParameters)).setter(PutGatewayResponseRequest.setter(Builder::responseParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> RESPONSE_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("responseTemplates").getter(PutGatewayResponseRequest.getter(PutGatewayResponseRequest::responseTemplates)).setter(PutGatewayResponseRequest.setter(Builder::responseTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseTemplates").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD, RESPONSE_TYPE_FIELD, STATUS_CODE_FIELD, RESPONSE_PARAMETERS_FIELD, RESPONSE_TEMPLATES_FIELD));
    private final String restApiId;
    private final String responseType;
    private final String statusCodeValue;
    private final Map<String, String> responseParameters;
    private final Map<String, String> responseTemplates;

    private PutGatewayResponseRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.responseType = builder.responseType;
        this.statusCodeValue = builder.statusCodeValue;
        this.responseParameters = builder.responseParameters;
        this.responseTemplates = builder.responseTemplates;
    }

    public final String restApiId() {
        return this.restApiId;
    }

    public final GatewayResponseType responseType() {
        return GatewayResponseType.fromValue(this.responseType);
    }

    public final String responseTypeAsString() {
        return this.responseType;
    }

    public final String statusCode() {
        return this.statusCodeValue;
    }

    public final boolean hasResponseParameters() {
        return this.responseParameters != null && !(this.responseParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> responseParameters() {
        return this.responseParameters;
    }

    public final boolean hasResponseTemplates() {
        return this.responseTemplates != null && !(this.responseTemplates instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> responseTemplates() {
        return this.responseTemplates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseParameters() ? this.responseParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseTemplates() ? this.responseTemplates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutGatewayResponseRequest)) {
            return false;
        }
        PutGatewayResponseRequest other = (PutGatewayResponseRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.responseTypeAsString(), other.responseTypeAsString()) && Objects.equals(this.statusCode(), other.statusCode()) && this.hasResponseParameters() == other.hasResponseParameters() && Objects.equals(this.responseParameters(), other.responseParameters()) && this.hasResponseTemplates() == other.hasResponseTemplates() && Objects.equals(this.responseTemplates(), other.responseTemplates());
    }

    public final String toString() {
        return ToString.builder((String)"PutGatewayResponseRequest").add("RestApiId", (Object)this.restApiId()).add("ResponseType", (Object)this.responseTypeAsString()).add("StatusCode", (Object)this.statusCode()).add("ResponseParameters", this.hasResponseParameters() ? this.responseParameters() : null).add("ResponseTemplates", this.hasResponseTemplates() ? this.responseTemplates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "responseType": {
                return Optional.ofNullable(clazz.cast(this.responseTypeAsString()));
            }
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "responseParameters": {
                return Optional.ofNullable(clazz.cast(this.responseParameters()));
            }
            case "responseTemplates": {
                return Optional.ofNullable(clazz.cast(this.responseTemplates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutGatewayResponseRequest, T> g) {
        return obj -> g.apply((PutGatewayResponseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String responseType;
        private String statusCodeValue;
        private Map<String, String> responseParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> responseTemplates = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutGatewayResponseRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.responseType(model.responseType);
            this.statusCode(model.statusCodeValue);
            this.responseParameters(model.responseParameters);
            this.responseTemplates(model.responseTemplates);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        @Transient
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getResponseType() {
            return this.responseType;
        }

        public final void setResponseType(String responseType) {
            this.responseType = responseType;
        }

        @Override
        @Transient
        public final Builder responseType(String responseType) {
            this.responseType = responseType;
            return this;
        }

        @Override
        @Transient
        public final Builder responseType(GatewayResponseType responseType) {
            this.responseType(responseType == null ? null : responseType.toString());
            return this;
        }

        public final String getStatusCode() {
            return this.statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        @Transient
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final Map<String, String> getResponseParameters() {
            if (this.responseParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.responseParameters;
        }

        public final void setResponseParameters(Map<String, String> responseParameters) {
            this.responseParameters = MapOfStringToStringCopier.copy(responseParameters);
        }

        @Override
        @Transient
        public final Builder responseParameters(Map<String, String> responseParameters) {
            this.responseParameters = MapOfStringToStringCopier.copy(responseParameters);
            return this;
        }

        public final Map<String, String> getResponseTemplates() {
            if (this.responseTemplates instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.responseTemplates;
        }

        public final void setResponseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = MapOfStringToStringCopier.copy(responseTemplates);
        }

        @Override
        @Transient
        public final Builder responseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = MapOfStringToStringCopier.copy(responseTemplates);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutGatewayResponseRequest build() {
            return new PutGatewayResponseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutGatewayResponseRequest> {
        public Builder restApiId(String var1);

        public Builder responseType(String var1);

        public Builder responseType(GatewayResponseType var1);

        public Builder statusCode(String var1);

        public Builder responseParameters(Map<String, String> var1);

        public Builder responseTemplates(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

