/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.MapOfApiStageThrottleSettingsCopier;
import software.amazon.awssdk.services.apigateway.model.ThrottleSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApiStage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApiStage> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiId").getter(ApiStage.getter(ApiStage::apiId)).setter(ApiStage.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiId").build()}).build();
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stage").getter(ApiStage.getter(ApiStage::stage)).setter(ApiStage.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()}).build();
    private static final SdkField<Map<String, ThrottleSettings>> THROTTLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("throttle").getter(ApiStage.getter(ApiStage::throttle)).setter(ApiStage.setter(Builder::throttle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throttle").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThrottleSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, STAGE_FIELD, THROTTLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String apiId;
    private final String stage;
    private final Map<String, ThrottleSettings> throttle;

    private ApiStage(BuilderImpl builder) {
        this.apiId = builder.apiId;
        this.stage = builder.stage;
        this.throttle = builder.throttle;
    }

    public final String apiId() {
        return this.apiId;
    }

    public final String stage() {
        return this.stage;
    }

    public final boolean hasThrottle() {
        return this.throttle != null && !(this.throttle instanceof SdkAutoConstructMap);
    }

    public final Map<String, ThrottleSettings> throttle() {
        return this.throttle;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThrottle() ? this.throttle() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiStage)) {
            return false;
        }
        ApiStage other = (ApiStage)obj;
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.stage(), other.stage()) && this.hasThrottle() == other.hasThrottle() && Objects.equals(this.throttle(), other.throttle());
    }

    public final String toString() {
        return ToString.builder((String)"ApiStage").add("ApiId", (Object)this.apiId()).add("Stage", (Object)this.stage()).add("Throttle", this.hasThrottle() ? this.throttle() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "stage": {
                return Optional.ofNullable(clazz.cast(this.stage()));
            }
            case "throttle": {
                return Optional.ofNullable(clazz.cast(this.throttle()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApiStage, T> g) {
        return obj -> g.apply((ApiStage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String apiId;
        private String stage;
        private Map<String, ThrottleSettings> throttle = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApiStage model) {
            this.apiId(model.apiId);
            this.stage(model.stage);
            this.throttle(model.throttle);
        }

        public final String getApiId() {
            return this.apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        @Transient
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getStage() {
            return this.stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        @Transient
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        public final Map<String, ThrottleSettings.Builder> getThrottle() {
            Map<String, ThrottleSettings.Builder> result = MapOfApiStageThrottleSettingsCopier.copyToBuilder(this.throttle);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setThrottle(Map<String, ThrottleSettings.BuilderImpl> throttle) {
            this.throttle = MapOfApiStageThrottleSettingsCopier.copyFromBuilder(throttle);
        }

        @Override
        @Transient
        public final Builder throttle(Map<String, ThrottleSettings> throttle) {
            this.throttle = MapOfApiStageThrottleSettingsCopier.copy(throttle);
            return this;
        }

        public ApiStage build() {
            return new ApiStage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApiStage> {
        public Builder apiId(String var1);

        public Builder stage(String var1);

        public Builder throttle(Map<String, ThrottleSettings> var1);
    }
}

