/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.ListOfStageCopier;
import software.amazon.awssdk.services.apigateway.model.Stage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStagesResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, GetStagesResponse> {
    private static final SdkField<List<Stage>> ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("item").getter(GetStagesResponse.getter(GetStagesResponse::item)).setter(GetStagesResponse.setter(Builder::item)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("item").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Stage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_FIELD));
    private final List<Stage> item;

    private GetStagesResponse(BuilderImpl builder) {
        super(builder);
        this.item = builder.item;
    }

    public final boolean hasItem() {
        return this.item != null && !(this.item instanceof SdkAutoConstructList);
    }

    public final List<Stage> item() {
        return this.item;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItem() ? this.item() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStagesResponse)) {
            return false;
        }
        GetStagesResponse other = (GetStagesResponse)((Object)obj);
        return this.hasItem() == other.hasItem() && Objects.equals(this.item(), other.item());
    }

    public final String toString() {
        return ToString.builder((String)"GetStagesResponse").add("Item", this.hasItem() ? this.item() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "item": {
                return Optional.ofNullable(clazz.cast(this.item()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStagesResponse, T> g) {
        return obj -> g.apply((GetStagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private List<Stage> item = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetStagesResponse model) {
            super(model);
            this.item(model.item);
        }

        public final Collection<Stage.Builder> getItem() {
            if (this.item instanceof SdkAutoConstructList) {
                return null;
            }
            return this.item != null ? (Collection)this.item.stream().map(Stage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder item(Collection<Stage> item) {
            this.item = ListOfStageCopier.copy(item);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(Stage ... item) {
            this.item(Arrays.asList(item));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(Consumer<Stage.Builder> ... item) {
            this.item(Stream.of(item).map(c -> (Stage)((Stage.Builder)Stage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItem(Collection<Stage.BuilderImpl> item) {
            this.item = ListOfStageCopier.copyFromBuilder(item);
        }

        @Override
        public GetStagesResponse build() {
            return new GetStagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetStagesResponse> {
        public Builder item(Collection<Stage> var1);

        public Builder item(Stage ... var1);

        public Builder item(Consumer<Stage.Builder> ... var1);
    }
}

