/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MethodSnapshot
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MethodSnapshot> {
    private static final SdkField<String> AUTHORIZATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizationType").getter(MethodSnapshot.getter(MethodSnapshot::authorizationType)).setter(MethodSnapshot.setter(Builder::authorizationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationType").build()}).build();
    private static final SdkField<Boolean> API_KEY_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("apiKeyRequired").getter(MethodSnapshot.getter(MethodSnapshot::apiKeyRequired)).setter(MethodSnapshot.setter(Builder::apiKeyRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeyRequired").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_TYPE_FIELD, API_KEY_REQUIRED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String authorizationType;
    private final Boolean apiKeyRequired;

    private MethodSnapshot(BuilderImpl builder) {
        this.authorizationType = builder.authorizationType;
        this.apiKeyRequired = builder.apiKeyRequired;
    }

    public String authorizationType() {
        return this.authorizationType;
    }

    public Boolean apiKeyRequired() {
        return this.apiKeyRequired;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeyRequired());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MethodSnapshot)) {
            return false;
        }
        MethodSnapshot other = (MethodSnapshot)obj;
        return Objects.equals(this.authorizationType(), other.authorizationType()) && Objects.equals(this.apiKeyRequired(), other.apiKeyRequired());
    }

    public String toString() {
        return ToString.builder((String)"MethodSnapshot").add("AuthorizationType", (Object)this.authorizationType()).add("ApiKeyRequired", (Object)this.apiKeyRequired()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizationType": {
                return Optional.ofNullable(clazz.cast(this.authorizationType()));
            }
            case "apiKeyRequired": {
                return Optional.ofNullable(clazz.cast(this.apiKeyRequired()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MethodSnapshot, T> g) {
        return obj -> g.apply((MethodSnapshot)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authorizationType;
        private Boolean apiKeyRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(MethodSnapshot model) {
            this.authorizationType(model.authorizationType);
            this.apiKeyRequired(model.apiKeyRequired);
        }

        public final String getAuthorizationType() {
            return this.authorizationType;
        }

        @Override
        public final Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        public final void setAuthorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
        }

        public final Boolean getApiKeyRequired() {
            return this.apiKeyRequired;
        }

        @Override
        public final Builder apiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        public final void setApiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
        }

        public MethodSnapshot build() {
            return new MethodSnapshot(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MethodSnapshot> {
        public Builder authorizationType(String var1);

        public Builder apiKeyRequired(Boolean var1);
    }
}

