/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.AuthorizerType;
import software.amazon.awssdk.services.apigateway.model.ListOfARNsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAuthorizerResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, UpdateAuthorizerResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateAuthorizerResponse.getter(UpdateAuthorizerResponse::id)).setter(UpdateAuthorizerResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateAuthorizerResponse.getter(UpdateAuthorizerResponse::name)).setter(UpdateAuthorizerResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(UpdateAuthorizerResponse.getter(UpdateAuthorizerResponse::typeAsString)).setter(UpdateAuthorizerResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<List<String>> PROVIDER_AR_NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("providerARNs").getter(UpdateAuthorizerResponse.getter(UpdateAuthorizerResponse::providerARNs)).setter(UpdateAuthorizerResponse.setter(Builder::providerARNs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerARNs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authType").getter(UpdateAuthorizerResponse.getter(UpdateAuthorizerResponse::authType)).setter(UpdateAuthorizerResponse.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()}).build();
    private static final SdkField<String> AUTHORIZER_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizerUri").getter(UpdateAuthorizerResponse.getter(UpdateAuthorizerResponse::authorizerUri)).setter(UpdateAuthorizerResponse.setter(Builder::authorizerUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerUri").build()}).build();
    private static final SdkField<String> AUTHORIZER_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizerCredentials").getter(UpdateAuthorizerResponse.getter(UpdateAuthorizerResponse::authorizerCredentials)).setter(UpdateAuthorizerResponse.setter(Builder::authorizerCredentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerCredentials").build()}).build();
    private static final SdkField<String> IDENTITY_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identitySource").getter(UpdateAuthorizerResponse.getter(UpdateAuthorizerResponse::identitySource)).setter(UpdateAuthorizerResponse.setter(Builder::identitySource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identitySource").build()}).build();
    private static final SdkField<String> IDENTITY_VALIDATION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identityValidationExpression").getter(UpdateAuthorizerResponse.getter(UpdateAuthorizerResponse::identityValidationExpression)).setter(UpdateAuthorizerResponse.setter(Builder::identityValidationExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityValidationExpression").build()}).build();
    private static final SdkField<Integer> AUTHORIZER_RESULT_TTL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("authorizerResultTtlInSeconds").getter(UpdateAuthorizerResponse.getter(UpdateAuthorizerResponse::authorizerResultTtlInSeconds)).setter(UpdateAuthorizerResponse.setter(Builder::authorizerResultTtlInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerResultTtlInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, TYPE_FIELD, PROVIDER_AR_NS_FIELD, AUTH_TYPE_FIELD, AUTHORIZER_URI_FIELD, AUTHORIZER_CREDENTIALS_FIELD, IDENTITY_SOURCE_FIELD, IDENTITY_VALIDATION_EXPRESSION_FIELD, AUTHORIZER_RESULT_TTL_IN_SECONDS_FIELD));
    private final String id;
    private final String name;
    private final String type;
    private final List<String> providerARNs;
    private final String authType;
    private final String authorizerUri;
    private final String authorizerCredentials;
    private final String identitySource;
    private final String identityValidationExpression;
    private final Integer authorizerResultTtlInSeconds;

    private UpdateAuthorizerResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.type = builder.type;
        this.providerARNs = builder.providerARNs;
        this.authType = builder.authType;
        this.authorizerUri = builder.authorizerUri;
        this.authorizerCredentials = builder.authorizerCredentials;
        this.identitySource = builder.identitySource;
        this.identityValidationExpression = builder.identityValidationExpression;
        this.authorizerResultTtlInSeconds = builder.authorizerResultTtlInSeconds;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public AuthorizerType type() {
        return AuthorizerType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public boolean hasProviderARNs() {
        return this.providerARNs != null && !(this.providerARNs instanceof SdkAutoConstructList);
    }

    public List<String> providerARNs() {
        return this.providerARNs;
    }

    public String authType() {
        return this.authType;
    }

    public String authorizerUri() {
        return this.authorizerUri;
    }

    public String authorizerCredentials() {
        return this.authorizerCredentials;
    }

    public String identitySource() {
        return this.identitySource;
    }

    public String identityValidationExpression() {
        return this.identityValidationExpression;
    }

    public Integer authorizerResultTtlInSeconds() {
        return this.authorizerResultTtlInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProviderARNs() ? this.providerARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.authType());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.identitySource());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityValidationExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerResultTtlInSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAuthorizerResponse)) {
            return false;
        }
        UpdateAuthorizerResponse other = (UpdateAuthorizerResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasProviderARNs() == other.hasProviderARNs() && Objects.equals(this.providerARNs(), other.providerARNs()) && Objects.equals(this.authType(), other.authType()) && Objects.equals(this.authorizerUri(), other.authorizerUri()) && Objects.equals(this.authorizerCredentials(), other.authorizerCredentials()) && Objects.equals(this.identitySource(), other.identitySource()) && Objects.equals(this.identityValidationExpression(), other.identityValidationExpression()) && Objects.equals(this.authorizerResultTtlInSeconds(), other.authorizerResultTtlInSeconds());
    }

    public String toString() {
        return ToString.builder((String)"UpdateAuthorizerResponse").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("ProviderARNs", this.hasProviderARNs() ? this.providerARNs() : null).add("AuthType", (Object)this.authType()).add("AuthorizerUri", (Object)this.authorizerUri()).add("AuthorizerCredentials", (Object)this.authorizerCredentials()).add("IdentitySource", (Object)this.identitySource()).add("IdentityValidationExpression", (Object)this.identityValidationExpression()).add("AuthorizerResultTtlInSeconds", (Object)this.authorizerResultTtlInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "providerARNs": {
                return Optional.ofNullable(clazz.cast(this.providerARNs()));
            }
            case "authType": {
                return Optional.ofNullable(clazz.cast(this.authType()));
            }
            case "authorizerUri": {
                return Optional.ofNullable(clazz.cast(this.authorizerUri()));
            }
            case "authorizerCredentials": {
                return Optional.ofNullable(clazz.cast(this.authorizerCredentials()));
            }
            case "identitySource": {
                return Optional.ofNullable(clazz.cast(this.identitySource()));
            }
            case "identityValidationExpression": {
                return Optional.ofNullable(clazz.cast(this.identityValidationExpression()));
            }
            case "authorizerResultTtlInSeconds": {
                return Optional.ofNullable(clazz.cast(this.authorizerResultTtlInSeconds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAuthorizerResponse, T> g) {
        return obj -> g.apply((UpdateAuthorizerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String type;
        private List<String> providerARNs = DefaultSdkAutoConstructList.getInstance();
        private String authType;
        private String authorizerUri;
        private String authorizerCredentials;
        private String identitySource;
        private String identityValidationExpression;
        private Integer authorizerResultTtlInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAuthorizerResponse model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.type(model.type);
            this.providerARNs(model.providerARNs);
            this.authType(model.authType);
            this.authorizerUri(model.authorizerUri);
            this.authorizerCredentials(model.authorizerCredentials);
            this.identitySource(model.identitySource);
            this.identityValidationExpression(model.identityValidationExpression);
            this.authorizerResultTtlInSeconds(model.authorizerResultTtlInSeconds);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AuthorizerType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<String> getProviderARNs() {
            if (this.providerARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.providerARNs;
        }

        @Override
        public final Builder providerARNs(Collection<String> providerARNs) {
            this.providerARNs = ListOfARNsCopier.copy(providerARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerARNs(String ... providerARNs) {
            this.providerARNs(Arrays.asList(providerARNs));
            return this;
        }

        public final void setProviderARNs(Collection<String> providerARNs) {
            this.providerARNs = ListOfARNsCopier.copy(providerARNs);
        }

        public final String getAuthType() {
            return this.authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        public final String getAuthorizerUri() {
            return this.authorizerUri;
        }

        @Override
        public final Builder authorizerUri(String authorizerUri) {
            this.authorizerUri = authorizerUri;
            return this;
        }

        public final void setAuthorizerUri(String authorizerUri) {
            this.authorizerUri = authorizerUri;
        }

        public final String getAuthorizerCredentials() {
            return this.authorizerCredentials;
        }

        @Override
        public final Builder authorizerCredentials(String authorizerCredentials) {
            this.authorizerCredentials = authorizerCredentials;
            return this;
        }

        public final void setAuthorizerCredentials(String authorizerCredentials) {
            this.authorizerCredentials = authorizerCredentials;
        }

        public final String getIdentitySource() {
            return this.identitySource;
        }

        @Override
        public final Builder identitySource(String identitySource) {
            this.identitySource = identitySource;
            return this;
        }

        public final void setIdentitySource(String identitySource) {
            this.identitySource = identitySource;
        }

        public final String getIdentityValidationExpression() {
            return this.identityValidationExpression;
        }

        @Override
        public final Builder identityValidationExpression(String identityValidationExpression) {
            this.identityValidationExpression = identityValidationExpression;
            return this;
        }

        public final void setIdentityValidationExpression(String identityValidationExpression) {
            this.identityValidationExpression = identityValidationExpression;
        }

        public final Integer getAuthorizerResultTtlInSeconds() {
            return this.authorizerResultTtlInSeconds;
        }

        @Override
        public final Builder authorizerResultTtlInSeconds(Integer authorizerResultTtlInSeconds) {
            this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds;
            return this;
        }

        public final void setAuthorizerResultTtlInSeconds(Integer authorizerResultTtlInSeconds) {
            this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds;
        }

        @Override
        public UpdateAuthorizerResponse build() {
            return new UpdateAuthorizerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAuthorizerResponse> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(AuthorizerType var1);

        public Builder providerARNs(Collection<String> var1);

        public Builder providerARNs(String ... var1);

        public Builder authType(String var1);

        public Builder authorizerUri(String var1);

        public Builder authorizerCredentials(String var1);

        public Builder identitySource(String var1);

        public Builder identityValidationExpression(String var1);

        public Builder authorizerResultTtlInSeconds(Integer var1);
    }
}

