/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.ListOfStageKeysCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.services.apigateway.model.StageKey;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApiKeyRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, CreateApiKeyRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateApiKeyRequest.getter(CreateApiKeyRequest::name)).setter(CreateApiKeyRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateApiKeyRequest.getter(CreateApiKeyRequest::description)).setter(CreateApiKeyRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(CreateApiKeyRequest.getter(CreateApiKeyRequest::enabled)).setter(CreateApiKeyRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<Boolean> GENERATE_DISTINCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("generateDistinctId").getter(CreateApiKeyRequest.getter(CreateApiKeyRequest::generateDistinctId)).setter(CreateApiKeyRequest.setter(Builder::generateDistinctId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generateDistinctId").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("value").getter(CreateApiKeyRequest.getter(CreateApiKeyRequest::value)).setter(CreateApiKeyRequest.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<List<StageKey>> STAGE_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stageKeys").getter(CreateApiKeyRequest.getter(CreateApiKeyRequest::stageKeys)).setter(CreateApiKeyRequest.setter(Builder::stageKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StageKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CUSTOMER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerId").getter(CreateApiKeyRequest.getter(CreateApiKeyRequest::customerId)).setter(CreateApiKeyRequest.setter(Builder::customerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateApiKeyRequest.getter(CreateApiKeyRequest::tags)).setter(CreateApiKeyRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, ENABLED_FIELD, GENERATE_DISTINCT_ID_FIELD, VALUE_FIELD, STAGE_KEYS_FIELD, CUSTOMER_ID_FIELD, TAGS_FIELD));
    private final String name;
    private final String description;
    private final Boolean enabled;
    private final Boolean generateDistinctId;
    private final String value;
    private final List<StageKey> stageKeys;
    private final String customerId;
    private final Map<String, String> tags;

    private CreateApiKeyRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.enabled = builder.enabled;
        this.generateDistinctId = builder.generateDistinctId;
        this.value = builder.value;
        this.stageKeys = builder.stageKeys;
        this.customerId = builder.customerId;
        this.tags = builder.tags;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Boolean generateDistinctId() {
        return this.generateDistinctId;
    }

    public String value() {
        return this.value;
    }

    public boolean hasStageKeys() {
        return this.stageKeys != null && !(this.stageKeys instanceof SdkAutoConstructList);
    }

    public List<StageKey> stageKeys() {
        return this.stageKeys;
    }

    public String customerId() {
        return this.customerId;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.generateDistinctId());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageKeys());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApiKeyRequest)) {
            return false;
        }
        CreateApiKeyRequest other = (CreateApiKeyRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.generateDistinctId(), other.generateDistinctId()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.stageKeys(), other.stageKeys()) && Objects.equals(this.customerId(), other.customerId()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateApiKeyRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Enabled", (Object)this.enabled()).add("GenerateDistinctId", (Object)this.generateDistinctId()).add("Value", (Object)this.value()).add("StageKeys", this.stageKeys()).add("CustomerId", (Object)this.customerId()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "generateDistinctId": {
                return Optional.ofNullable(clazz.cast(this.generateDistinctId()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "stageKeys": {
                return Optional.ofNullable(clazz.cast(this.stageKeys()));
            }
            case "customerId": {
                return Optional.ofNullable(clazz.cast(this.customerId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApiKeyRequest, T> g) {
        return obj -> g.apply((CreateApiKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private Boolean enabled;
        private Boolean generateDistinctId;
        private String value;
        private List<StageKey> stageKeys = DefaultSdkAutoConstructList.getInstance();
        private String customerId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApiKeyRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.enabled(model.enabled);
            this.generateDistinctId(model.generateDistinctId);
            this.value(model.value);
            this.stageKeys(model.stageKeys);
            this.customerId(model.customerId);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Boolean getGenerateDistinctId() {
            return this.generateDistinctId;
        }

        @Override
        public final Builder generateDistinctId(Boolean generateDistinctId) {
            this.generateDistinctId = generateDistinctId;
            return this;
        }

        public final void setGenerateDistinctId(Boolean generateDistinctId) {
            this.generateDistinctId = generateDistinctId;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Collection<StageKey.Builder> getStageKeys() {
            return this.stageKeys != null ? (Collection)this.stageKeys.stream().map(StageKey::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stageKeys(Collection<StageKey> stageKeys) {
            this.stageKeys = ListOfStageKeysCopier.copy(stageKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stageKeys(StageKey ... stageKeys) {
            this.stageKeys(Arrays.asList(stageKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stageKeys(Consumer<StageKey.Builder> ... stageKeys) {
            this.stageKeys(Stream.of(stageKeys).map(c -> (StageKey)((StageKey.Builder)StageKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStageKeys(Collection<StageKey.BuilderImpl> stageKeys) {
            this.stageKeys = ListOfStageKeysCopier.copyFromBuilder(stageKeys);
        }

        public final String getCustomerId() {
            return this.customerId;
        }

        @Override
        public final Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public final void setCustomerId(String customerId) {
            this.customerId = customerId;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApiKeyRequest build() {
            return new CreateApiKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApiKeyRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder enabled(Boolean var1);

        public Builder generateDistinctId(Boolean var1);

        public Builder value(String var1);

        public Builder stageKeys(Collection<StageKey> var1);

        public Builder stageKeys(StageKey ... var1);

        public Builder stageKeys(Consumer<StageKey.Builder> ... var1);

        public Builder customerId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

