/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.ContentHandlingStrategy;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutIntegrationResponseResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, PutIntegrationResponseResponse> {
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusCode").getter(PutIntegrationResponseResponse.getter(PutIntegrationResponseResponse::statusCode)).setter(PutIntegrationResponseResponse.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()}).build();
    private static final SdkField<String> SELECTION_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("selectionPattern").getter(PutIntegrationResponseResponse.getter(PutIntegrationResponseResponse::selectionPattern)).setter(PutIntegrationResponseResponse.setter(Builder::selectionPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectionPattern").build()}).build();
    private static final SdkField<Map<String, String>> RESPONSE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("responseParameters").getter(PutIntegrationResponseResponse.getter(PutIntegrationResponseResponse::responseParameters)).setter(PutIntegrationResponseResponse.setter(Builder::responseParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> RESPONSE_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("responseTemplates").getter(PutIntegrationResponseResponse.getter(PutIntegrationResponseResponse::responseTemplates)).setter(PutIntegrationResponseResponse.setter(Builder::responseTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseTemplates").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CONTENT_HANDLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentHandling").getter(PutIntegrationResponseResponse.getter(PutIntegrationResponseResponse::contentHandlingAsString)).setter(PutIntegrationResponseResponse.setter(Builder::contentHandling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentHandling").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODE_FIELD, SELECTION_PATTERN_FIELD, RESPONSE_PARAMETERS_FIELD, RESPONSE_TEMPLATES_FIELD, CONTENT_HANDLING_FIELD));
    private final String statusCodeValue;
    private final String selectionPattern;
    private final Map<String, String> responseParameters;
    private final Map<String, String> responseTemplates;
    private final String contentHandling;

    private PutIntegrationResponseResponse(BuilderImpl builder) {
        super(builder);
        this.statusCodeValue = builder.statusCodeValue;
        this.selectionPattern = builder.selectionPattern;
        this.responseParameters = builder.responseParameters;
        this.responseTemplates = builder.responseTemplates;
        this.contentHandling = builder.contentHandling;
    }

    public String statusCode() {
        return this.statusCodeValue;
    }

    public String selectionPattern() {
        return this.selectionPattern;
    }

    public boolean hasResponseParameters() {
        return this.responseParameters != null && !(this.responseParameters instanceof SdkAutoConstructMap);
    }

    public Map<String, String> responseParameters() {
        return this.responseParameters;
    }

    public boolean hasResponseTemplates() {
        return this.responseTemplates != null && !(this.responseTemplates instanceof SdkAutoConstructMap);
    }

    public Map<String, String> responseTemplates() {
        return this.responseTemplates;
    }

    public ContentHandlingStrategy contentHandling() {
        return ContentHandlingStrategy.fromValue(this.contentHandling);
    }

    public String contentHandlingAsString() {
        return this.contentHandling;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseParameters() ? this.responseParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseTemplates() ? this.responseTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contentHandlingAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIntegrationResponseResponse)) {
            return false;
        }
        PutIntegrationResponseResponse other = (PutIntegrationResponseResponse)((Object)obj);
        return Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.selectionPattern(), other.selectionPattern()) && this.hasResponseParameters() == other.hasResponseParameters() && Objects.equals(this.responseParameters(), other.responseParameters()) && this.hasResponseTemplates() == other.hasResponseTemplates() && Objects.equals(this.responseTemplates(), other.responseTemplates()) && Objects.equals(this.contentHandlingAsString(), other.contentHandlingAsString());
    }

    public String toString() {
        return ToString.builder((String)"PutIntegrationResponseResponse").add("StatusCode", (Object)this.statusCode()).add("SelectionPattern", (Object)this.selectionPattern()).add("ResponseParameters", this.hasResponseParameters() ? this.responseParameters() : null).add("ResponseTemplates", this.hasResponseTemplates() ? this.responseTemplates() : null).add("ContentHandling", (Object)this.contentHandlingAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "selectionPattern": {
                return Optional.ofNullable(clazz.cast(this.selectionPattern()));
            }
            case "responseParameters": {
                return Optional.ofNullable(clazz.cast(this.responseParameters()));
            }
            case "responseTemplates": {
                return Optional.ofNullable(clazz.cast(this.responseTemplates()));
            }
            case "contentHandling": {
                return Optional.ofNullable(clazz.cast(this.contentHandlingAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutIntegrationResponseResponse, T> g) {
        return obj -> g.apply((PutIntegrationResponseResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String statusCodeValue;
        private String selectionPattern;
        private Map<String, String> responseParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> responseTemplates = DefaultSdkAutoConstructMap.getInstance();
        private String contentHandling;

        private BuilderImpl() {
        }

        private BuilderImpl(PutIntegrationResponseResponse model) {
            super(model);
            this.statusCode(model.statusCodeValue);
            this.selectionPattern(model.selectionPattern);
            this.responseParameters(model.responseParameters);
            this.responseTemplates(model.responseTemplates);
            this.contentHandling(model.contentHandling);
        }

        public final String getStatusCode() {
            return this.statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        public final String getSelectionPattern() {
            return this.selectionPattern;
        }

        @Override
        public final Builder selectionPattern(String selectionPattern) {
            this.selectionPattern = selectionPattern;
            return this;
        }

        public final void setSelectionPattern(String selectionPattern) {
            this.selectionPattern = selectionPattern;
        }

        public final Map<String, String> getResponseParameters() {
            if (this.responseParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.responseParameters;
        }

        @Override
        public final Builder responseParameters(Map<String, String> responseParameters) {
            this.responseParameters = MapOfStringToStringCopier.copy(responseParameters);
            return this;
        }

        public final void setResponseParameters(Map<String, String> responseParameters) {
            this.responseParameters = MapOfStringToStringCopier.copy(responseParameters);
        }

        public final Map<String, String> getResponseTemplates() {
            if (this.responseTemplates instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.responseTemplates;
        }

        @Override
        public final Builder responseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = MapOfStringToStringCopier.copy(responseTemplates);
            return this;
        }

        public final void setResponseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = MapOfStringToStringCopier.copy(responseTemplates);
        }

        public final String getContentHandling() {
            return this.contentHandling;
        }

        @Override
        public final Builder contentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        @Override
        public final Builder contentHandling(ContentHandlingStrategy contentHandling) {
            this.contentHandling(contentHandling == null ? null : contentHandling.toString());
            return this;
        }

        public final void setContentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
        }

        @Override
        public PutIntegrationResponseResponse build() {
            return new PutIntegrationResponseResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutIntegrationResponseResponse> {
        public Builder statusCode(String var1);

        public Builder selectionPattern(String var1);

        public Builder responseParameters(Map<String, String> var1);

        public Builder responseTemplates(Map<String, String> var1);

        public Builder contentHandling(String var1);

        public Builder contentHandling(ContentHandlingStrategy var1);
    }
}

