/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToListCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestInvokeAuthorizerResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, TestInvokeAuthorizerResponse> {
    private static final SdkField<Integer> CLIENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("clientStatus").getter(TestInvokeAuthorizerResponse.getter(TestInvokeAuthorizerResponse::clientStatus)).setter(TestInvokeAuthorizerResponse.setter(Builder::clientStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientStatus").build()}).build();
    private static final SdkField<String> LOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("log").getter(TestInvokeAuthorizerResponse.getter(TestInvokeAuthorizerResponse::log)).setter(TestInvokeAuthorizerResponse.setter(Builder::log)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("log").build()}).build();
    private static final SdkField<Long> LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("latency").getter(TestInvokeAuthorizerResponse.getter(TestInvokeAuthorizerResponse::latency)).setter(TestInvokeAuthorizerResponse.setter(Builder::latency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latency").build()}).build();
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalId").getter(TestInvokeAuthorizerResponse.getter(TestInvokeAuthorizerResponse::principalId)).setter(TestInvokeAuthorizerResponse.setter(Builder::principalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalId").build()}).build();
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policy").getter(TestInvokeAuthorizerResponse.getter(TestInvokeAuthorizerResponse::policy)).setter(TestInvokeAuthorizerResponse.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()}).build();
    private static final SdkField<Map<String, List<String>>> AUTHORIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("authorization").getter(TestInvokeAuthorizerResponse.getter(TestInvokeAuthorizerResponse::authorization)).setter(TestInvokeAuthorizerResponse.setter(Builder::authorization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorization").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CLAIMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("claims").getter(TestInvokeAuthorizerResponse.getter(TestInvokeAuthorizerResponse::claims)).setter(TestInvokeAuthorizerResponse.setter(Builder::claims)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("claims").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_STATUS_FIELD, LOG_FIELD, LATENCY_FIELD, PRINCIPAL_ID_FIELD, POLICY_FIELD, AUTHORIZATION_FIELD, CLAIMS_FIELD));
    private final Integer clientStatus;
    private final String log;
    private final Long latency;
    private final String principalId;
    private final String policy;
    private final Map<String, List<String>> authorization;
    private final Map<String, String> claims;

    private TestInvokeAuthorizerResponse(BuilderImpl builder) {
        super(builder);
        this.clientStatus = builder.clientStatus;
        this.log = builder.log;
        this.latency = builder.latency;
        this.principalId = builder.principalId;
        this.policy = builder.policy;
        this.authorization = builder.authorization;
        this.claims = builder.claims;
    }

    public Integer clientStatus() {
        return this.clientStatus;
    }

    public String log() {
        return this.log;
    }

    public Long latency() {
        return this.latency;
    }

    public String principalId() {
        return this.principalId;
    }

    public String policy() {
        return this.policy;
    }

    public boolean hasAuthorization() {
        return this.authorization != null && !(this.authorization instanceof SdkAutoConstructMap);
    }

    public Map<String, List<String>> authorization() {
        return this.authorization;
    }

    public boolean hasClaims() {
        return this.claims != null && !(this.claims instanceof SdkAutoConstructMap);
    }

    public Map<String, String> claims() {
        return this.claims;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.log());
        hashCode = 31 * hashCode + Objects.hashCode(this.latency());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorization());
        hashCode = 31 * hashCode + Objects.hashCode(this.claims());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestInvokeAuthorizerResponse)) {
            return false;
        }
        TestInvokeAuthorizerResponse other = (TestInvokeAuthorizerResponse)((Object)obj);
        return Objects.equals(this.clientStatus(), other.clientStatus()) && Objects.equals(this.log(), other.log()) && Objects.equals(this.latency(), other.latency()) && Objects.equals(this.principalId(), other.principalId()) && Objects.equals(this.policy(), other.policy()) && Objects.equals(this.authorization(), other.authorization()) && Objects.equals(this.claims(), other.claims());
    }

    public String toString() {
        return ToString.builder((String)"TestInvokeAuthorizerResponse").add("ClientStatus", (Object)this.clientStatus()).add("Log", (Object)this.log()).add("Latency", (Object)this.latency()).add("PrincipalId", (Object)this.principalId()).add("Policy", (Object)this.policy()).add("Authorization", this.authorization()).add("Claims", this.claims()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientStatus": {
                return Optional.ofNullable(clazz.cast(this.clientStatus()));
            }
            case "log": {
                return Optional.ofNullable(clazz.cast(this.log()));
            }
            case "latency": {
                return Optional.ofNullable(clazz.cast(this.latency()));
            }
            case "principalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
            case "policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "authorization": {
                return Optional.ofNullable(clazz.cast(this.authorization()));
            }
            case "claims": {
                return Optional.ofNullable(clazz.cast(this.claims()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestInvokeAuthorizerResponse, T> g) {
        return obj -> g.apply((TestInvokeAuthorizerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private Integer clientStatus;
        private String log;
        private Long latency;
        private String principalId;
        private String policy;
        private Map<String, List<String>> authorization = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> claims = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestInvokeAuthorizerResponse model) {
            super(model);
            this.clientStatus(model.clientStatus);
            this.log(model.log);
            this.latency(model.latency);
            this.principalId(model.principalId);
            this.policy(model.policy);
            this.authorization(model.authorization);
            this.claims(model.claims);
        }

        public final Integer getClientStatus() {
            return this.clientStatus;
        }

        @Override
        public final Builder clientStatus(Integer clientStatus) {
            this.clientStatus = clientStatus;
            return this;
        }

        public final void setClientStatus(Integer clientStatus) {
            this.clientStatus = clientStatus;
        }

        public final String getLog() {
            return this.log;
        }

        @Override
        public final Builder log(String log) {
            this.log = log;
            return this;
        }

        public final void setLog(String log) {
            this.log = log;
        }

        public final Long getLatency() {
            return this.latency;
        }

        @Override
        public final Builder latency(Long latency) {
            this.latency = latency;
            return this;
        }

        public final void setLatency(Long latency) {
            this.latency = latency;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public final String getPolicy() {
            return this.policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final Map<String, ? extends Collection<String>> getAuthorization() {
            return this.authorization;
        }

        @Override
        public final Builder authorization(Map<String, ? extends Collection<String>> authorization) {
            this.authorization = MapOfStringToListCopier.copy(authorization);
            return this;
        }

        public final void setAuthorization(Map<String, ? extends Collection<String>> authorization) {
            this.authorization = MapOfStringToListCopier.copy(authorization);
        }

        public final Map<String, String> getClaims() {
            return this.claims;
        }

        @Override
        public final Builder claims(Map<String, String> claims) {
            this.claims = MapOfStringToStringCopier.copy(claims);
            return this;
        }

        public final void setClaims(Map<String, String> claims) {
            this.claims = MapOfStringToStringCopier.copy(claims);
        }

        @Override
        public TestInvokeAuthorizerResponse build() {
            return new TestInvokeAuthorizerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestInvokeAuthorizerResponse> {
        public Builder clientStatus(Integer var1);

        public Builder log(String var1);

        public Builder latency(Long var1);

        public Builder principalId(String var1);

        public Builder policy(String var1);

        public Builder authorization(Map<String, ? extends Collection<String>> var1);

        public Builder claims(Map<String, String> var1);
    }
}

