/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ListOfStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MutualTlsAuthentication
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MutualTlsAuthentication> {
    private static final SdkField<String> TRUSTSTORE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MutualTlsAuthentication.getter(MutualTlsAuthentication::truststoreUri)).setter(MutualTlsAuthentication.setter(Builder::truststoreUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("truststoreUri").build()}).build();
    private static final SdkField<String> TRUSTSTORE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MutualTlsAuthentication.getter(MutualTlsAuthentication::truststoreVersion)).setter(MutualTlsAuthentication.setter(Builder::truststoreVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("truststoreVersion").build()}).build();
    private static final SdkField<List<String>> TRUSTSTORE_WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(MutualTlsAuthentication.getter(MutualTlsAuthentication::truststoreWarnings)).setter(MutualTlsAuthentication.setter(Builder::truststoreWarnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("truststoreWarnings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUSTSTORE_URI_FIELD, TRUSTSTORE_VERSION_FIELD, TRUSTSTORE_WARNINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String truststoreUri;
    private final String truststoreVersion;
    private final List<String> truststoreWarnings;

    private MutualTlsAuthentication(BuilderImpl builder) {
        this.truststoreUri = builder.truststoreUri;
        this.truststoreVersion = builder.truststoreVersion;
        this.truststoreWarnings = builder.truststoreWarnings;
    }

    public String truststoreUri() {
        return this.truststoreUri;
    }

    public String truststoreVersion() {
        return this.truststoreVersion;
    }

    public boolean hasTruststoreWarnings() {
        return this.truststoreWarnings != null && !(this.truststoreWarnings instanceof SdkAutoConstructList);
    }

    public List<String> truststoreWarnings() {
        return this.truststoreWarnings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.truststoreUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.truststoreVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.truststoreWarnings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MutualTlsAuthentication)) {
            return false;
        }
        MutualTlsAuthentication other = (MutualTlsAuthentication)obj;
        return Objects.equals(this.truststoreUri(), other.truststoreUri()) && Objects.equals(this.truststoreVersion(), other.truststoreVersion()) && Objects.equals(this.truststoreWarnings(), other.truststoreWarnings());
    }

    public String toString() {
        return ToString.builder((String)"MutualTlsAuthentication").add("TruststoreUri", (Object)this.truststoreUri()).add("TruststoreVersion", (Object)this.truststoreVersion()).add("TruststoreWarnings", this.truststoreWarnings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "truststoreUri": {
                return Optional.ofNullable(clazz.cast(this.truststoreUri()));
            }
            case "truststoreVersion": {
                return Optional.ofNullable(clazz.cast(this.truststoreVersion()));
            }
            case "truststoreWarnings": {
                return Optional.ofNullable(clazz.cast(this.truststoreWarnings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MutualTlsAuthentication, T> g) {
        return obj -> g.apply((MutualTlsAuthentication)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String truststoreUri;
        private String truststoreVersion;
        private List<String> truststoreWarnings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MutualTlsAuthentication model) {
            this.truststoreUri(model.truststoreUri);
            this.truststoreVersion(model.truststoreVersion);
            this.truststoreWarnings(model.truststoreWarnings);
        }

        public final String getTruststoreUri() {
            return this.truststoreUri;
        }

        @Override
        public final Builder truststoreUri(String truststoreUri) {
            this.truststoreUri = truststoreUri;
            return this;
        }

        public final void setTruststoreUri(String truststoreUri) {
            this.truststoreUri = truststoreUri;
        }

        public final String getTruststoreVersion() {
            return this.truststoreVersion;
        }

        @Override
        public final Builder truststoreVersion(String truststoreVersion) {
            this.truststoreVersion = truststoreVersion;
            return this;
        }

        public final void setTruststoreVersion(String truststoreVersion) {
            this.truststoreVersion = truststoreVersion;
        }

        public final Collection<String> getTruststoreWarnings() {
            return this.truststoreWarnings;
        }

        @Override
        public final Builder truststoreWarnings(Collection<String> truststoreWarnings) {
            this.truststoreWarnings = ListOfStringCopier.copy(truststoreWarnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder truststoreWarnings(String ... truststoreWarnings) {
            this.truststoreWarnings(Arrays.asList(truststoreWarnings));
            return this;
        }

        public final void setTruststoreWarnings(Collection<String> truststoreWarnings) {
            this.truststoreWarnings = ListOfStringCopier.copy(truststoreWarnings);
        }

        public MutualTlsAuthentication build() {
            return new MutualTlsAuthentication(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MutualTlsAuthentication> {
        public Builder truststoreUri(String var1);

        public Builder truststoreVersion(String var1);

        public Builder truststoreWarnings(Collection<String> var1);

        public Builder truststoreWarnings(String ... var1);
    }
}

