/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.PutMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportDocumentationPartsRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, ImportDocumentationPartsRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportDocumentationPartsRequest.getter(ImportDocumentationPartsRequest::restApiId)).setter(ImportDocumentationPartsRequest.setter(Builder::restApiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportDocumentationPartsRequest.getter(ImportDocumentationPartsRequest::modeAsString)).setter(ImportDocumentationPartsRequest.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("mode").build()}).build();
    private static final SdkField<Boolean> FAIL_ON_WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ImportDocumentationPartsRequest.getter(ImportDocumentationPartsRequest::failOnWarnings)).setter(ImportDocumentationPartsRequest.setter(Builder::failOnWarnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("failonwarnings").build()}).build();
    private static final SdkField<SdkBytes> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(ImportDocumentationPartsRequest.getter(ImportDocumentationPartsRequest::body)).setter(ImportDocumentationPartsRequest.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD, MODE_FIELD, FAIL_ON_WARNINGS_FIELD, BODY_FIELD));
    private final String restApiId;
    private final String mode;
    private final Boolean failOnWarnings;
    private final SdkBytes body;

    private ImportDocumentationPartsRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.mode = builder.mode;
        this.failOnWarnings = builder.failOnWarnings;
        this.body = builder.body;
    }

    public String restApiId() {
        return this.restApiId;
    }

    public PutMode mode() {
        return PutMode.fromValue(this.mode);
    }

    public String modeAsString() {
        return this.mode;
    }

    public Boolean failOnWarnings() {
        return this.failOnWarnings;
    }

    public SdkBytes body() {
        return this.body;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failOnWarnings());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportDocumentationPartsRequest)) {
            return false;
        }
        ImportDocumentationPartsRequest other = (ImportDocumentationPartsRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.failOnWarnings(), other.failOnWarnings()) && Objects.equals(this.body(), other.body());
    }

    public String toString() {
        return ToString.builder((String)"ImportDocumentationPartsRequest").add("RestApiId", (Object)this.restApiId()).add("Mode", (Object)this.modeAsString()).add("FailOnWarnings", (Object)this.failOnWarnings()).add("Body", (Object)this.body()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "failOnWarnings": {
                return Optional.ofNullable(clazz.cast(this.failOnWarnings()));
            }
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportDocumentationPartsRequest, T> g) {
        return obj -> g.apply((ImportDocumentationPartsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String mode;
        private Boolean failOnWarnings;
        private SdkBytes body;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportDocumentationPartsRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.mode(model.mode);
            this.failOnWarnings(model.failOnWarnings);
            this.body(model.body);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getMode() {
            return this.mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(PutMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public final Boolean getFailOnWarnings() {
            return this.failOnWarnings;
        }

        @Override
        public final Builder failOnWarnings(Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        public final void setFailOnWarnings(Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
        }

        public final ByteBuffer getBody() {
            return this.body == null ? null : this.body.asByteBuffer();
        }

        @Override
        public final Builder body(SdkBytes body) {
            this.body = StandardMemberCopier.copy((SdkBytes)body);
            return this;
        }

        public final void setBody(ByteBuffer body) {
            this.body(body == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)body));
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportDocumentationPartsRequest build() {
            return new ImportDocumentationPartsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportDocumentationPartsRequest> {
        public Builder restApiId(String var1);

        public Builder mode(String var1);

        public Builder mode(PutMode var1);

        public Builder failOnWarnings(Boolean var1);

        public Builder body(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

