/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToBooleanCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMethodResponseResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, UpdateMethodResponseResponse> {
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateMethodResponseResponse.getter(UpdateMethodResponseResponse::statusCode)).setter(UpdateMethodResponseResponse.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()}).build();
    private static final SdkField<Map<String, Boolean>> RESPONSE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(UpdateMethodResponseResponse.getter(UpdateMethodResponseResponse::responseParameters)).setter(UpdateMethodResponseResponse.setter(Builder::responseParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> RESPONSE_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(UpdateMethodResponseResponse.getter(UpdateMethodResponseResponse::responseModels)).setter(UpdateMethodResponseResponse.setter(Builder::responseModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseModels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODE_FIELD, RESPONSE_PARAMETERS_FIELD, RESPONSE_MODELS_FIELD));
    private final String statusCodeValue;
    private final Map<String, Boolean> responseParameters;
    private final Map<String, String> responseModels;

    private UpdateMethodResponseResponse(BuilderImpl builder) {
        super(builder);
        this.statusCodeValue = builder.statusCodeValue;
        this.responseParameters = builder.responseParameters;
        this.responseModels = builder.responseModels;
    }

    public String statusCode() {
        return this.statusCodeValue;
    }

    public boolean hasResponseParameters() {
        return this.responseParameters != null && !(this.responseParameters instanceof SdkAutoConstructMap);
    }

    public Map<String, Boolean> responseParameters() {
        return this.responseParameters;
    }

    public boolean hasResponseModels() {
        return this.responseModels != null && !(this.responseModels instanceof SdkAutoConstructMap);
    }

    public Map<String, String> responseModels() {
        return this.responseModels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseModels());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMethodResponseResponse)) {
            return false;
        }
        UpdateMethodResponseResponse other = (UpdateMethodResponseResponse)((Object)obj);
        return Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.responseParameters(), other.responseParameters()) && Objects.equals(this.responseModels(), other.responseModels());
    }

    public String toString() {
        return ToString.builder((String)"UpdateMethodResponseResponse").add("StatusCode", (Object)this.statusCode()).add("ResponseParameters", this.responseParameters()).add("ResponseModels", this.responseModels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "responseParameters": {
                return Optional.ofNullable(clazz.cast(this.responseParameters()));
            }
            case "responseModels": {
                return Optional.ofNullable(clazz.cast(this.responseModels()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMethodResponseResponse, T> g) {
        return obj -> g.apply((UpdateMethodResponseResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String statusCodeValue;
        private Map<String, Boolean> responseParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> responseModels = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMethodResponseResponse model) {
            super(model);
            this.statusCode(model.statusCodeValue);
            this.responseParameters(model.responseParameters);
            this.responseModels(model.responseModels);
        }

        public final String getStatusCode() {
            return this.statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        public final Map<String, Boolean> getResponseParameters() {
            return this.responseParameters;
        }

        @Override
        public final Builder responseParameters(Map<String, Boolean> responseParameters) {
            this.responseParameters = MapOfStringToBooleanCopier.copy(responseParameters);
            return this;
        }

        public final void setResponseParameters(Map<String, Boolean> responseParameters) {
            this.responseParameters = MapOfStringToBooleanCopier.copy(responseParameters);
        }

        public final Map<String, String> getResponseModels() {
            return this.responseModels;
        }

        @Override
        public final Builder responseModels(Map<String, String> responseModels) {
            this.responseModels = MapOfStringToStringCopier.copy(responseModels);
            return this;
        }

        public final void setResponseModels(Map<String, String> responseModels) {
            this.responseModels = MapOfStringToStringCopier.copy(responseModels);
        }

        @Override
        public UpdateMethodResponseResponse build() {
            return new UpdateMethodResponseResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMethodResponseResponse> {
        public Builder statusCode(String var1);

        public Builder responseParameters(Map<String, Boolean> var1);

        public Builder responseModels(Map<String, String> var1);
    }
}

