/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayClient;
import software.amazon.awssdk.services.apigateway.model.BasePathMapping;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse;

public class GetBasePathMappingsIterable
implements SdkIterable<GetBasePathMappingsResponse> {
    private final ApiGatewayClient client;
    private final GetBasePathMappingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetBasePathMappingsIterable(ApiGatewayClient client, GetBasePathMappingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetBasePathMappingsResponseFetcher();
    }

    public Iterator<GetBasePathMappingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BasePathMapping> items() {
        Function<GetBasePathMappingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final GetBasePathMappingsIterable resume(GetBasePathMappingsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetBasePathMappingsIterable(this.client, (GetBasePathMappingsRequest)((Object)this.firstRequest.toBuilder().position(lastSuccessfulPage.position()).build()));
        }
        return new GetBasePathMappingsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetBasePathMappingsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetBasePathMappingsResponseFetcher
    implements SyncPageFetcher<GetBasePathMappingsResponse> {
        private GetBasePathMappingsResponseFetcher() {
        }

        public boolean hasNextPage(GetBasePathMappingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public GetBasePathMappingsResponse nextPage(GetBasePathMappingsResponse previousPage) {
            if (previousPage == null) {
                return GetBasePathMappingsIterable.this.client.getBasePathMappings(GetBasePathMappingsIterable.this.firstRequest);
            }
            return GetBasePathMappingsIterable.this.client.getBasePathMappings((GetBasePathMappingsRequest)((Object)GetBasePathMappingsIterable.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

