/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.VpcLink;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VpcLinkMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<List> TARGETARNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetArns").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusMessage").isBinary(false).build();
    private static final VpcLinkMarshaller INSTANCE = new VpcLinkMarshaller();

    private VpcLinkMarshaller() {
    }

    public static VpcLinkMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VpcLink vpcLink, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)vpcLink, (String)"vpcLink");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)vpcLink.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)vpcLink.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)vpcLink.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(vpcLink.targetArns(), TARGETARNS_BINDING);
            protocolMarshaller.marshall((Object)vpcLink.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)vpcLink.statusMessage(), STATUSMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

