/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutIntegrationRequestModelMarshaller {
    private static final MarshallingInfo<String> RESTAPIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("restapi_id").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("resource_id").isBinary(false).build();
    private static final MarshallingInfo<String> HTTPMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("http_method").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<String> INTEGRATIONHTTPMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("httpMethod").isBinary(false).build();
    private static final MarshallingInfo<String> URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uri").isBinary(false).build();
    private static final MarshallingInfo<String> CONNECTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectionType").isBinary(false).build();
    private static final MarshallingInfo<String> CONNECTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectionId").isBinary(false).build();
    private static final MarshallingInfo<String> CREDENTIALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("credentials").isBinary(false).build();
    private static final MarshallingInfo<Map> REQUESTPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestParameters").isBinary(false).build();
    private static final MarshallingInfo<Map> REQUESTTEMPLATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestTemplates").isBinary(false).build();
    private static final MarshallingInfo<String> PASSTHROUGHBEHAVIOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("passthroughBehavior").isBinary(false).build();
    private static final MarshallingInfo<String> CACHENAMESPACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cacheNamespace").isBinary(false).build();
    private static final MarshallingInfo<List> CACHEKEYPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cacheKeyParameters").isBinary(false).build();
    private static final MarshallingInfo<String> CONTENTHANDLING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contentHandling").isBinary(false).build();
    private static final MarshallingInfo<Integer> TIMEOUTINMILLIS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeoutInMillis").isBinary(false).build();
    private static final PutIntegrationRequestModelMarshaller INSTANCE = new PutIntegrationRequestModelMarshaller();

    private PutIntegrationRequestModelMarshaller() {
    }

    public static PutIntegrationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PutIntegrationRequest putIntegrationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)putIntegrationRequest), (String)"putIntegrationRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)putIntegrationRequest.restApiId(), RESTAPIID_BINDING);
            protocolMarshaller.marshall((Object)putIntegrationRequest.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)putIntegrationRequest.httpMethod(), HTTPMETHOD_BINDING);
            protocolMarshaller.marshall((Object)putIntegrationRequest.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)putIntegrationRequest.integrationHttpMethod(), INTEGRATIONHTTPMETHOD_BINDING);
            protocolMarshaller.marshall((Object)putIntegrationRequest.uri(), URI_BINDING);
            protocolMarshaller.marshall((Object)putIntegrationRequest.connectionTypeAsString(), CONNECTIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)putIntegrationRequest.connectionId(), CONNECTIONID_BINDING);
            protocolMarshaller.marshall((Object)putIntegrationRequest.credentials(), CREDENTIALS_BINDING);
            protocolMarshaller.marshall(putIntegrationRequest.requestParameters(), REQUESTPARAMETERS_BINDING);
            protocolMarshaller.marshall(putIntegrationRequest.requestTemplates(), REQUESTTEMPLATES_BINDING);
            protocolMarshaller.marshall((Object)putIntegrationRequest.passthroughBehavior(), PASSTHROUGHBEHAVIOR_BINDING);
            protocolMarshaller.marshall((Object)putIntegrationRequest.cacheNamespace(), CACHENAMESPACE_BINDING);
            protocolMarshaller.marshall(putIntegrationRequest.cacheKeyParameters(), CACHEKEYPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)putIntegrationRequest.contentHandlingAsString(), CONTENTHANDLING_BINDING);
            protocolMarshaller.marshall((Object)putIntegrationRequest.timeoutInMillis(), TIMEOUTINMILLIS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

