/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.MethodSnapshot;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MethodSnapshotMarshaller {
    private static final MarshallingInfo<String> AUTHORIZATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizationType").isBinary(false).build();
    private static final MarshallingInfo<Boolean> APIKEYREQUIRED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("apiKeyRequired").isBinary(false).build();
    private static final MethodSnapshotMarshaller INSTANCE = new MethodSnapshotMarshaller();

    private MethodSnapshotMarshaller() {
    }

    public static MethodSnapshotMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MethodSnapshot methodSnapshot, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)methodSnapshot, (String)"methodSnapshot");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)methodSnapshot.authorizationType(), AUTHORIZATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)methodSnapshot.apiKeyRequired(), APIKEYREQUIRED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

