/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.model.CreateDomainNameRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateDomainNameRequestModelMarshaller {
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("domainName").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateName").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATEBODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateBody").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATEPRIVATEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificatePrivateKey").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATECHAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateChain").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateArn").isBinary(false).build();
    private static final MarshallingInfo<String> REGIONALCERTIFICATENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("regionalCertificateName").isBinary(false).build();
    private static final MarshallingInfo<String> REGIONALCERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("regionalCertificateArn").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENDPOINTCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endpointConfiguration").isBinary(false).build();
    private static final CreateDomainNameRequestModelMarshaller INSTANCE = new CreateDomainNameRequestModelMarshaller();

    private CreateDomainNameRequestModelMarshaller() {
    }

    public static CreateDomainNameRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateDomainNameRequest createDomainNameRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createDomainNameRequest), (String)"createDomainNameRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createDomainNameRequest.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall((Object)createDomainNameRequest.certificateName(), CERTIFICATENAME_BINDING);
            protocolMarshaller.marshall((Object)createDomainNameRequest.certificateBody(), CERTIFICATEBODY_BINDING);
            protocolMarshaller.marshall((Object)createDomainNameRequest.certificatePrivateKey(), CERTIFICATEPRIVATEKEY_BINDING);
            protocolMarshaller.marshall((Object)createDomainNameRequest.certificateChain(), CERTIFICATECHAIN_BINDING);
            protocolMarshaller.marshall((Object)createDomainNameRequest.certificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)createDomainNameRequest.regionalCertificateName(), REGIONALCERTIFICATENAME_BINDING);
            protocolMarshaller.marshall((Object)createDomainNameRequest.regionalCertificateArn(), REGIONALCERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)createDomainNameRequest.endpointConfiguration(), ENDPOINTCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

