/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.transform.UsagePlanKeyMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UsagePlanKey
implements StructuredPojo,
ToCopyableBuilder<Builder, UsagePlanKey> {
    private final String id;
    private final String type;
    private final String value;
    private final String name;

    private UsagePlanKey(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.value = builder.value;
        this.name = builder.name;
    }

    public String id() {
        return this.id;
    }

    public String type() {
        return this.type;
    }

    public String value() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsagePlanKey)) {
            return false;
        }
        UsagePlanKey other = (UsagePlanKey)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"UsagePlanKey").add("Id", (Object)this.id()).add("Type", (Object)this.type()).add("Value", (Object)this.value()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UsagePlanKeyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String type;
        private String value;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UsagePlanKey model) {
            this.id(model.id);
            this.type(model.type);
            this.value(model.value);
            this.name(model.name);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public UsagePlanKey build() {
            return new UsagePlanKey(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UsagePlanKey> {
        public Builder id(String var1);

        public Builder type(String var1);

        public Builder value(String var1);

        public Builder name(String var1);
    }
}

