/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.transform.ThrottleSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThrottleSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, ThrottleSettings> {
    private final Integer burstLimit;
    private final Double rateLimit;

    private ThrottleSettings(BuilderImpl builder) {
        this.burstLimit = builder.burstLimit;
        this.rateLimit = builder.rateLimit;
    }

    public Integer burstLimit() {
        return this.burstLimit;
    }

    public Double rateLimit() {
        return this.rateLimit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.burstLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateLimit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThrottleSettings)) {
            return false;
        }
        ThrottleSettings other = (ThrottleSettings)obj;
        return Objects.equals(this.burstLimit(), other.burstLimit()) && Objects.equals(this.rateLimit(), other.rateLimit());
    }

    public String toString() {
        return ToString.builder((String)"ThrottleSettings").add("BurstLimit", (Object)this.burstLimit()).add("RateLimit", (Object)this.rateLimit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "burstLimit": {
                return Optional.ofNullable(clazz.cast(this.burstLimit()));
            }
            case "rateLimit": {
                return Optional.ofNullable(clazz.cast(this.rateLimit()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThrottleSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer burstLimit;
        private Double rateLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(ThrottleSettings model) {
            this.burstLimit(model.burstLimit);
            this.rateLimit(model.rateLimit);
        }

        public final Integer getBurstLimit() {
            return this.burstLimit;
        }

        @Override
        public final Builder burstLimit(Integer burstLimit) {
            this.burstLimit = burstLimit;
            return this;
        }

        public final void setBurstLimit(Integer burstLimit) {
            this.burstLimit = burstLimit;
        }

        public final Double getRateLimit() {
            return this.rateLimit;
        }

        @Override
        public final Builder rateLimit(Double rateLimit) {
            this.rateLimit = rateLimit;
            return this;
        }

        public final void setRateLimit(Double rateLimit) {
            this.rateLimit = rateLimit;
        }

        public ThrottleSettings build() {
            return new ThrottleSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ThrottleSettings> {
        public Builder burstLimit(Integer var1);

        public Builder rateLimit(Double var1);
    }
}

