/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetExportRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, GetExportRequest> {
    private final String restApiId;
    private final String stageName;
    private final String exportType;
    private final Map<String, String> parameters;
    private final String accepts;

    private GetExportRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.stageName = builder.stageName;
        this.exportType = builder.exportType;
        this.parameters = builder.parameters;
        this.accepts = builder.accepts;
    }

    public String restApiId() {
        return this.restApiId;
    }

    public String stageName() {
        return this.stageName;
    }

    public String exportType() {
        return this.exportType;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public String accepts() {
        return this.accepts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportType());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.accepts());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExportRequest)) {
            return false;
        }
        GetExportRequest other = (GetExportRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.stageName(), other.stageName()) && Objects.equals(this.exportType(), other.exportType()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.accepts(), other.accepts());
    }

    public String toString() {
        return ToString.builder((String)"GetExportRequest").add("RestApiId", (Object)this.restApiId()).add("StageName", (Object)this.stageName()).add("ExportType", (Object)this.exportType()).add("Parameters", this.parameters()).add("Accepts", (Object)this.accepts()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "stageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
            case "exportType": {
                return Optional.ofNullable(clazz.cast(this.exportType()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "accepts": {
                return Optional.ofNullable(clazz.cast(this.accepts()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String stageName;
        private String exportType;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String accepts;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExportRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.stageName(model.stageName);
            this.exportType(model.exportType);
            this.parameters(model.parameters);
            this.accepts(model.accepts);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getStageName() {
            return this.stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getExportType() {
            return this.exportType;
        }

        @Override
        public final Builder exportType(String exportType) {
            this.exportType = exportType;
            return this;
        }

        public final void setExportType(String exportType) {
            this.exportType = exportType;
        }

        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = MapOfStringToStringCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = MapOfStringToStringCopier.copy(parameters);
        }

        public final String getAccepts() {
            return this.accepts;
        }

        @Override
        public final Builder accepts(String accepts) {
            this.accepts = accepts;
            return this;
        }

        public final void setAccepts(String accepts) {
            this.accepts = accepts;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetExportRequest build() {
            return new GetExportRequest(this);
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    CopyableBuilder<Builder, GetExportRequest> {
        public Builder restApiId(String var1);

        public Builder stageName(String var1);

        public Builder exportType(String var1);

        public Builder parameters(Map<String, String> var1);

        public Builder accepts(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

