/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.DomainName;
import software.amazon.awssdk.services.apigateway.model.ListOfDomainNameCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDomainNamesResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, GetDomainNamesResponse> {
    private final String position;
    private final List<DomainName> items;

    private GetDomainNamesResponse(BuilderImpl builder) {
        super(builder);
        this.position = builder.position;
        this.items = builder.items;
    }

    public String position() {
        return this.position;
    }

    public List<DomainName> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.position());
        hashCode = 31 * hashCode + Objects.hashCode(this.items());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainNamesResponse)) {
            return false;
        }
        GetDomainNamesResponse other = (GetDomainNamesResponse)((Object)obj);
        return Objects.equals(this.position(), other.position()) && Objects.equals(this.items(), other.items());
    }

    public String toString() {
        return ToString.builder((String)"GetDomainNamesResponse").add("Position", (Object)this.position()).add("Items", this.items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String position;
        private List<DomainName> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainNamesResponse model) {
            super(model);
            this.position(model.position);
            this.items(model.items);
        }

        public final String getPosition() {
            return this.position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        public final Collection<DomainName.Builder> getItems() {
            return this.items != null ? (Collection)this.items.stream().map(DomainName::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<DomainName> items) {
            this.items = ListOfDomainNameCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(DomainName ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<DomainName.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (DomainName)((DomainName.Builder)DomainName.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<DomainName.BuilderImpl> items) {
            this.items = ListOfDomainNameCopier.copyFromBuilder(items);
        }

        @Override
        public GetDomainNamesResponse build() {
            return new GetDomainNamesResponse(this);
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    CopyableBuilder<Builder, GetDomainNamesResponse> {
        public Builder position(String var1);

        public Builder items(Collection<DomainName> var1);

        public Builder items(DomainName ... var1);

        public Builder items(Consumer<DomainName.Builder> ... var1);
    }
}

